/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicChest;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.vehicle.EntityMinecart;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

public class EntityRendererMinecart
extends EntityRenderer<EntityMinecart> {
    public EntityRendererMinecart() {
        super(0.5f);
    }

    @Override
    public void render(@NotNull Tessellator tessellator, @NotNull EntityMinecart minecart, double x, double y, double z, float yaw, float partialTick) {
        GL11.glEnable(32826);
        GL11.glPushMatrix();
        double lerpX = MathHelper.lerp(minecart.xo, minecart.x, (double)partialTick);
        double lerpY = MathHelper.lerp(minecart.yo, minecart.y, (double)partialTick);
        double lerpZ = MathHelper.lerp(minecart.zo, minecart.z, (double)partialTick);
        Vec3 vec3 = minecart.getPos(lerpX, lerpY, lerpZ);
        double lerpXRot = MathHelper.lerp(minecart.xRotO, minecart.xRot, partialTick);
        double renderX = x;
        double renderY = y;
        double renderZ = z;
        double renderYaw = yaw;
        boolean doAFlip = false;
        if (vec3 != null) {
            Vec3 realVecVec;
            double scalar = 0.3;
            Vec3 forVec = minecart.getPosOffs(lerpX, lerpY, lerpZ, 0.3);
            Vec3 backVec = minecart.getPosOffs(lerpX, lerpY, lerpZ, -0.3);
            if (forVec == null) {
                forVec = vec3;
            }
            if (backVec == null) {
                backVec = vec3;
            }
            renderX += vec3.x - lerpX;
            renderY += (forVec.y + backVec.y) / 2.0 - lerpY;
            renderZ += vec3.z - lerpZ;
            Vec3 velVec = backVec.add(-forVec.x, -forVec.y, -forVec.z);
            if (velVec.length() != 0.0) {
                velVec = velVec.normalize();
                renderYaw = Math.toDegrees(Math.atan2(velVec.z, velVec.x));
                lerpXRot = Math.atan(velVec.y) * 73.0;
            }
            doAFlip = velVec.dotProduct(realVecVec = Vec3.fromPool(minecart.xd, minecart.yd, minecart.zd)) < 0.0;
        }
        GL11.glTranslated(renderX, renderY, renderZ);
        GL11.glRotated(180.0 - renderYaw, 0.0, 1.0, 0.0);
        GL11.glRotated(-lerpXRot, 0.0, 0.0, 1.0);
        double hurtAngle = (float)minecart.timeSinceHit - partialTick;
        double currentDamage = (float)minecart.currentDamage - partialTick;
        if (currentDamage < 0.0) {
            currentDamage = 0.0;
        }
        if (hurtAngle > 0.0) {
            GL11.glRotated(Math.sin(hurtAngle) * hurtAngle * currentDamage / 10.0 * (double)minecart.hurtDirection, 1.0, 0.0, 0.0);
        }
        if (minecart.getType() != 0) {
            TextureRegistry.blockAtlas.bind();
            float scale = 0.75f;
            GL11.glScalef(0.75f, 0.75f, 0.75f);
            GL11.glTranslatef(0.0f, 0.3125f, 0.0f);
            GL11.glRotatef(90.0f, 0.0f, 1.0f, 0.0f);
            float brightness = 1.0f;
            if (LightmapHelper.isLightmapEnabled()) {
                LightmapHelper.setLightmapCoord(minecart.getLightmapCoord(partialTick));
            } else if (!Global.accessor.isFullbrightEnabled()) {
                brightness = minecart.getBrightness(partialTick);
            }
            GL11.glPushMatrix();
            if (doAFlip) {
                GL11.glRotatef(180.0f, 0.0f, 1.0f, 0.0f);
            }
            switch (minecart.getType()) {
                case 1: {
                    Block<BlockLogicChest> block = (minecart.getMeta() & 1) != 0 ? Blocks.CHEST_PLANKS_OAK_PAINTED : Blocks.CHEST_PLANKS_OAK;
                    ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(block)).renderStandalone(tessellator, minecart.getMeta(), brightness, 1.0f, null);
                    break;
                }
                case 2: {
                    if (minecart.getFuel() > 0) {
                        ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(Blocks.FURNACE_STONE_ACTIVE)).renderStandalone(tessellator, 0, brightness, 1.0f, null);
                        break;
                    }
                    ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(Blocks.FURNACE_STONE_IDLE)).renderStandalone(tessellator, 0, brightness, 1.0f, null);
                }
            }
            GL11.glPopMatrix();
            GL11.glRotatef(-90.0f, 0.0f, 1.0f, 0.0f);
            GL11.glTranslatef(0.0f, -0.3125f, 0.0f);
            GL11.glScalef(1.3333334f, 1.3333334f, 1.3333334f);
        }
        this.bindTexture("/assets/minecraft/textures/entity/cart.png");
        GL11.glScalef(0.0625f, 0.0625f, -0.0625f);
        this.getModel("main").render(tessellator);
        GL11.glPopMatrix();
        GL11.glDisable(32826);
    }

    private static void drawDebugVec(Tessellator tessellator, Vec3 pos, Vec3 vec, double scale, float r, float g, float b, float a) {
        if (pos == null || vec == null) {
            return;
        }
        GL11.glLineWidth(10.0f);
        GL11.glDisable(2896);
        GL11.glDisable(3553);
        tessellator.startDrawing(1);
        tessellator.setColorRGBA_F(r, g, b, a);
        tessellator.addVertex(pos.x, pos.y, pos.z);
        tessellator.addVertex(pos.x + vec.x * scale, pos.y + vec.y * scale, pos.z + vec.z * scale);
        tessellator.draw();
        GL11.glEnable(3553);
        GL11.glEnable(2896);
    }
}

