/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tileentity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.TileEntityRenderDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.BlockModelPiston;
import net.minecraft.client.render.block.model.BlockModelPistonHead;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.render.tileentity.TileEntityRenderer;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.piston.BlockLogicPistonBaseSteel;
import net.minecraft.core.block.piston.BlockLogicPistonHead;
import net.minecraft.core.block.piston.TileEntityMovingPistonBlock;
import net.minecraft.core.world.BlocksContainer;
import org.lwjgl.opengl.GL11;

public class TileEntityRendererMovingPiston
extends TileEntityRenderer<TileEntityMovingPistonBlock> {
    private final Minecraft mc = Minecraft.getMinecraft();
    private BlocksContainer container = null;

    @Override
    public void doRender(Tessellator tessellator, TileEntityMovingPistonBlock tileEntity, double x, double y, double z, float partialTick) {
        Block<BlockLogicPistonHead> block = Blocks.getBlock(tileEntity.getMovedId());
        if (block != null && tileEntity.getProgress(partialTick) < 1.0f) {
            if (this.container == null || this.container.world != tileEntity.worldObj) {
                this.container = new BlocksContainer(tileEntity.worldObj);
            }
            TextureRegistry.blockAtlas.bind();
            Lighting.disable();
            GL11.glBlendFunc(770, 771);
            GL11.glEnable(3042);
            GL11.glDisable(2884);
            if (this.mc.isAmbientOcclusionEnabled()) {
                GL11.glShadeModel(7425);
            } else {
                GL11.glShadeModel(7424);
            }
            tessellator.startDrawingQuads();
            tessellator.setTranslation((float)x - (float)tileEntity.x + tileEntity.getXOff(partialTick), (float)y - (float)tileEntity.y + tileEntity.getYOff(partialTick), (float)z - (float)tileEntity.z + tileEntity.getZOff(partialTick));
            if (Block.hasLogicClass(block, BlockLogicPistonHead.class) && tileEntity.getProgress(partialTick) < 0.5f) {
                ((BlockModelPistonHead)BlockModelDispatcher.getInstance().getDispatch(block)).renderPistonHeadNoCulling(tessellator, tileEntity.worldObj, block, tileEntity.x, tileEntity.y, tileEntity.z, false);
            } else if (tileEntity.isSourcePiston() && !tileEntity.isExtending()) {
                BlockModelPiston pistonBase = (BlockModelPiston)BlockModelDispatcher.getInstance().getDispatch(block);
                if (Block.hasLogicClass(block, BlockLogicPistonBaseSteel.class)) {
                    blockModelPistonHead = (BlockModelPistonHead)BlockModelDispatcher.getInstance().getDispatch(Blocks.PISTON_HEAD_STEEL);
                    blockModelPistonHead.setFaceTextureOverride(pistonBase.getFaceTexture());
                    blockModelPistonHead.renderPistonHeadNoCulling(tessellator, tileEntity.worldObj, Blocks.PISTON_HEAD_STEEL, tileEntity.x, tileEntity.y, tileEntity.z, tileEntity.getProgress(partialTick) < 0.5f);
                    blockModelPistonHead.setFaceTextureOverride(null);
                } else {
                    blockModelPistonHead = (BlockModelPistonHead)BlockModelDispatcher.getInstance().getDispatch(Blocks.PISTON_HEAD);
                    blockModelPistonHead.setFaceTextureOverride(pistonBase.getFaceTexture());
                    blockModelPistonHead.renderPistonHeadNoCulling(tessellator, tileEntity.worldObj, Blocks.PISTON_HEAD, tileEntity.x, tileEntity.y, tileEntity.z, tileEntity.getProgress(partialTick) < 0.5f);
                    blockModelPistonHead.setFaceTextureOverride(null);
                }
                tessellator.setTranslation((float)x - (float)tileEntity.x, (float)y - (float)tileEntity.y, (float)z - (float)tileEntity.z);
                pistonBase.renderHeadless(tessellator, tileEntity.worldObj, tileEntity.x, tileEntity.y, tileEntity.z);
            } else {
                this.container.setBlock(tileEntity.x, tileEntity.y, tileEntity.z, block.id(), tileEntity.getMovedData(), tileEntity.getMovedEntity());
                ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(block)).renderNoCulling(tessellator, this.container, tileEntity.x, tileEntity.y, tileEntity.z);
                this.container.setLightReferenceEntity(null);
                this.container.clear();
            }
            tessellator.setTranslation(0.0, 0.0, 0.0);
            tessellator.draw();
            Lighting.enableLight();
            TileEntity movedEntity = tileEntity.getMovedEntity();
            TileEntityRenderer<TileEntity> renderer = TileEntityRenderDispatcher.instance.getRenderer(movedEntity);
            if (renderer != null) {
                GL11.glPushMatrix();
                GL11.glTranslatef(tileEntity.getXOff(partialTick), tileEntity.getYOff(partialTick), tileEntity.getZOff(partialTick));
                renderer.doRender(tessellator, movedEntity, x, y, z, partialTick);
                GL11.glPopMatrix();
            }
        }
    }
}

