/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.config.season;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.world.config.season.SeasonConfig;
import net.minecraft.core.world.config.season.SeasonConfigCycle;
import net.minecraft.core.world.config.season.SeasonConfigSingle;
import net.minecraft.core.world.season.Season;
import org.jetbrains.annotations.NotNull;

public class SeasonConfigBuilder {
    private Type type = null;
    private List<Season> seasons = null;
    private Object2IntMap<Season> seasonLengthMap = null;
    private Season singleSeason = null;

    protected SeasonConfigBuilder() {
    }

    @NotNull
    public SeasonConfig build() {
        if (this.type == Type.SINGLE && this.singleSeason != null) {
            return new SeasonConfigSingle(this.singleSeason);
        }
        if (this.type == Type.CYCLE && this.seasons != null && this.seasonLengthMap != null) {
            return new SeasonConfigCycle(this.seasons, this.seasonLengthMap);
        }
        return null;
    }

    @NotNull
    public SeasonConfigBuilder withSingleSeason(Season season) {
        this.type = Type.SINGLE;
        this.seasons = null;
        this.seasonLengthMap = null;
        this.singleSeason = season;
        return this;
    }

    @NotNull
    public SeasonConfigBuilder withSeasonInCycle(Season season, int length) {
        this.type = Type.CYCLE;
        if (this.seasons == null) {
            this.seasons = new ArrayList<Season>();
        }
        this.seasons.add(season);
        if (this.seasonLengthMap == null) {
            this.seasonLengthMap = new Object2IntArrayMap<Season>();
        }
        this.seasonLengthMap.put(season, length);
        this.singleSeason = null;
        return this;
    }

    private static enum Type {
        SINGLE,
        CYCLE;

    }
}

