/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.feature;

import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.MethodParametersAnnotation;
import net.minecraft.core.world.generate.feature.WorldFeature;
import org.jetbrains.annotations.NotNull;

public class WorldFeatureMoss
extends WorldFeature {
    private int minableBlockId;
    private int numberOfBlocks;
    private final Int2IntArrayMap variantMap;

    @MethodParametersAnnotation(names={"blockId", "numberOfBlocks"})
    public WorldFeatureMoss(int blockId, int numberOfBlocks) {
        this.minableBlockId = blockId;
        this.numberOfBlocks = numberOfBlocks;
        this.variantMap = null;
    }

    @MethodParametersAnnotation(names={"blockId", "numberOfBlocks", "variantMap"})
    public WorldFeatureMoss(@NotNull Int2IntArrayMap variantMap, int numberOfBlocks) {
        this.numberOfBlocks = numberOfBlocks;
        this.variantMap = variantMap;
    }

    @Override
    public boolean place(World world, Random random, int xStart, int yStart, int zStart) {
        float f = random.nextFloat() * (float)Math.PI;
        double xMax = (float)(xStart + 8) + MathHelper.sin(f) * (float)this.numberOfBlocks / 8.0f;
        double xMin = (float)(xStart + 8) - MathHelper.sin(f) * (float)this.numberOfBlocks / 8.0f;
        double zMax = (float)(zStart + 8) + MathHelper.cos(f) * (float)this.numberOfBlocks / 8.0f;
        double zMin = (float)(zStart + 8) - MathHelper.cos(f) * (float)this.numberOfBlocks / 8.0f;
        double yMax = yStart + random.nextInt(3) + 2;
        double yMin = yStart - random.nextInt(3) + 2;
        for (int l = 0; l <= this.numberOfBlocks; ++l) {
            double d6 = xMax + (xMin - xMax) * (double)l / (double)this.numberOfBlocks;
            double d7 = yMax + (yMin - yMax) * (double)l / (double)this.numberOfBlocks;
            double d8 = zMax + (zMin - zMax) * (double)l / (double)this.numberOfBlocks;
            double d9 = random.nextDouble() * (double)this.numberOfBlocks / 16.0;
            double d10 = (double)(MathHelper.sin((float)l * (float)Math.PI / (float)this.numberOfBlocks) + 1.0f) * d9 + 1.0;
            double d11 = (double)(MathHelper.sin((float)l * (float)Math.PI / (float)this.numberOfBlocks) + 1.0f) * d9 + 1.0;
            int xVeinStart = MathHelper.floor(d6 - d10 / 2.0);
            int yVeinStart = MathHelper.floor(d7 - d11 / 2.0);
            int zVeinStart = MathHelper.floor(d8 - d10 / 2.0);
            int xVeinEnd = MathHelper.floor(d6 + d10 / 2.0);
            int yVeinEnd = MathHelper.floor(d7 + d11 / 2.0);
            int zVeinEnd = MathHelper.floor(d8 + d10 / 2.0);
            for (int x = xVeinStart; x <= xVeinEnd; ++x) {
                double d12 = ((double)x + 0.5 - d6) / (d10 / 2.0);
                if (d12 * d12 >= 1.0) continue;
                for (int y = yVeinStart; y <= yVeinEnd; ++y) {
                    double d13 = ((double)y + 0.5 - d7) / (d11 / 2.0);
                    if (d12 * d12 + d13 * d13 >= 1.0) continue;
                    for (int z = zVeinStart; z <= zVeinEnd; ++z) {
                        double d14 = ((double)z + 0.5 - d8) / (d10 / 2.0);
                        if (!(d12 * d12 + d13 * d13 + d14 * d14 < 1.0) || !this.airExposed(world, x, y, z)) continue;
                        if (this.variantMap != null) {
                            int blockId = world.getBlockId(x, y, z);
                            if (blockId <= 0 || !this.variantMap.containsKey(blockId)) continue;
                            world.setBlock(x, y, z, this.variantMap.get(blockId));
                            continue;
                        }
                        int id = world.getBlockId(x, y, z);
                        if (id != Blocks.STONE.id() && id != Blocks.COBBLE_NETHERRACK.id() && id != Blocks.BASALT.id() && id != Blocks.LIMESTONE.id() && id != Blocks.GRANITE.id()) continue;
                        world.setBlock(x, y, z, this.minableBlockId);
                    }
                }
            }
        }
        return true;
    }

    public boolean airExposed(@NotNull World world, int x, int y, int z) {
        for (int i = 0; i < Side.sides.length; ++i) {
            Side s = Side.sides[i];
            if (!world.isAirBlock(x + s.getOffsetX(), y + s.getOffsetY(), z + s.getOffsetZ())) continue;
            return true;
        }
        return false;
    }
}

