/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.render.OpenGLHelper;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.render.window.CursorShape;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.Nullable;

public class ClickableLabelElement
extends ButtonElement {
    private int textColor;
    private int bgColor;
    private boolean shadow = true;
    @Nullable
    private final IconCoordinate icon;

    public ClickableLabelElement(int id, int xPosition, int yPosition, String s, int textColor, int bgColor, @Nullable String icon) {
        super(id, xPosition, yPosition, s);
        this.textColor = textColor;
        this.bgColor = bgColor;
        this.height = 12;
        this.width = 0;
        this.icon = icon != null ? TextureRegistry.getTexture(icon) : null;
    }

    public ClickableLabelElement(int id, int xPosition, int yPosition, String s, int textColor, int bgColor) {
        this(id, xPosition, yPosition, s, textColor, bgColor, null);
    }

    public ClickableLabelElement(int id, int xPosition, int yPosition, String s, int textColor, @Nullable String icon) {
        this(id, xPosition, yPosition, s, textColor, 0x7F000000, icon);
    }

    public ClickableLabelElement(int id, int xPosition, int yPosition, String s, int textColor) {
        this(id, xPosition, yPosition, s, textColor, null);
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public int getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(int bgColor) {
        this.bgColor = bgColor;
    }

    public boolean isShadow() {
        return this.shadow;
    }

    public void setShadow(boolean shadow) {
        this.shadow = shadow;
    }

    @Override
    public void drawButton(Minecraft mc, int mouseX, int mouseY) {
        boolean hovered;
        if (!this.visible) {
            return;
        }
        boolean bl = hovered = mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
        if (hovered && this.enabled) {
            mc.currentScreen.setDesiredCursor(CursorShape.HAND);
        }
        this.width = this.icon != null ? (hovered && this.enabled ? 2 + this.icon.width + 4 + MathHelper.ceil(mc.font.stringWidthDouble(this.displayString)) + 2 : 2 + this.icon.width + 2) : MathHelper.ceil(mc.font.stringWidthDouble(this.displayString)) + 4;
        this.drawRect(this.xPosition, this.yPosition, this.xPosition + this.width, this.yPosition + this.height, this.enabled ? (hovered ? 2139128000 : this.bgColor) : 0);
        if (this.icon != null) {
            if (hovered) {
                if (this.shadow) {
                    OpenGLHelper.glColor1i(ClickableLabelElement.makeShadow(-96));
                    this.drawGuiIcon(this.xPosition + 3, this.yPosition + 2, this.icon.width, this.icon.height, this.icon);
                    OpenGLHelper.glColor1i(-96);
                    this.drawGuiIcon(this.xPosition + 2, this.yPosition + 1, this.icon.width, this.icon.height, this.icon);
                    this.drawStringShadow(mc.font, this.displayString, this.xPosition + 4 + this.icon.width + 2, this.yPosition + 2, -96);
                } else {
                    OpenGLHelper.glColor1i(-96);
                    this.drawGuiIcon(this.xPosition + 2, this.yPosition + 1, this.icon.width, this.icon.height, this.icon);
                    this.drawStringNoShadow(mc.font, this.displayString, this.xPosition + 4 + this.icon.width + 2, this.yPosition + 2, -96);
                }
            } else if (this.shadow) {
                OpenGLHelper.glColor1i(ClickableLabelElement.makeShadow(this.textColor));
                this.drawGuiIcon(this.xPosition + 3, this.yPosition + 2, this.icon.width, this.icon.height, this.icon);
                OpenGLHelper.glColor1i(this.textColor);
                this.drawGuiIcon(this.xPosition + 2, this.yPosition + 1, this.icon.width, this.icon.height, this.icon);
            } else {
                OpenGLHelper.glColor1i(this.textColor);
                this.drawGuiIcon(this.xPosition + 2, this.yPosition + 1, this.icon.width, this.icon.height, this.icon);
            }
        } else if (this.enabled && (this.shadow || hovered)) {
            this.drawStringShadow(mc.font, this.displayString, this.xPosition + 4, this.yPosition + 2, hovered ? -96 : this.textColor);
        } else {
            this.drawStringNoShadow(mc.font, this.displayString, this.xPosition + 4, this.yPosition + 2, -8421505);
        }
        this.mouseDragged(mc, mouseX, mouseY);
    }

    private static int makeShadow(int argb) {
        return (argb & 0xFCFCFC) >> 2 | argb & 0xFF000000;
    }
}

