/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.chunk.perlin.overworld;

import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.generate.chunk.perlin.DensityGenerator;
import net.minecraft.core.world.noise.BasePerlinNoise;
import net.minecraft.core.world.noise.PerlinNoise;
import net.minecraft.core.world.type.WorldTypes;

public class DensityGeneratorOverworld
implements DensityGenerator {
    private final World world;
    private final BasePerlinNoise<?> minLimitNoise;
    private final BasePerlinNoise<?> maxLimitNoise;
    private final BasePerlinNoise<?> mainNoise;
    private final BasePerlinNoise<?> scaleNoise;
    private final BasePerlinNoise<?> depthNoise;
    private final boolean generateRivers;
    private final BasePerlinNoise<?> smoothingRiverNoise;
    private final BasePerlinNoise<?> carvingRiverNoise;

    protected DensityGeneratorOverworld(World world, BasePerlinNoise<?> minLimitNoise, BasePerlinNoise<?> maxLimitNoise, BasePerlinNoise<?> mainNoise, BasePerlinNoise<?> scaleNoise, BasePerlinNoise<?> depthNoise, boolean generateRivers) {
        this.world = world;
        this.minLimitNoise = minLimitNoise;
        this.maxLimitNoise = maxLimitNoise;
        this.mainNoise = mainNoise;
        this.scaleNoise = scaleNoise;
        this.depthNoise = depthNoise;
        this.generateRivers = generateRivers;
        this.smoothingRiverNoise = new PerlinNoise(world.getRandomSeed(), 1);
        this.carvingRiverNoise = new PerlinNoise(world.getRandomSeed() + 1L, 1);
    }

    public DensityGeneratorOverworld(World world) {
        this(world, new PerlinNoise(world.getRandomSeed(), 16, 0), new PerlinNoise(world.getRandomSeed(), 16, 16), new PerlinNoise(world.getRandomSeed(), 8, 32), new PerlinNoise(world.getRandomSeed(), 10, 48), new PerlinNoise(world.getRandomSeed(), 16, 58), true);
    }

    private void modifyDensityMapSmoothingRivers(int chunkX, int chunkZ, int terrainHeight, double[] densityMapArray) {
        int xSize = 5;
        int ySize = terrainHeight / 8 + 1;
        int zSize = 5;
        int x = chunkX * 4;
        int z = chunkZ * 4;
        double riverLevel = 0.0;
        double[] largeSmoothing = this.smoothingRiverNoise.get(null, x, z, xSize, zSize, 1.0 / (1000.0 / (double)xSize), 1.0 / (1000.0 / (double)zSize));
        double[] mediumSmoothing = this.smoothingRiverNoise.get(null, x, z, xSize, zSize, 1.0 / (50.0 / (double)xSize), 1.0 / (50.0 / (double)zSize));
        double[] smallSmoothing = this.smoothingRiverNoise.get(null, x, z, xSize, zSize, 1.0 / (10.0 / (double)xSize), 1.0 / (10.0 / (double)zSize));
        double[] riverRadiuses = new double[]{0.006, 0.024, 0.036};
        double[] riverMults = new double[]{20.0, 60.0, 60.0};
        for (int dx = 0; dx < xSize; ++dx) {
            for (int dz = 0; dz < zSize; ++dz) {
                double sample = largeSmoothing[dx * zSize + dz] + mediumSmoothing[dx * zSize + dz] * 0.04 + smallSmoothing[dx * zSize + dz] * 0.004;
                double finalSample = 0.0;
                for (int i = 0; i < riverRadiuses.length; ++i) {
                    if (sample < riverLevel - riverRadiuses[i] || sample > riverLevel + riverRadiuses[i]) continue;
                    double modSample = sample;
                    modSample -= riverLevel;
                    modSample /= riverRadiuses[i];
                    modSample = Math.abs(modSample);
                    modSample = -modSample;
                    modSample += 1.0;
                    finalSample += (modSample *= riverMults[i]);
                }
                for (int dy = 0; dy < ySize; ++dy) {
                    if (dy < ySize / 2) {
                        int n = dx * ySize * zSize + dz * ySize + dy;
                        densityMapArray[n] = densityMapArray[n] - finalSample * ((double)dy / ((double)ySize / 2.0)) * ((double)dy / ((double)ySize / 2.0));
                        continue;
                    }
                    int n = dx * ySize * zSize + dz * ySize + dy;
                    densityMapArray[n] = densityMapArray[n] - finalSample;
                }
            }
        }
    }

    private void modifyDensityMapCarvingRivers(int chunkX, int chunkZ, int terrainHeight, double[] densityMapArray) {
        int xSize = 5;
        int ySize = terrainHeight / 8 + 1;
        int zSize = 5;
        int x = chunkX * 4;
        int z = chunkZ * 4;
        int maxUndergroundRiverHeight = 2;
        double riverLevel = 0.0;
        double[] largeCarving = this.carvingRiverNoise.get(null, x, z, xSize, zSize, 1.0 / (1000.0 / (double)xSize), 1.0 / (1000.0 / (double)zSize));
        double[] mediumCarving = this.carvingRiverNoise.get(null, x, z, xSize, zSize, 1.0 / (50.0 / (double)xSize), 1.0 / (50.0 / (double)zSize));
        double[] smallCarving = this.carvingRiverNoise.get(null, x, z, xSize, zSize, 1.0 / (10.0 / (double)xSize), 1.0 / (10.0 / (double)zSize));
        double[] riverRadiuses = new double[]{0.012, 0.018, 0.024};
        double[] riverMults = new double[]{20.0, 60.0, 60.0};
        for (int dx = 0; dx < xSize; ++dx) {
            for (int dz = 0; dz < zSize; ++dz) {
                double sample = largeCarving[dx * zSize + dz] + mediumCarving[dx * zSize + dz] * 0.04 + smallCarving[dx * zSize + dz] * 0.004;
                double finalSample = 0.0;
                for (int i = 0; i < riverRadiuses.length; ++i) {
                    if (sample < riverLevel - riverRadiuses[i] || sample > riverLevel + riverRadiuses[i]) continue;
                    double modSample = sample;
                    modSample -= riverLevel;
                    modSample /= riverRadiuses[i];
                    modSample = Math.abs(modSample);
                    modSample = -modSample;
                    modSample += 1.0;
                    finalSample += (modSample *= riverMults[i]);
                }
                if (finalSample <= 0.0) continue;
                for (int dy = ySize / 2 - maxUndergroundRiverHeight; dy < ySize / 2 + maxUndergroundRiverHeight; ++dy) {
                    double heightFactor = dy;
                    heightFactor -= (double)(ySize / 2);
                    heightFactor /= (double)maxUndergroundRiverHeight;
                    heightFactor = Math.abs(heightFactor);
                    heightFactor = -heightFactor;
                    int n = dx * ySize * zSize + dz * ySize + dy;
                    densityMapArray[n] = densityMapArray[n] - finalSample * (heightFactor += 1.0);
                }
            }
        }
    }

    @Override
    public double[] generateDensityMap(Chunk chunk) {
        int terrainHeight = this.world.getWorldType().getMaxY() + 1 - this.world.getWorldType().getMinY();
        int xSize = 5;
        int ySize = terrainHeight / 8 + 1;
        int zSize = 5;
        int x = chunk.pos.x * 4;
        boolean y = false;
        int z = chunk.pos.z * 4;
        double[] densityMapArray = new double[xSize * ySize * zSize];
        double mainNoiseScaleX = 80.0;
        double mainNoiseScaleY = 160.0;
        double mainNoiseScaleZ = 80.0;
        double scaleNoiseScaleX = 1.121;
        double scaleNoiseScaleZ = 1.121;
        double depthNoiseScaleX = 200.0;
        double depthNoiseScaleZ = 200.0;
        double depthBaseSize = this.world.getWorldType() == WorldTypes.OVERWORLD_AMPLIFIED ? 8.5 : (double)terrainHeight / 16.0 + 0.5;
        double coordScale = 684.412;
        double heightScale = 684.412;
        double heightStretch = 12.0;
        double upperLimitScale = this.world.getWorldType() == WorldTypes.OVERWORLD_AMPLIFIED ? 128.0 : 512.0;
        double lowerLimitScale = 512.0;
        double[] scaleArray = this.scaleNoise.get(null, x, z, xSize, zSize, 1.121, 1.121);
        double[] depthArray = this.depthNoise.get(null, x, z, xSize, zSize, 200.0, 200.0);
        double[] mainNoiseArray = this.mainNoise.get(null, x, (double)y, z, xSize, ySize, zSize, 8.555150000000001, 4.277575000000001, 8.555150000000001);
        double[] minLimitArray = this.minLimitNoise.get(null, x, (double)y, z, xSize, ySize, zSize, 684.412, 684.412, 684.412);
        double[] maxLimitArray = this.maxLimitNoise.get(null, x, (double)y, z, xSize, ySize, zSize, 684.412, 684.412, 684.412);
        int mainIndex = 0;
        int depthScaleIndex = 0;
        int xSizeScale = 16 / xSize;
        for (int dx = 0; dx < xSize; ++dx) {
            int ix = dx * xSizeScale + xSizeScale / 2;
            for (int dz = 0; dz < zSize; ++dz) {
                double depth;
                int iz = dz * xSizeScale + xSizeScale / 2;
                double temperature = chunk.temperature[ix * 16 + iz];
                double humidity = chunk.humidity[ix * 16 + iz] * temperature;
                humidity = 1.0 - humidity;
                humidity *= humidity;
                humidity *= humidity;
                humidity = 1.0 - humidity;
                double scale = (scaleArray[depthScaleIndex] + 256.0) / 512.0;
                if ((scale *= humidity) > 1.0) {
                    scale = 1.0;
                }
                if ((depth = depthArray[depthScaleIndex] / 8000.0) < 0.0) {
                    depth = -depth * 0.3;
                }
                if ((depth = depth * 3.0 - 2.0) < 0.0) {
                    if ((depth /= 2.0) < -1.0) {
                        depth = -1.0;
                    }
                    depth /= 1.4;
                    depth /= 2.0;
                    scale = 0.0;
                } else {
                    if (depth > 1.0) {
                        depth = 1.0;
                    }
                    depth /= 8.0;
                }
                if (scale < 0.0) {
                    scale = 0.0;
                }
                scale += 0.5;
                depth = depth * (depthBaseSize * 2.0) / 16.0;
                double offsetY = depthBaseSize + depth * 4.0;
                ++depthScaleIndex;
                for (int dy = 0; dy < ySize; ++dy) {
                    double densityOffset = ((double)dy - offsetY) * 12.0 / scale;
                    if (densityOffset < 0.0) {
                        densityOffset *= 4.0;
                    }
                    double minDensity = minLimitArray[mainIndex] / upperLimitScale;
                    double maxDensity = maxLimitArray[mainIndex] / 512.0;
                    double mainDensity = (mainNoiseArray[mainIndex] / 10.0 + 1.0) / 2.0;
                    double density = mainDensity < 0.0 ? minDensity : (mainDensity > 1.0 ? maxDensity : minDensity + (maxDensity - minDensity) * mainDensity);
                    density -= densityOffset;
                    if (dy > ySize - 4) {
                        double densityMod = (float)(dy - (ySize - 4)) / 3.0f;
                        density = density * (1.0 - densityMod) + -10.0 * densityMod;
                    }
                    densityMapArray[mainIndex] = density;
                    ++mainIndex;
                }
            }
        }
        if (this.generateRivers) {
            this.modifyDensityMapSmoothingRivers(chunk.pos.x, chunk.pos.z, terrainHeight, densityMapArray);
            this.modifyDensityMapCarvingRivers(chunk.pos.x, chunk.pos.z, terrainHeight, densityMapArray);
        }
        return densityMapArray;
    }
}

