/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.hud.component;

import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.hud.HudIngame;
import net.minecraft.client.gui.hud.component.ComponentAnchor;
import net.minecraft.client.gui.hud.component.HudComponentMovable;
import net.minecraft.client.gui.hud.component.layout.Layout;
import net.minecraft.client.gui.hud.component.layout.LayoutAbsolute;
import net.minecraft.client.gui.hud.component.layout.LayoutSnap;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.Global;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Utils;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.season.Season;
import net.minecraft.core.world.season.Seasons;
import net.minecraft.core.world.weather.Weather;
import net.minecraft.core.world.weather.Weathers;

public class HudComponentInfoOverlay
extends HudComponentMovable {
    public HudComponentInfoOverlay(String key, Layout layout) {
        super(key, 130, 112, layout);
    }

    @Override
    public boolean isVisible() {
        return HudComponentInfoOverlay.mc.gameSettings.immersiveMode.drawOverlays() && (Boolean)HudComponentInfoOverlay.mc.gameSettings.showDebugScreen.value == false;
    }

    private void drawString(String string, int x, int y, int argb, boolean rightAligned) {
        int xOffset = -2;
        if (rightAligned) {
            xOffset = HudComponentInfoOverlay.mc.font.stringWidth(string) + 2 - this.getXSize();
        }
        HudComponentInfoOverlay.mc.font.render(Tessellator.instance, string, x - xOffset, y).setShadow().setColor(argb).call();
    }

    @Override
    public void render(HudIngame hud, int xSizeScreen, int ySizeScreen, float partialTick) {
        ComponentAnchor anchor;
        Layout layout;
        int x = this.getLayout().getComponentX(this, xSizeScreen);
        int y = this.getLayout().getComponentY(this, ySizeScreen);
        boolean rightAligned = false;
        if (this.getLayout() instanceof LayoutAbsolute) {
            layout = (LayoutAbsolute)this.getLayout();
            anchor = ((LayoutAbsolute)layout).getAnchor();
            if (anchor == ComponentAnchor.TOP_RIGHT || anchor == ComponentAnchor.CENTER_RIGHT || anchor == ComponentAnchor.BOTTOM_RIGHT) {
                rightAligned = true;
            }
        } else if (this.getLayout() instanceof LayoutSnap && ((anchor = ((LayoutSnap)(layout = (LayoutSnap)this.getLayout())).getAnchor()) == ComponentAnchor.TOP_RIGHT || anchor == ComponentAnchor.CENTER_RIGHT || anchor == ComponentAnchor.BOTTOM_RIGHT)) {
            rightAligned = true;
        }
        boolean clock = false;
        boolean compass = false;
        boolean rotaryCalendar = false;
        if (HudComponentInfoOverlay.mc.thePlayer.getGamemode() == Gamemode.creative) {
            clock = true;
            compass = true;
            rotaryCalendar = true;
        } else {
            for (int iinv = 0; iinv < HudComponentInfoOverlay.mc.thePlayer.inventory.getContainerSize(); ++iinv) {
                ItemStack item = HudComponentInfoOverlay.mc.thePlayer.inventory.getItem(iinv);
                if (item == null) continue;
                if (item.itemID == Items.TOOL_CLOCK.id) {
                    clock = true;
                }
                if (item.itemID == Items.TOOL_COMPASS.id) {
                    compass = true;
                }
                if (item.itemID != Items.TOOL_CALENDAR.id) continue;
                rotaryCalendar = true;
            }
        }
        int tsp = 2;
        int line = 0;
        int lineHeight = 10;
        if (((Boolean)HudComponentInfoOverlay.mc.gameSettings.versionInOverlay.value).booleanValue()) {
            int color = (Integer)HudComponentInfoOverlay.mc.gameSettings.overlayMode.value == 2 ? -160 : -1;
            this.drawString("Better than Adventure! " + String.valueOf(TextFormatting.WHITE) + Global.VERSION, x, y + tsp + lineHeight * line++, color, rightAligned);
        }
        if (((Boolean)HudComponentInfoOverlay.mc.gameSettings.fpsInOverlay.value).booleanValue()) {
            this.drawString(HudComponentInfoOverlay.mc.lingDebugFPS, x, y + tsp + lineHeight * line++, -1, rightAligned);
        }
        if (compass) {
            if (((Boolean)HudComponentInfoOverlay.mc.gameSettings.overlayShowCoords.value).booleanValue()) {
                if ((Integer)HudComponentInfoOverlay.mc.gameSettings.overlayMode.value == 0) {
                    this.drawString("x: " + Utils.floor10(HudComponentInfoOverlay.mc.thePlayer.x) + " y: " + Utils.floor10(HudComponentInfoOverlay.mc.thePlayer.y) + " z: " + Utils.floor10(HudComponentInfoOverlay.mc.thePlayer.z), x, y + tsp + lineHeight * line++, -1, rightAligned);
                }
                if ((Integer)HudComponentInfoOverlay.mc.gameSettings.overlayMode.value == 1) {
                    this.drawString("x: " + Utils.floor10(HudComponentInfoOverlay.mc.thePlayer.x), x, y + tsp + lineHeight * line++, -1, rightAligned);
                    this.drawString("y: " + Utils.floor10(HudComponentInfoOverlay.mc.thePlayer.y), x, y + tsp + lineHeight * line++, -1, rightAligned);
                    this.drawString("z: " + Utils.floor10(HudComponentInfoOverlay.mc.thePlayer.z), x, y + tsp + lineHeight * line++, -1, rightAligned);
                }
                if ((Integer)HudComponentInfoOverlay.mc.gameSettings.overlayMode.value == 2) {
                    this.drawString("x: " + Utils.floor10(HudComponentInfoOverlay.mc.thePlayer.x), x, y + tsp + lineHeight * line++, -32640, rightAligned);
                    this.drawString("y: " + Utils.floor10(HudComponentInfoOverlay.mc.thePlayer.y), x, y + tsp + lineHeight * line++, -8323200, rightAligned);
                    this.drawString("z: " + Utils.floor10(HudComponentInfoOverlay.mc.thePlayer.z), x, y + tsp + lineHeight * line++, -8355585, rightAligned);
                }
            }
            if (((Boolean)HudComponentInfoOverlay.mc.gameSettings.overlayShowDirection.value).booleanValue()) {
                this.drawString(I18n.getInstance().translateKey(HudIngame.getFacingDirection(HudComponentInfoOverlay.mc.thePlayer).getTranslationKey()), x, y + tsp + lineHeight * line++, -1, rightAligned);
            }
        }
        if (clock && ((Boolean)HudComponentInfoOverlay.mc.gameSettings.overlayShowTime.value).booleanValue()) {
            if ((Integer)HudComponentInfoOverlay.mc.gameSettings.overlayMode.value == 0) {
                this.drawString(String.format("%s %s %d", HudIngame.getTimeString(mc), I18n.getInstance().translateKey("unit.day"), HudComponentInfoOverlay.mc.currentWorld.getWorldTime() / 24000L), x, y + tsp + lineHeight * line++, (Integer)HudComponentInfoOverlay.mc.gameSettings.overlayMode.value == 2 ? -128 : -1, rightAligned);
            }
            if ((Integer)HudComponentInfoOverlay.mc.gameSettings.overlayMode.value > 0) {
                this.drawString(HudIngame.getTimeString(mc), x, y + tsp + lineHeight * line++, (Integer)HudComponentInfoOverlay.mc.gameSettings.overlayMode.value == 2 ? -128 : -1, rightAligned);
                this.drawString(String.format("%s %d", I18n.getInstance().translateKey("unit.day"), HudComponentInfoOverlay.mc.currentWorld.getWorldTime() / 24000L), x, y + tsp + lineHeight * line++, (Integer)HudComponentInfoOverlay.mc.gameSettings.overlayMode.value == 2 ? -128 : -1, rightAligned);
            }
        }
        if (rotaryCalendar) {
            Weather weather;
            Season season;
            if (((Boolean)HudComponentInfoOverlay.mc.gameSettings.overlayShowSeason.value).booleanValue() && (season = HudComponentInfoOverlay.mc.currentWorld.getSeasonManager().getCurrentSeason()) != null) {
                this.drawString(season.getTranslatedName(), x, y + tsp + lineHeight * line++, (Integer)HudComponentInfoOverlay.mc.gameSettings.overlayMode.value == 2 ? -8323073 : -1, rightAligned);
            }
            if (((Boolean)HudComponentInfoOverlay.mc.gameSettings.overlayShowWeather.value).booleanValue() && (weather = HudComponentInfoOverlay.mc.currentWorld.getCurrentWeather()) != null && weather != HudComponentInfoOverlay.mc.currentWorld.worldType.getDefaultWeather()) {
                this.drawString(I18n.getInstance().translateKey(weather.getNameLanguageKey()), x, y + tsp + lineHeight * line++, (Integer)HudComponentInfoOverlay.mc.gameSettings.overlayMode.value == 2 ? -32513 : -1, rightAligned);
            }
            if (((Boolean)HudComponentInfoOverlay.mc.gameSettings.overlayShowBiome.value).booleanValue()) {
                int blockX = MathHelper.floor(HudComponentInfoOverlay.mc.thePlayer.x);
                int blockY = MathHelper.floor(HudComponentInfoOverlay.mc.thePlayer.y);
                int blockZ = MathHelper.floor(HudComponentInfoOverlay.mc.thePlayer.z);
                String key = HudComponentInfoOverlay.mc.currentWorld.getBlockBiome((int)blockX, (int)blockY, (int)blockZ).translationKey;
                this.drawString(I18n.getInstance().translateKey(key), x, y + tsp + lineHeight * line++, -1, rightAligned);
            }
        }
    }

    @Override
    public void renderPreview(Gui gui, Layout layout, int xSizeScreen, int ySizeScreen) {
        ComponentAnchor anchor;
        Layout l;
        int x = this.getLayout().getComponentX(this, xSizeScreen);
        int y = this.getLayout().getComponentY(this, ySizeScreen);
        boolean rightAligned = false;
        if (layout instanceof LayoutAbsolute) {
            l = (LayoutAbsolute)this.getLayout();
            anchor = ((LayoutAbsolute)l).getAnchor();
            if (anchor == ComponentAnchor.TOP_RIGHT || anchor == ComponentAnchor.CENTER_RIGHT || anchor == ComponentAnchor.BOTTOM_RIGHT) {
                rightAligned = true;
            }
        } else if (layout instanceof LayoutSnap && ((anchor = ((LayoutSnap)(l = (LayoutSnap)this.getLayout())).getAnchor()) == ComponentAnchor.TOP_RIGHT || anchor == ComponentAnchor.CENTER_RIGHT || anchor == ComponentAnchor.BOTTOM_RIGHT)) {
            rightAligned = true;
        }
        int tsp = 2;
        int line = 0;
        int lineHeight = 10;
        this.drawString("60 fps", x, y + tsp + lineHeight * line++, -1, rightAligned);
        double px = 372.853;
        double py = 64.355;
        double pz = 38472.333;
        if ((Integer)HudComponentInfoOverlay.mc.gameSettings.overlayMode.value == 0) {
            this.drawString("x: " + Utils.floor10(372.853) + " y: " + Utils.floor10(64.355) + " z: " + Utils.floor10(38472.333), x, y + tsp + lineHeight * line++, -1, rightAligned);
        }
        if ((Integer)HudComponentInfoOverlay.mc.gameSettings.overlayMode.value == 1) {
            this.drawString("x: " + Utils.floor10(372.853), x, y + tsp + lineHeight * line++, -1, rightAligned);
            this.drawString("y: " + Utils.floor10(64.355), x, y + tsp + lineHeight * line++, -1, rightAligned);
            this.drawString("z: " + Utils.floor10(38472.333), x, y + tsp + lineHeight * line++, -1, rightAligned);
        }
        if ((Integer)HudComponentInfoOverlay.mc.gameSettings.overlayMode.value == 2) {
            this.drawString("x: " + Utils.floor10(372.853), x, y + tsp + lineHeight * line++, -32640, rightAligned);
            this.drawString("y: " + Utils.floor10(64.355), x, y + tsp + lineHeight * line++, -8323200, rightAligned);
            this.drawString("z: " + Utils.floor10(38472.333), x, y + tsp + lineHeight * line++, -8355585, rightAligned);
        }
        this.drawString(I18n.getInstance().translateKey(Direction.NORTH.getTranslationKey()), x, y + tsp + lineHeight * line++, -1, rightAligned);
        if ((Integer)HudComponentInfoOverlay.mc.gameSettings.overlayMode.value == 0) {
            this.drawString(String.format("%s %s %d", "8:32", I18n.getInstance().translateKey("unit.day"), 500), x, y + tsp + lineHeight * line++, (Integer)HudComponentInfoOverlay.mc.gameSettings.overlayMode.value == 2 ? -128 : -1, rightAligned);
        }
        if ((Integer)HudComponentInfoOverlay.mc.gameSettings.overlayMode.value > 0) {
            this.drawString("8:32", x, y + tsp + lineHeight * line++, (Integer)HudComponentInfoOverlay.mc.gameSettings.overlayMode.value == 2 ? -128 : -1, rightAligned);
            this.drawString(String.format("%s %d", I18n.getInstance().translateKey("unit.day"), 500), x, y + tsp + lineHeight * line++, (Integer)HudComponentInfoOverlay.mc.gameSettings.overlayMode.value == 2 ? -128 : -1, rightAligned);
        }
        Season season = Seasons.OVERWORLD_SUMMER;
        this.drawString(season.getTranslatedName(), x, y + tsp + lineHeight * line++, (Integer)HudComponentInfoOverlay.mc.gameSettings.overlayMode.value == 2 ? -8323073 : -1, rightAligned);
        Weather weather = Weathers.OVERWORLD_FOG;
        this.drawString(I18n.getInstance().translateKey(weather.getNameLanguageKey()), x, y + tsp + lineHeight * line++, (Integer)HudComponentInfoOverlay.mc.gameSettings.overlayMode.value == 2 ? -32513 : -1, rightAligned);
        String key = Biomes.OVERWORLD_GRASSLANDS.translationKey;
        this.drawString(I18n.getInstance().translateKey(key), x, y + tsp + lineHeight * line++, -1, rightAligned);
    }
}

