/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.nbteditor;

import com.mojang.logging.LogUtils;
import com.mojang.nbt.tags.CompoundTag;
import java.util.function.Function;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.nbteditor.components.CompoundTagComponent;
import net.minecraft.client.render.Scissor;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.slf4j.Logger;

public class ScreenNBTEditor
extends Screen {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    public final String title;
    @Nullable
    public final CompoundTag inputTag;
    public final @Nullable Function<@NotNull CompoundTag, Void> tagAction;
    private final CompoundTagComponent compoundTagComponent;
    private double scroll = 0.0;

    public ScreenNBTEditor(@Nullable String title, @Nullable CompoundTag inputTag, @Nullable Function<@NotNull CompoundTag, Void> exitAction) {
        this(null, title, inputTag, exitAction);
    }

    public ScreenNBTEditor(@Nullable Screen parentScreen, @Nullable String title, @Nullable CompoundTag inputTag, @Nullable Function<@NotNull CompoundTag, Void> exitAction) {
        super(parentScreen);
        this.title = title;
        this.inputTag = inputTag;
        this.tagAction = exitAction;
        this.compoundTagComponent = new CompoundTagComponent((Screen)this, new CompoundTag(inputTag));
        this.compoundTagComponent.expanded = true;
    }

    @Override
    public void removed() {
        if (this.tagAction != null) {
            this.tagAction.apply((CompoundTag)this.compoundTagComponent.tag);
        }
    }

    @Override
    public void render(int mx, int my, float partialTick) {
        int compHeight = this.compoundTagComponent.height(-1, -1, partialTick);
        int minScroll = 0;
        int maxScroll = Math.max(compHeight - (this.height - 84), 0);
        this.scroll += (double)(Mouse.getDWheel() * 10);
        this.scroll = MathHelper.clamp(this.scroll, (double)(-maxScroll), (double)minScroll);
        this.renderBackground();
        super.render(mx, my, partialTick);
        Tessellator t = Tessellator.instance;
        int popupWidth = this.width / 2 + 40;
        int popupHeight = this.height - 40;
        int popupX = this.width / 2 - popupWidth / 2;
        int popupY = this.height / 2 - popupHeight / 2;
        GL11.glDisable(2896);
        GL11.glDisable(2912);
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glEnable(3553);
        float f = 32.0f;
        t.startDrawingQuads();
        this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/background.png").bind();
        t.setColorOpaque_I(0x404040);
        t.addVertexWithUV(popupX, popupY + popupHeight, 0.0, 0.0, (float)popupHeight / f);
        t.addVertexWithUV(popupX + popupWidth, popupY + popupHeight, 0.0, (float)popupWidth / f, (float)popupHeight / f);
        t.addVertexWithUV(popupX + popupWidth, popupY, 0.0, (float)popupWidth / f, 0.0);
        t.addVertexWithUV(popupX, popupY, 0.0, 0.0, 0.0);
        t.draw();
        this.drawRect(this.width / 4, 40, this.width * 3 / 4, this.height - 40, -2013265920);
        this.fontRenderer.renderCentered(t, this.title, this.width / 2, 26).setShadow().call();
        if (minScroll != maxScroll) {
            this.drawRect(this.width * 3 / 4 - 5, 41, this.width * 3 / 4 - 1, this.height - 43, -16777216);
            int scrollableRegion = compHeight;
            int regionHeight = this.height - 84;
            int sMin = (int)this.scroll;
            int barMinX = this.width * 3 / 4 - 6;
            int barMaxX = this.width * 3 / 4 - 2;
            int barMinY = 42 - MathHelper.round((double)sMin / (double)scrollableRegion * (double)regionHeight);
            int barMaxY = barMinY + MathHelper.round((double)regionHeight / (double)scrollableRegion * (double)regionHeight);
            boolean hovered = mx >= barMinX && mx <= barMaxX && my >= barMinY && my <= barMaxY;
            this.drawRect(barMinX, barMinY, barMaxX, barMaxY, hovered ? -3355393 : -1);
        }
        Scissor.enable(this.width / 4 - 20, 40, this.width / 2 + 13, this.height - 80);
        int y = (int)(42.0 + this.scroll);
        boolean inPane = mx >= this.width / 4 - 20 && mx <= this.width * 3 / 4 - 20 + 13 && my >= 40 && my <= this.height - 40;
        this.compoundTagComponent.render(t, this.width / 4 + 2, y, inPane ? mx - this.width / 4 : -1, inPane ? my - y : -1, partialTick);
        Scissor.disable();
        this.drawBox(this.width / 4 - 20, 20, this.width * 3 / 4 + 20, this.height - 20, -1, 1);
        this.drawBox(this.width / 4, 40, this.width * 3 / 4, this.height - 40, -1, 1);
    }

    @Override
    public void mouseClicked(int mx, int my, int buttonNum) {
        super.mouseClicked(mx, my, buttonNum);
        int y = (int)(42.0 + this.scroll);
        boolean inPane = mx >= this.width / 4 - 20 && mx <= this.width * 3 / 4 - 20 + 13 && my >= 40 && my <= this.height - 40;
        this.compoundTagComponent.onMouseClick(inPane ? mx - this.width / 4 : -1, inPane ? my - y : -1, buttonNum, 1.0f);
    }

    @Override
    public void mouseReleased(int mx, int my, int buttonNum) {
        super.mouseReleased(mx, my, buttonNum);
        int y = (int)(42.0 + this.scroll);
        boolean inPane = mx >= this.width / 4 - 20 && mx <= this.width * 3 / 4 - 20 + 13 && my >= 40 && my <= this.height - 40;
        this.compoundTagComponent.onMouseRelease(inPane ? mx - this.width / 4 : -1, inPane ? my - y : -1, buttonNum, 1.0f);
    }
}

