/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.ArrayList;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;

public abstract class BlockLogicFenceThin
extends BlockLogic {
    public BlockLogicFenceThin(Block<?> block, Material material) {
        super(block, material);
    }

    @Override
    public boolean canPlaceOnSurface() {
        return true;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, int x, int y, int z, @NotNull Side side) {
        return side.isVertical() ? PartialSupport.INSTANCE.center() : PartialSupport.INSTANCE;
    }

    @Override
    public AABB getBlockBoundsFromState(WorldSource world, int x, int y, int z) {
        boolean connectEast = this.canConnectTo(world, x, y, z, Side.EAST);
        boolean connectWest = this.canConnectTo(world, x, y, z, Side.WEST);
        boolean connectSouth = this.canConnectTo(world, x, y, z, Side.SOUTH);
        boolean connectNorth = this.canConnectTo(world, x, y, z, Side.NORTH);
        return AABB.fromPool(connectWest ? 0.0f : 0.375f, 0.0, connectNorth ? 0.0f : 0.375f, 1.0f - (connectEast ? 0.0f : 0.375f), 1.0, 1.0f - (connectSouth ? 0.0f : 0.375f));
    }

    @Override
    public void getCollidingBoundingBoxes(World world, int x, int y, int z, AABB aabb, ArrayList<AABB> aabbList) {
        boolean connectEast = this.canConnectTo(world, x, y, z, Side.EAST);
        boolean connectWest = this.canConnectTo(world, x, y, z, Side.WEST);
        boolean connectSouth = this.canConnectTo(world, x, y, z, Side.SOUTH);
        boolean connectNorth = this.canConnectTo(world, x, y, z, Side.NORTH);
        double thickness = 0.125;
        if (connectEast) {
            this.addIntersectingBoundingBox(aabb, AABB.fromPool(0.375, 0.0, 0.375, 1.0, 1.0, 0.625).move(x, y, z), aabbList);
        }
        if (connectWest) {
            this.addIntersectingBoundingBox(aabb, AABB.fromPool(0.0, 0.0, 0.375, 0.625, 1.0, 0.625).move(x, y, z), aabbList);
        }
        if (connectSouth) {
            this.addIntersectingBoundingBox(aabb, AABB.fromPool(0.375, 0.0, 0.375, 0.625, 1.0, 1.0).move(x, y, z), aabbList);
        }
        if (connectNorth) {
            this.addIntersectingBoundingBox(aabb, AABB.fromPool(0.375, 0.0, 0.0, 0.625, 1.0, 0.625).move(x, y, z), aabbList);
        }
        if (!(connectEast || connectWest || connectSouth || connectNorth)) {
            this.addIntersectingBoundingBox(aabb, AABB.fromPool(0.375, 0.0, 0.375, 0.625, 1.0, 0.625).move(x, y, z), aabbList);
        }
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    public abstract boolean canConnectTo(@NotNull WorldSource var1, int var2, int var3, int var4, @NotNull Side var5);

    public boolean shouldDrawColumn(WorldSource world, int x, int y, int z) {
        boolean drawColumn = this.shouldDrawColumn_do(world, x, y, z);
        if (drawColumn) {
            return true;
        }
        int oy = 1;
        while (world.getBlockId(x, y + oy, z) == this.block.id()) {
            ++oy;
        }
        --oy;
        boolean drawColumnFromOther = false;
        while (world.getBlockId(x, y + oy, z) == this.block.id()) {
            if (this.shouldDrawColumn_do(world, x, y + oy, z)) {
                drawColumnFromOther = true;
                break;
            }
            --oy;
        }
        return drawColumnFromOther;
    }

    private boolean shouldDrawColumn_do(WorldSource world, int x, int y, int z) {
        boolean connectNorth = this.canConnectTo(world, x, y, z, Side.NORTH);
        boolean connectSouth = this.canConnectTo(world, x, y, z, Side.SOUTH);
        boolean connectEast = this.canConnectTo(world, x, y, z, Side.EAST);
        boolean connectWest = this.canConnectTo(world, x, y, z, Side.WEST);
        boolean lineNorthSouth = connectNorth && connectSouth;
        boolean lineEastWest = connectEast && connectWest;
        return !lineNorthSouth && !lineEastWest || lineNorthSouth && lineEastWest || lineNorthSouth && (connectEast || connectWest) || lineEastWest && (connectNorth || connectSouth);
    }
}

