/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicMobSpawnerDeactivated;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityMobSpawner;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;

public class BlockLogicMobSpawner
extends BlockLogicMobSpawnerDeactivated {
    public BlockLogicMobSpawner(Block<?> block) {
        super(block);
        block.withEntity(TileEntityMobSpawner::new);
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xPlaced, double yPlaced) {
        if (player.getGamemode() != Gamemode.creative) {
            return false;
        }
        player.displayMobPickerScreen(x, y, z);
        return true;
    }

    @Override
    public void onBlockPlacedOnSide(World world, int x, int y, int z, @NotNull Side side, double xPlaced, double yPlaced) {
        TileEntityMobSpawner tileEntity = (TileEntityMobSpawner)world.getTileEntity(x, y, z);
        tileEntity.setMobId("none");
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        if (!world.isClientSide) {
            TileEntityMobSpawner tileEntityMobSpawner = (TileEntityMobSpawner)world.getTileEntity(x, y, z);
            if (tileEntityMobSpawner == null) {
                return;
            }
            int amountToDrop = world.rand.nextInt(10) + 10;
            for (int l = 0; l < amountToDrop; ++l) {
                String mobInSpawner = tileEntityMobSpawner.getMobId();
                if (mobInSpawner == null) continue;
                ItemStack itemstack = switch (mobInSpawner) {
                    case "minecraft:zombie" -> new ItemStack(Items.CLOTH);
                    case "minecraft:skeleton" -> {
                        if (world.rand.nextInt(2) == 0) {
                            yield new ItemStack(Items.BONE);
                        }
                        yield new ItemStack(Items.AMMO_ARROW);
                    }
                    case "minecraft:zombie_armored" -> new ItemStack(Items.CHAINLINK);
                    case "minecraft:spider" -> new ItemStack(Items.STRING);
                    case "minecraft:snowman" -> new ItemStack(Items.AMMO_SNOWBALL);
                    default -> null;
                };
                if (itemstack == null) continue;
                float f = world.rand.nextFloat() * 0.8f + 0.1f;
                float f1 = world.rand.nextFloat() * 0.8f + 0.1f;
                float f2 = world.rand.nextFloat() * 0.8f + 0.1f;
                while (itemstack.stackSize > 0) {
                    int i1 = world.rand.nextInt(21) + 10;
                    if (i1 > itemstack.stackSize) {
                        i1 = itemstack.stackSize;
                    }
                    itemstack.stackSize -= i1;
                    EntityItem entityitem = new EntityItem(world, (float)x + f, (float)y + f1, (float)z + f2, new ItemStack(itemstack.itemID, i1, itemstack.getMetadata()));
                    float f3 = 0.05f;
                    entityitem.xd = (float)world.rand.nextGaussian() * f3;
                    entityitem.yd = (float)world.rand.nextGaussian() * f3 + 0.2f;
                    entityitem.zd = (float)world.rand.nextGaussian() * f3;
                    world.entityJoinedWorld(entityitem);
                }
            }
        }
        super.onBlockRemoved(world, x, y, z, data);
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, TileEntity tileEntity) {
        if (dropCause == EnumDropCause.SILK_TOUCH) {
            return new ItemStack[]{new ItemStack(Blocks.MOBSPAWNER_DEACTIVATED)};
        }
        return null;
    }
}

