/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicBrazier;
import net.minecraft.core.block.BlockLogicFluid;
import net.minecraft.core.block.BlockLogicTNT;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.material.ToolMaterial;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemFireStriker
extends Item {
    public ItemFireStriker(String name, String namespaceId, int id) {
        super(name, namespaceId, id);
        this.maxStackSize = 1;
        this.setMaxDamage(ToolMaterial.iron.getDurability() / 2);
    }

    @Override
    public boolean onUseItemOnBlock(@NotNull ItemStack itemstack, @Nullable Player player, @NotNull World world, int blockX, int blockY, int blockZ, @NotNull Side side, double xPlaced, double yPlaced) {
        int i1 = world.getBlockId(blockX += side.getOffsetX(), blockY += side.getOffsetY(), blockZ += side.getOffsetZ());
        if (i1 == 0) {
            if (world.setBlockWithNotify(blockX, blockY, blockZ, Blocks.FIRE.id())) {
                world.playSoundEffect(player, SoundCategory.WORLD_SOUNDS, (double)blockX + 0.5, (double)blockY + 0.5, (double)blockZ + 0.5, "fire.ignite", 1.0f, itemRand.nextFloat() * 0.4f + 0.8f);
                itemstack.damageItem(1, player);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void onUseByActivator(ItemStack itemStack, TileEntityActivator activatorBlock, World world, Random random, int blockX, int blockY, int blockZ, double offX, double offY, double offZ, Direction direction) {
        if (!this.onUseItemOnBlock(itemStack, null, world, blockX, blockY, blockZ, direction.getSide(), 0.5, 0.5)) {
            Block<?> b = world.getBlock(blockX += direction.getOffsetX(), blockY += direction.getOffsetY(), blockZ += direction.getOffsetZ());
            if (Block.hasLogicClass(b, BlockLogicBrazier.class) && !((BlockLogicBrazier)b.getLogic()).isBurning()) {
                if (Block.hasLogicClass(world.getBlock(blockX + 1, blockY, blockZ), BlockLogicFluid.class) || Block.hasLogicClass(world.getBlock(blockX - 1, blockY, blockZ), BlockLogicFluid.class) || Block.hasLogicClass(world.getBlock(blockX, blockY, blockZ + 1), BlockLogicFluid.class) || Block.hasLogicClass(world.getBlock(blockX, blockY, blockZ - 1), BlockLogicFluid.class)) {
                    return;
                }
                world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, Blocks.BRAZIER_ACTIVE.id(), 0);
                itemStack.damageItem(1, null);
                world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)blockX + 0.5, (double)blockY + 0.5, (double)blockZ + 0.5, "fire.ignite", 1.0f, world.rand.nextFloat() * 0.4f + 0.8f);
            } else if (Block.hasLogicClass(b, BlockLogicTNT.class)) {
                ((BlockLogicTNT)b.getLogic()).ignite(world, blockX, blockY, blockZ, true);
            }
        }
    }
}

