/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFarmland;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemSeeds
extends Item {
    private final Block<?> cropsBlock;

    public ItemSeeds(String name, String namespaceId, int id, Block<?> cropsBlock) {
        super(name, namespaceId, id);
        this.cropsBlock = cropsBlock;
    }

    @Override
    public boolean onUseItemOnBlock(@NotNull ItemStack itemstack, @Nullable Player player, @NotNull World world, int blockX, int blockY, int blockZ, @NotNull Side side, double xPlaced, double yPlaced) {
        if (!world.canPlaceInsideBlock(blockX, blockY, blockZ)) {
            blockX += side.getOffsetX();
            blockY += side.getOffsetY();
            blockZ += side.getOffsetZ();
        }
        if (world.getBlockId(blockX, blockY - 1, blockZ) == Blocks.FARMLAND_DIRT.id() && world.canPlaceInsideBlock(blockX, blockY, blockZ) && world.setBlockWithNotify(blockX, blockY, blockZ, this.cropsBlock.id())) {
            world.playBlockSoundEffect(player, (float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, this.cropsBlock, EnumBlockSoundEffectType.PLACE);
            itemstack.consumeItem(player);
            return true;
        }
        return false;
    }

    @Override
    public void onUseByActivator(ItemStack itemStack, TileEntityActivator activatorBlock, World world, Random random, int blockX, int blockY, int blockZ, double offX, double offY, double offZ, Direction direction) {
        int x = blockX + direction.getOffsetX();
        int y = blockY + direction.getOffsetY();
        int z = blockZ + direction.getOffsetZ();
        Block<?> b = world.getBlock(x, y, z);
        boolean isFarmland = Block.hasLogicClass(b, BlockLogicFarmland.class);
        if (b == null || isFarmland || BlockTags.PLACE_OVERWRITES.appliesTo(b)) {
            this.onUseItemOnBlock(itemStack, null, world, x, y + (isFarmland ? 1 : 0), z, direction.getSide(), 0.5, 0.5);
        }
    }
}

