/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicRail;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.logic.RailDirection;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockModelRail<T extends BlockLogicRail>
extends BlockModelStandard<T> {
    protected IconCoordinate railCurve = TextureRegistry.getTexture("minecraft:block/rail/turn");
    protected IconCoordinate powerActive = TextureRegistry.getTexture("minecraft:block/rail_powered/active");
    protected IconCoordinate powerActiveOverlay = TextureRegistry.getTexture("minecraft:block/rail_powered/active_overlay");
    protected IconCoordinate detectorActiveOverlay = TextureRegistry.getTexture("minecraft:block/rail_detector/active_overlay");

    public BlockModelRail(Block<T> block) {
        super(block);
    }

    @Override
    public boolean hasOverbright() {
        return true;
    }

    @Override
    public boolean render(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, int x, int y, int z) {
        int meta = worldSource.getBlockMetadata(x, y, z);
        IconCoordinate icon = this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, meta);
        if (BlockModelRail.renderBlocks.overrideBlockTexture != null) {
            icon = BlockModelRail.renderBlocks.overrideBlockTexture;
        }
        RailDirection railDirection = ((BlockLogicRail)this.block.getLogic()).getRailDirection(worldSource, x, y, z);
        float brightness = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            if (BlockModelRail.renderBlocks.overbright) {
                tessellator.setLightmapCoord(LightmapHelper.getOverbrightLightmapCoord(worldSource.getSavedLightValue(LightLayer.Sky, x, y, z)));
            } else {
                tessellator.setLightmapCoord(this.block.getLightmapCoord(worldSource, x, y, z));
            }
        } else if (!BlockModelRail.renderBlocks.overbright) {
            brightness = renderBlocks.getBlockBrightness(worldSource, x, y, z);
        }
        if (BlockModelRail.renderBlocks.overbright) {
            icon = this.getBlockOverbrightTexture(worldSource, x, y, z, Side.BOTTOM);
        }
        if (icon == null) {
            return false;
        }
        tessellator.setColorOpaque_F(brightness, brightness, brightness);
        double minU = icon.getIconUMin();
        double maxU = icon.getIconUMax();
        double minV = icon.getIconVMin();
        double maxV = icon.getIconVMax();
        float yOffset = 0.0625f;
        float vX1 = x + 1;
        float vX2 = x + 1;
        float vX3 = x;
        float vX4 = x;
        float vZ1 = z;
        float vZ2 = z + 1;
        float vZ3 = z + 1;
        float vZ4 = z;
        float vY1 = (float)y + 0.0625f;
        float vY2 = (float)y + 0.0625f;
        float vY3 = (float)y + 0.0625f;
        float vY4 = (float)y + 0.0625f;
        switch (railDirection) {
            case STRAIGHT_EW: 
            case SLOPE_E: 
            case SLOPE_W: 
            case TURN_WS: {
                vX1 = vX4 = (float)(x + 1);
                vX2 = vX3 = (float)x;
                vZ1 = vZ2 = (float)(z + 1);
                vZ3 = vZ4 = (float)z;
                break;
            }
            case TURN_WN: {
                vX1 = vX2 = (float)x;
                vX3 = vX4 = (float)(x + 1);
                vZ1 = vZ4 = (float)(z + 1);
                vZ2 = vZ3 = (float)z;
                break;
            }
            case TURN_EN: {
                vX1 = vX4 = (float)x;
                vX2 = vX3 = (float)(x + 1);
                vZ1 = vZ2 = (float)z;
                vZ3 = vZ4 = (float)(z + 1);
            }
        }
        switch (railDirection) {
            case SLOPE_E: 
            case SLOPE_N: {
                vY1 += 1.0f;
                vY4 += 1.0f;
                break;
            }
            case SLOPE_W: 
            case SLOPE_S: {
                vY2 += 1.0f;
                vY3 += 1.0f;
            }
        }
        tessellator.addVertexWithUV(vX1, vY1, vZ1, maxU, minV);
        tessellator.addVertexWithUV(vX2, vY2, vZ2, maxU, maxV);
        tessellator.addVertexWithUV(vX3, vY3, vZ3, minU, maxV);
        tessellator.addVertexWithUV(vX4, vY4, vZ4, minU, minV);
        tessellator.addVertexWithUV(vX4, vY4, vZ4, minU, minV);
        tessellator.addVertexWithUV(vX3, vY3, vZ3, minU, maxV);
        tessellator.addVertexWithUV(vX2, vY2, vZ2, maxU, maxV);
        tessellator.addVertexWithUV(vX1, vY1, vZ1, maxU, minV);
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    @Nullable
    public IconCoordinate getBlockOverbrightTexture(WorldSource blockAccess, int x, int y, int z, @NotNull Side side) {
        if (!((BlockLogicRail)this.block.getLogic()).isPowered || (blockAccess.getBlockMetadata(x, y, z) & 8) == 0) {
            return null;
        }
        return this.block == Blocks.RAIL_POWERED ? this.powerActiveOverlay : this.detectorActiveOverlay;
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        if (this.block == Blocks.RAIL_POWERED && (data & 8) != 0) {
            return this.powerActive;
        }
        if (!((BlockLogicRail)this.block.getLogic()).isPowered && data >= 6) {
            return this.railCurve;
        }
        return super.getBlockTextureFromSideAndMetadata(side, data);
    }
}

