/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.dynamictexture;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.dynamictexture.DynamicTexture;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;

public class DynamicTextureWaterStill
extends DynamicTexture {
    private final Minecraft mc = Minecraft.getMinecraft();
    private float[] arr1;
    private float[] arr2;
    private float[] arr3;
    private float[] arr4;

    public DynamicTextureWaterStill(IconCoordinate targetTexture) {
        super(targetTexture);
    }

    @Override
    public void postInit() {
        this.initTexture();
        this.arr1 = new float[this.targetTexture.getArea()];
        this.arr2 = new float[this.targetTexture.getArea()];
        this.arr3 = new float[this.targetTexture.getArea()];
        this.arr4 = new float[this.targetTexture.getArea()];
    }

    @Override
    public void update() {
        float bright;
        int y;
        int x;
        for (x = 0; x < this.targetTexture.width; ++x) {
            for (y = 0; y < this.targetTexture.height; ++y) {
                bright = 0.0f;
                for (int k = x - 1; k <= x + 1; ++k) {
                    int a_ = DynamicTextureWaterStill.pmod(k, this.targetTexture.width);
                    int b_ = DynamicTextureWaterStill.pmod(y, this.targetTexture.height);
                    bright += this.arr1[a_ + b_ * this.targetTexture.width];
                }
                this.arr2[x + y * this.targetTexture.width] = bright / 3.3f + this.arr3[x + y * this.targetTexture.width] * 0.8f;
            }
        }
        for (x = 0; x < this.targetTexture.width; ++x) {
            for (y = 0; y < this.targetTexture.height; ++y) {
                int n = x + y * this.targetTexture.width;
                this.arr3[n] = this.arr3[n] + this.arr4[x + y * this.targetTexture.width] * 0.05f;
                if (this.arr3[x + y * this.targetTexture.width] < 0.0f) {
                    this.arr3[x + y * this.targetTexture.width] = 0.0f;
                }
                int n2 = x + y * this.targetTexture.width;
                this.arr4[n2] = this.arr4[n2] - 0.1f;
                if (!(Math.random() < 0.05)) continue;
                this.arr4[x + y * this.targetTexture.width] = 0.5f;
            }
        }
        float[] var12 = this.arr2;
        this.arr2 = this.arr1;
        this.arr1 = var12;
        for (int i = 0; i < this.targetTexture.getArea(); ++i) {
            bright = this.arr1[i];
            if (bright > 1.0f) {
                bright = 1.0f;
            }
            if (bright < 0.0f) {
                bright = 0.0f;
            }
            float var13 = bright * bright;
            int r = (int)(32.0f + var13 * 32.0f);
            int g = (int)(50.0f + var13 * 64.0f);
            int b = 255;
            int a = (int)(146.0f + var13 * 50.0f);
            if (((Boolean)this.mc.gameSettings.biomeWater.value).booleanValue() && (this.mc.currentWorld == null || !this.mc.currentWorld.isRetro())) {
                g = b = (r + g + b) / 3;
                r = b;
            }
            this.imageData[i * 4 + 0] = (byte)r;
            this.imageData[i * 4 + 1] = (byte)g;
            this.imageData[i * 4 + 2] = (byte)b;
            this.imageData[i * 4 + 3] = (byte)a;
        }
    }
}

