/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.options.components;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.IntegerSliderElement;
import net.minecraft.client.gui.options.components.ButtonComponent;
import net.minecraft.client.gui.popup.PopupBuilder;
import net.minecraft.client.option.OptionEnum;
import net.minecraft.client.render.window.CursorShape;
import net.minecraft.core.enums.Difficulty;
import net.minecraft.core.lang.I18n;
import org.jetbrains.annotations.Nullable;

public class DifficultyOptionComponent
extends ButtonComponent {
    protected final OptionEnum<Difficulty> option;
    protected final IntegerSliderElement slider;
    protected final ButtonElement lockButton;

    public DifficultyOptionComponent(OptionEnum<Difficulty> difficultyOption) {
        this(difficultyOption, null);
    }

    public DifficultyOptionComponent(OptionEnum<Difficulty> difficultyOption, @Nullable String tooltipTranslationKey) {
        super("options." + difficultyOption.name, tooltipTranslationKey);
        this.option = difficultyOption;
        this.option.addCallback(__ -> this.onChanged());
        this.slider = new IntegerSliderElement(0, 0, 0, 128, 20, this.option);
        this.lockButton = new ButtonElement(1, 130, 0, 20, 20, "");
        this.lockButton.setTextures("minecraft:gui/widgets/button/button_locked", "minecraft:gui/widgets/button/button_locked_highlighted", "minecraft:gui/widgets/button/button_locked_disabled");
    }

    @Override
    protected void buttonClicked(int mouseButton, int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
        this.slider.mouseClicked(mc, this.slider.xPosition + relativeMouseX, this.slider.yPosition + relativeMouseY);
        this.onChanged();
        this.option.onUpdate();
        if (DifficultyOptionComponent.mc.currentWorld != null && this.lockButton.mouseClicked(mc, this.slider.xPosition + relativeMouseX, this.slider.yPosition + relativeMouseY)) {
            mc.displayScreen(new PopupBuilder(Objects.requireNonNull(DifficultyOptionComponent.mc.currentScreen), 160).withLabel("gui.options.difficultylock.warning.1").withLabel("gui.options.difficultylock.warning.2").withLabel("gui.options.difficultylock.warning.3", 0xFF0000).withButtonGroup("2", new String[]{"gui.options.difficultylock.button.yes", "gui.options.difficultylock.button.no"}, new int[]{1, 0}).closeOnClickOut(0).closeOnEnter(1).closeOnEsc(0).withOnCloseListener((statusCode, results) -> {
                if (statusCode == 1) {
                    DifficultyOptionComponent.mc.currentWorld.getLevelData().setDifficultyLocked();
                }
            }).build());
        }
    }

    @Override
    protected void buttonDragged(int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
        this.onChanged();
        this.option.onUpdate();
    }

    @Override
    protected void buttonReleased(int mouseButton, int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
        this.slider.mouseReleased(this.slider.xPosition + relativeMouseX, this.slider.yPosition + relativeMouseY);
        this.onChanged();
        this.option.onUpdate();
    }

    @Override
    protected void renderButton(int x, int y, int relativeButtonX, int relativeButtonY, int buttonWidth, int buttonHeight, int relativeMouseX, int relativeMouseY) {
        this.slider.enabled = this.canSetDifficulty();
        this.lockButton.enabled = this.canSetDifficulty();
        super.renderButton(x, y, relativeButtonX, relativeButtonY, buttonWidth, buttonHeight, relativeMouseX, relativeMouseY);
        this.slider.xPosition = x + relativeButtonX;
        this.slider.yPosition = y + relativeButtonY;
        this.slider.width = buttonWidth - 22;
        this.slider.height = buttonHeight;
        this.lockButton.xPosition = x + relativeButtonX + this.slider.width + 2;
        this.lockButton.yPosition = y + relativeButtonY;
        this.lockButton.width = 20;
        this.lockButton.height = buttonHeight;
        this.slider.drawButton(mc, x + relativeMouseX, y + relativeMouseY);
        this.lockButton.drawButton(mc, x + relativeMouseX, y + relativeMouseY);
        if (relativeMouseX >= relativeButtonX && relativeMouseX < relativeButtonX + buttonWidth && relativeMouseY >= relativeButtonY && relativeButtonY < relativeButtonY + buttonHeight) {
            DifficultyOptionComponent.mc.currentScreen.setDesiredCursor(CursorShape.HAND);
        }
    }

    @Override
    public void init(Minecraft mc) {
        if (!this.canSetDifficulty()) {
            this.slider.enabled = false;
            this.slider.sliderValue = Difficulty.NORMAL.id();
            this.lockButton.enabled = false;
            this.onChanged();
            return;
        }
        this.slider.enabled = true;
        this.option.set(mc.currentWorld.getDifficulty());
        this.slider.sliderValue = ((Difficulty)((Object)this.option.value)).id();
        this.lockButton.enabled = true;
        this.onChanged();
    }

    @Override
    public void resetValue() {
        if (this.canSetDifficulty()) {
            this.option.set(Difficulty.NORMAL);
            this.slider.sliderValue = ((Difficulty)((Object)this.option.value)).id();
            DifficultyOptionComponent.mc.currentWorld.setDifficulty(Difficulty.NORMAL, true);
            this.onChanged();
        }
    }

    @Override
    public boolean isDefault() {
        boolean canSet = this.canSetDifficulty();
        return !canSet || DifficultyOptionComponent.mc.currentWorld.getDifficulty() == Difficulty.NORMAL;
    }

    protected void onChanged() {
        this.slider.displayString = this.getDisplayString();
    }

    protected String getDisplayString() {
        if (!this.canSetDifficulty()) {
            return I18n.getInstance().translateKey("options.difficulty.locked");
        }
        return this.option.getDisplayStringValue();
    }

    protected boolean canSetDifficulty() {
        return DifficultyOptionComponent.mc.currentWorld != null && !DifficultyOptionComponent.mc.currentWorld.getLevelData().getDifficultyLocked() && !DifficultyOptionComponent.mc.currentWorld.isClientSide;
    }
}

