/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.item.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.EntityRenderDispatcher;
import net.minecraft.client.render.ItemRenderer;
import net.minecraft.client.render.MapItemRenderer;
import net.minecraft.client.render.PlayerSkinParser;
import net.minecraft.client.render.entity.MobRendererPlayer;
import net.minecraft.client.render.item.model.ItemModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemMap;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.saveddata.maps.ItemMapSavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class ItemModelMap
extends ItemModelStandard {
    private final Minecraft mc = Minecraft.getMinecraft();
    private final MapItemRenderer renderMapInstance = new MapItemRenderer();

    public ItemModelMap(Item item, String namespace) {
        super(item, namespace);
    }

    @Override
    public void renderFirstPerson(@NotNull Tessellator tessellator, @NotNull ItemRenderer itemRenderer, @NotNull Player player, @NotNull ItemStack itemStack, float brightness, float alpha, float partialTick) {
        if (ItemMap.hasInitialized(itemStack)) {
            GL11.glPushMatrix();
            GL11.glEnable(32826);
            float rotationPitch = player.xRotO + (player.xRot - player.xRotO) * partialTick;
            float swingProgress = player.getSwingProgress(partialTick);
            float f_z = MathHelper.sin(swingProgress * (float)Math.PI);
            float f_x = MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)Math.PI);
            GL11.glTranslatef(-f_x * 0.4f, MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)Math.PI * 2.0f) * 0.2f, -f_z * 0.2f);
            float f_val = MathHelper.clamp(1.0f - rotationPitch / 45.0f + 0.1f, 0.0f, 1.0f);
            f_val = -MathHelper.cos(f_val * (float)Math.PI) * 0.5f + 0.5f;
            float zOff = -0.71999997f;
            GL11.glTranslatef(0.0f, -(1.0f - itemRenderer.getEquippedProgress(partialTick)) * 1.2f - f_val * 0.5f + 0.04f, -0.71999997f);
            GL11.glRotatef(90.0f, 0.0f, 1.0f, 0.0f);
            GL11.glRotatef(f_val * -85.0f, 0.0f, 0.0f, 1.0f);
            GL11.glEnable(32826);
            this.mc.textureManager.bindDownloadableTexture(this.mc.thePlayer.skinURL, this.mc.thePlayer.getEntityTexture(), this.mc.thePlayer.slimModel ? PlayerSkinParser.instanceAlex : PlayerSkinParser.instanceSteve);
            MobRendererPlayer playerRenderer = (MobRendererPlayer)EntityRenderDispatcher.instance.getRenderer(this.mc.thePlayer);
            GL11.glPushMatrix();
            GL11.glTranslatef(-0.0f, -0.6f, -1.1f);
            GL11.glRotatef(180.0f, 0.0f, 1.0f, 0.0f);
            GL11.glRotatef(-45.0f, 1.0f, 0.0f, 0.0f);
            GL11.glRotatef(31.0f, 0.0f, 0.0f, 1.0f);
            GL11.glRotatef(65.0f, 0.0f, 1.0f, 0.0f);
            GL11.glPushMatrix();
            GL11.glScalef(0.0625f, 0.0625f, -0.0625f);
            GL11.glTranslatef(0.0f, 16.0f, 0.0f);
            GL11.glRotatef(180.0f, 1.0f, 0.0f, 0.0f);
            GL11.glTranslatef(0.0f, -16.0f, 0.0f);
            GL11.glTranslatef(0.0f, 8.0f, 0.0f);
            playerRenderer.drawFirstPersonHand(Tessellator.instance, this.mc.thePlayer, true);
            GL11.glPopMatrix();
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef(-0.0f, -0.6f, 1.1f);
            GL11.glRotatef(-45.0f, 1.0f, 0.0f, 0.0f);
            GL11.glRotatef(-31.0f, 0.0f, 0.0f, 1.0f);
            GL11.glRotatef(-65.0f, 0.0f, 1.0f, 0.0f);
            GL11.glPushMatrix();
            GL11.glScalef(0.0625f, 0.0625f, -0.0625f);
            GL11.glTranslatef(0.0f, 16.0f, 0.0f);
            GL11.glRotatef(180.0f, 1.0f, 0.0f, 0.0f);
            GL11.glTranslatef(0.0f, -16.0f, 0.0f);
            GL11.glTranslatef(0.0f, 8.0f, 0.0f);
            playerRenderer.drawFirstPersonHand(Tessellator.instance, this.mc.thePlayer, false);
            GL11.glPopMatrix();
            GL11.glPopMatrix();
            float f_val3 = MathHelper.sin(swingProgress * swingProgress * (float)Math.PI);
            float f_val4 = MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)Math.PI);
            GL11.glRotatef(-f_val3 * 20.0f, 0.0f, 1.0f, 0.0f);
            GL11.glRotatef(-f_val4 * 20.0f, 0.0f, 0.0f, 1.0f);
            GL11.glRotatef(-f_val4 * 80.0f, 1.0f, 0.0f, 0.0f);
            float scale1 = 0.38f;
            GL11.glScalef(0.38f, 0.38f, 0.38f);
            GL11.glRotatef(90.0f, 0.0f, 1.0f, 0.0f);
            GL11.glRotatef(180.0f, 0.0f, 0.0f, 1.0f);
            GL11.glTranslatef(-1.0f, -1.0f, 0.0f);
            float scale2 = 0.015625f;
            GL11.glScalef(0.015625f, 0.015625f, 0.015625f);
            GL11.glNormal3f(0.0f, 0.0f, -1.0f);
            this.mc.textureManager.bindTexture(this.mc.textureManager.loadTexture("/assets/minecraft/textures/misc/mapbg.png"));
            tessellator.startDrawingQuads();
            int expansion = 7;
            tessellator.addVertexWithUV(-7.0, 135.0, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(135.0, 135.0, 0.0, 1.0, 1.0);
            tessellator.addVertexWithUV(135.0, -7.0, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(-7.0, -7.0, 0.0, 0.0, 0.0);
            tessellator.draw();
            ItemMapSavedData mapData = Items.MAP.getOrCreateSavedData(itemStack, this.mc.currentWorld);
            if (mapData != null) {
                this.renderMapInstance.renderMap(tessellator, mapData, brightness);
            }
            GL11.glPopMatrix();
        } else {
            super.renderFirstPerson(tessellator, itemRenderer, player, itemStack, brightness, alpha, partialTick);
        }
    }

    @Override
    @NotNull
    public IconCoordinate getIcon(@Nullable Entity entity, ItemStack itemStack) {
        if (!ItemMap.hasInitialized(itemStack)) {
            return TextureRegistry.getTexture("minecraft:item/map_blank");
        }
        return super.getIcon(entity, itemStack);
    }
}

