/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Fluid;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;

public abstract class BlockLogicFluid
extends BlockLogic {
    @NotNull
    protected final Fluid fluid;

    public BlockLogicFluid(Block<?> block, Material material, @NotNull Fluid fluid) {
        super(block, material);
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        this.fluid = fluid;
    }

    public static float getHeight(int data) {
        if ((data &= 0xF) >= 8) {
            data = 0;
        }
        return (float)(data + 1) / 8.0f;
    }

    protected int getDepth(WorldSource worldSource, int x, int y, int z) {
        if (worldSource.getBlockMaterial(x, y, z) != this.material) {
            return -1;
        }
        return worldSource.getBlockMetadata(x, y, z) & 0xF;
    }

    protected int getRenderedDepth(WorldSource worldSource, int x, int y, int z) {
        if (worldSource.getBlockMaterial(x, y, z) != this.material) {
            return -1;
        }
        int meta = worldSource.getBlockMetadata(x, y, z) & 0xF;
        if (meta >= 8) {
            meta = 0;
        }
        return meta;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, int x, int y, int z, @NotNull Side side) {
        return PartialSupport.INSTANCE;
    }

    @Override
    public boolean canCollideCheck(int meta, boolean shouldCollideWithFluids) {
        return shouldCollideWithFluids && (meta & 0xF) == 0;
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(WorldSource worldSource, int x, int y, int z) {
        return null;
    }

    private Vec3 getFlow(WorldSource worldSource, int x, int y, int z) {
        Vec3 result = Vec3.fromPool(0.0, 0.0, 0.0);
        int depthLocal = this.getRenderedDepth(worldSource, x, y, z);
        for (int i = 0; i < 4; ++i) {
            int mult;
            int depthCheck;
            int checkX = x;
            int checkZ = z;
            if (i == 0) {
                --checkX;
            }
            if (i == 1) {
                --checkZ;
            }
            if (i == 2) {
                ++checkX;
            }
            if (i == 3) {
                ++checkZ;
            }
            if ((depthCheck = this.getRenderedDepth(worldSource, checkX, y, checkZ)) < 0) {
                if (worldSource.getBlockMaterial(checkX, y, checkZ).blocksMotion() || (depthCheck = this.getRenderedDepth(worldSource, checkX, y - 1, checkZ)) < 0) continue;
                mult = depthCheck - (depthLocal - 8);
                result = result.add((checkX - x) * mult, 0.0, (checkZ - z) * mult);
                continue;
            }
            mult = depthCheck - depthLocal;
            result = result.add((checkX - x) * mult, 0.0, (checkZ - z) * mult);
        }
        result = result.normalize();
        return result;
    }

    @Override
    public void handleEntityInside(World world, int x, int y, int z, Entity entity, Vec3 entityVelocity) {
        if (entity.noPhysics) {
            return;
        }
        Vec3 flowVector = this.getFlow(world, x, y, z);
        entityVelocity.x += flowVector.x;
        entityVelocity.y += flowVector.y;
        entityVelocity.z += flowVector.z;
    }

    @Override
    public int tickDelay() {
        return this.fluid.tickDelay();
    }

    @Override
    public float getBlockBrightness(WorldSource worldSource, int x, int y, int z) {
        float br = worldSource.getLightBrightness(x, y, z);
        float brAbove = worldSource.getLightBrightness(x, y + 1, z);
        return Math.max(br, brAbove);
    }

    @Override
    public void animationTick(World world, int x, int y, int z, Random rand) {
        this.fluid.animationTick(this, world, x, y, z, rand);
    }

    public double getSlopeAngle(WorldSource worldSource, int x, int y, int z) {
        Vec3 vec = this.getFlow(worldSource, x, y, z);
        if (vec == null || vec.x == 0.0 && vec.z == 0.0) {
            return -1000.0;
        }
        return Math.atan2(vec.z, vec.x) - 1.5707963267948966;
    }

    @Override
    public void onBlockPlacedByWorld(World world, int x, int y, int z) {
        this.checkForHarden(world, x, y, z);
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        this.checkForHarden(world, x, y, z);
    }

    private void checkForHarden(World world, int x, int y, int z) {
        if (world.getBlockId(x, y, z) != this.block.id()) {
            return;
        }
        this.fluid.checkForHarden(this, world, x, y, z, world.getBlockMaterial(x, y, z - 1));
        this.fluid.checkForHarden(this, world, x, y, z, world.getBlockMaterial(x, y, z + 1));
        this.fluid.checkForHarden(this, world, x, y, z, world.getBlockMaterial(x - 1, y, z));
        this.fluid.checkForHarden(this, world, x, y, z, world.getBlockMaterial(x + 1, y, z));
        this.fluid.checkForHarden(this, world, x, y, z, world.getBlockMaterial(x, y + 1, z));
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, TileEntity tileEntity) {
        return null;
    }

    protected static void fizz(World world, int x, int y, int z) {
        world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
        for (int i = 0; i < 8; ++i) {
            world.spawnParticle("largesmoke", (double)x + Math.random(), (double)y + 1.2, (double)z + Math.random(), 0.0, 0.0, 0.0, 0);
        }
    }

    @Override
    public AABB getBlockBoundsFromState(WorldSource worldSource, int x, int y, int z) {
        float myHeight = this.getFluidHeight(worldSource, x, y, z);
        float heightPosZ = this.getFluidHeight(worldSource, x, y, z + 1);
        float heightPosXPosZ = this.getFluidHeight(worldSource, x + 1, y, z + 1);
        float heightPosX = this.getFluidHeight(worldSource, x + 1, y, z);
        return AABB.fromPool(0.0, 0.0, 0.0, 1.0, Math.max((double)((myHeight + heightPosZ + heightPosXPosZ + heightPosX) / 4.0f), 0.2), 1.0);
    }

    public float getFluidHeight(WorldSource worldSource, int x, int y, int z) {
        int count = 0;
        float height = 0.0f;
        for (int i = 0; i < 4; ++i) {
            int xx = x - (i & 1);
            int zz = z - (i >> 1 & 1);
            if (worldSource.getBlockMaterial(xx, y + 1, zz) == this.material) {
                return 1.0f;
            }
            Material adjMaterial = worldSource.getBlockMaterial(xx, y, zz);
            if (adjMaterial == this.material) {
                int data = worldSource.getBlockMetadata(xx, y, zz) & 0xF;
                if (data >= 8 || data == 0) {
                    height += BlockLogicFluid.getHeight(data) * 10.0f;
                    count += 10;
                }
                height += BlockLogicFluid.getHeight(data);
                ++count;
                continue;
            }
            if (adjMaterial.isSolid()) continue;
            height += 1.0f;
            ++count;
        }
        return Math.max(1.0f - height / (float)count, 0.015f);
    }

    @Override
    public boolean isEquivalent(@NotNull World world, int thisX, int thisY, int thisZ, int otherX, int otherY, int otherZ) {
        Block<?> bBlock = world.getBlock(otherX, otherY, otherZ);
        int thisMeta = world.getBlockMetadata(thisX, thisY, thisZ);
        int otherMeta = world.getBlockMetadata(otherX, otherY, otherZ);
        if (Block.hasLogicClass(bBlock, BlockLogicFluid.class)) {
            return this.material == bBlock.getMaterial() && thisMeta == otherMeta;
        }
        return false;
    }
}

