/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.chunk.perlin.overworld.hell;

import net.minecraft.core.block.BlockLogicOreCoal;
import net.minecraft.core.block.BlockLogicOreDiamond;
import net.minecraft.core.block.BlockLogicOreGold;
import net.minecraft.core.block.BlockLogicOreIron;
import net.minecraft.core.block.BlockLogicOreLapis;
import net.minecraft.core.block.BlockLogicOreRedstone;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.generate.chunk.ChunkFeatureDecorator;
import net.minecraft.core.world.generate.feature.WorldFeature;
import net.minecraft.core.world.generate.feature.WorldFeatureClay;
import net.minecraft.core.world.generate.feature.WorldFeatureDeadBush;
import net.minecraft.core.world.generate.feature.WorldFeatureDungeon;
import net.minecraft.core.world.generate.feature.WorldFeatureLabyrinth;
import net.minecraft.core.world.generate.feature.WorldFeatureLake;
import net.minecraft.core.world.generate.feature.WorldFeatureLiquid;
import net.minecraft.core.world.generate.feature.WorldFeatureOre;
import net.minecraft.core.world.generate.feature.tree.WorldFeatureTree;
import net.minecraft.core.world.generate.feature.tree.WorldFeatureTreeFancy;
import net.minecraft.core.world.noise.PerlinNoise;
import org.jetbrains.annotations.NotNull;

public class ChunkDecoratorOverworldHell
extends ChunkFeatureDecorator {
    private final PerlinNoise treeDensityNoise;

    public ChunkDecoratorOverworldHell(@NotNull World world) {
        super(world);
        this.treeDensityNoise = new PerlinNoise(world.getRandomSeed(), 8, 74);
    }

    @Override
    public void registerDecorations() {
        this.register(0, (world, chunk, worldX, worldZ, minY, maxY, rangeY, rand) -> {
            if (rand.nextInt(32) == 0) {
                int xx = worldX + rand.nextInt(16) + 8;
                int yy = minY + rand.nextInt(rangeY);
                int zz = worldZ + rand.nextInt(16) + 8;
                new WorldFeatureLake(Blocks.FLUID_LAVA_STILL.id()).place(world, rand, xx, yy, zz);
            }
        });
        this.register(1, (world, chunk, worldX, worldZ, minY, maxY, rangeY, rand) -> {
            if (rand.nextInt(16) == 0) {
                int xx = worldX + rand.nextInt(16) + 8;
                int yy = minY + rand.nextInt(rangeY - 16) + 8;
                int zz = worldZ + rand.nextInt(16) + 8;
                if (yy < minY + rangeY / 2 || rand.nextInt(10) == 0) {
                    if (rand.nextInt(4) == 0) {
                        new WorldFeatureLake(Blocks.OBSIDIAN.id()).place(world, rand, xx, yy, zz);
                    } else {
                        new WorldFeatureLake(Blocks.FLUID_LAVA_STILL.id()).place(world, rand, xx, yy, zz);
                    }
                }
            }
        });
        this.register(2, (world, chunk, worldX, worldZ, minY, maxY, rangeY, rand) -> {
            for (int i = 0; i < 50; ++i) {
                int xx = worldX + rand.nextInt(16) + 8;
                int yy = minY + rand.nextInt(rangeY / 2);
                int zz = worldZ + rand.nextInt(16) + 8;
                if (yy >= minY + rangeY / 2) continue;
                new WorldFeatureLiquid(Blocks.FLUID_WATER_FLOWING.id()).place(world, rand, xx, yy, zz);
            }
        });
        this.register(3, (world, chunk, worldX, worldZ, minY, maxY, rangeY, rand) -> {
            for (int i = 0; i < 8; ++i) {
                int xx = worldX + rand.nextInt(16) + 8;
                int yy = minY + rand.nextInt(rangeY);
                int zz = worldZ + rand.nextInt(16) + 8;
                if (rand.nextInt(2) == 0) {
                    new WorldFeatureDungeon(Blocks.BRICK_CLAY.id(), Blocks.BRICK_CLAY.id(), null).place(world, rand, xx, yy, zz);
                    continue;
                }
                new WorldFeatureDungeon(Blocks.COBBLE_STONE.id(), Blocks.COBBLE_STONE_MOSSY.id(), null).place(world, rand, xx, yy, zz);
            }
        });
        this.register(4, (world, chunk, worldX, worldZ, minY, maxY, rangeY, rand) -> {
            for (int i = 0; i < 1; ++i) {
                int xx = worldX + rand.nextInt(16) + 8;
                int zz = worldZ + rand.nextInt(16) + 8;
                int yy = world.getHeightValue(xx, zz) - (rand.nextInt(2) + 2);
                if (rand.nextInt(10) == 0) {
                    yy -= rand.nextInt(10) + 30;
                }
                if (rand.nextInt(512) != 0) continue;
                new WorldFeatureLabyrinth().place(world, rand, xx, yy, zz);
            }
        });
        this.register(5, (world, chunk, worldX, worldZ, minY, maxY, rangeY, rand) -> {
            for (int i = 0; i < 20; ++i) {
                int xx = worldX + rand.nextInt(16);
                int yy = minY + rand.nextInt(rangeY);
                int zz = worldX + rand.nextInt(16);
                new WorldFeatureClay(32).place(world, rand, xx, yy, zz);
            }
        });
        this.register(6, (world, chunk, worldX, worldZ, minY, maxY, rangeY, rand) -> {
            for (int i = 0; i < 20; ++i) {
                int xx = worldX + rand.nextInt(16);
                int yy = minY + rand.nextInt(rangeY);
                int zz = worldZ + rand.nextInt(16);
                new WorldFeatureOre(Blocks.DIRT.id(), 32).place(world, rand, xx, yy, zz);
            }
        });
        this.register(7, (world, chunk, worldX, worldZ, minY, maxY, rangeY, rand) -> {
            for (int i = 0; i < 10; ++i) {
                int xx = worldX + rand.nextInt(16);
                int yy = minY + rand.nextInt(rangeY);
                int zz = worldZ + rand.nextInt(16);
                new WorldFeatureOre(Blocks.GRAVEL.id(), 32).place(world, rand, xx, yy, zz);
            }
        });
        this.register(8, (world, chunk, worldX, worldZ, minY, maxY, rangeY, rand) -> {
            for (int i = 0; i < 20; ++i) {
                int xx = worldX + rand.nextInt(16);
                int yy = minY + rand.nextInt(rangeY);
                int zz = worldZ + rand.nextInt(16);
                new WorldFeatureOre(BlockLogicOreCoal.variantMap, 16).place(world, rand, xx, yy, zz);
            }
        });
        this.register(9, (world, chunk, worldX, worldZ, minY, maxY, rangeY, rand) -> {
            for (int i = 0; i < 20; ++i) {
                int xx = worldX + rand.nextInt(16);
                int yy = minY + rand.nextInt(rangeY / 2);
                int zz = worldZ + rand.nextInt(16);
                new WorldFeatureOre(BlockLogicOreIron.variantMap, 8).place(world, rand, xx, yy, zz);
            }
        });
        this.register(10, (world, chunk, worldX, worldZ, minY, maxY, rangeY, rand) -> {
            for (int i = 0; i < 2; ++i) {
                int xx = worldX + rand.nextInt(16);
                int yy = minY + rand.nextInt(rangeY / 4);
                int zz = worldZ + rand.nextInt(16);
                new WorldFeatureOre(BlockLogicOreGold.variantMap, 8).place(world, rand, xx, yy, zz);
            }
        });
        this.register(11, (world, chunk, worldX, worldZ, minY, maxY, rangeY, rand) -> {
            for (int i = 0; i < 8; ++i) {
                int xx = worldX + rand.nextInt(16);
                int yy = minY + rand.nextInt(rangeY / 8);
                int zz = worldZ + rand.nextInt(16);
                new WorldFeatureOre(BlockLogicOreRedstone.variantMap, 7).place(world, rand, xx, yy, zz);
            }
        });
        this.register(12, (world, chunk, worldX, worldZ, minY, maxY, rangeY, rand) -> {
            for (int i = 0; i < 1; ++i) {
                int xx = worldX + rand.nextInt(16);
                int yy = minY + rand.nextInt(rangeY / 8);
                int zz = worldZ + rand.nextInt(16);
                new WorldFeatureOre(BlockLogicOreDiamond.variantMap, 7).place(world, rand, xx, yy, zz);
            }
        });
        this.register(13, (world, chunk, worldX, worldZ, minY, maxY, rangeY, rand) -> {
            for (int i = 0; i < 1; ++i) {
                int xx = worldX + rand.nextInt(16);
                int yy = minY + rand.nextInt(rangeY / 8) + rand.nextInt(rangeY / 8);
                int zz = worldZ + rand.nextInt(16);
                new WorldFeatureOre(BlockLogicOreLapis.variantMap, 6).place(world, rand, xx, yy, zz);
            }
        });
        this.register(14, (world, chunk, worldX, worldZ, minY, maxY, rangeY, rand) -> {
            double d = 0.5;
            int treeDensity = (int)((this.treeDensityNoise.get((double)worldX * 0.5, (double)worldZ * 0.5) / 8.0 + rand.nextDouble() * 4.0 + 4.0) / 3.0);
            if (rand.nextInt(10) == 0) {
                ++treeDensity;
            }
            treeDensity /= 2;
            for (int i = 0; i < treeDensity; ++i) {
                boolean hasLeaves = rand.nextInt(1234) == 0;
                int xx = worldX + rand.nextInt(16) + 8;
                int zz = worldZ + rand.nextInt(16) + 8;
                WorldFeature wf = rand.nextInt(10) == 0 ? new WorldFeatureTreeFancy(hasLeaves ? Blocks.LEAVES_OAK.id() : 0, Blocks.LOG_OAK.id()) : new WorldFeatureTree(hasLeaves ? Blocks.LEAVES_OAK.id() : 0, Blocks.LOG_OAK.id(), 4);
                wf.init(1.0, 1.0, 1.0);
                wf.place(world, rand, xx, world.getHeightValue(xx, zz), zz);
            }
        });
        this.register(15, (world, chunk, worldX, worldZ, minY, maxY, rangeY, rand) -> {
            for (int i = 0; i < 10; ++i) {
                int xx = worldX + rand.nextInt(16) + 8;
                int yy = minY + rand.nextInt(rangeY);
                int zz = worldZ + rand.nextInt(16) + 8;
                new WorldFeatureDeadBush(Blocks.DEADBUSH.id()).place(world, rand, xx, yy, zz);
            }
        });
        this.register(16, (world, chunk, worldX, worldZ, minY, maxY, rangeY, rand) -> {
            for (int i = 0; i < 5; ++i) {
                int xx = worldX + rand.nextInt(16) + 8;
                int yy = minY + rand.nextInt(rand.nextInt(rangeY - 8) + 8);
                int zz = worldZ + rand.nextInt(16) + 8;
                new WorldFeatureLiquid(Blocks.FLUID_LAVA_FLOWING.id()).place(world, rand, xx, yy, zz);
            }
        });
        this.register(17, (world, chunk, worldX, worldZ, minY, maxY, rangeY, rand) -> {
            for (int i = 0; i < 20; ++i) {
                int xx = worldX + rand.nextInt(16) + 8;
                int yy = minY + rand.nextInt(rand.nextInt(rand.nextInt(rangeY - rangeY / 8) + 8) + 8);
                int zz = worldZ + rand.nextInt(16) + 8;
                new WorldFeatureLiquid(Blocks.FLUID_LAVA_FLOWING.id()).place(world, rand, xx, yy, zz);
            }
        });
    }

    @Override
    public void postDecorate(@NotNull World world, @NotNull Chunk chunk) {
        int x = chunk.pos.x;
        int z = chunk.pos.z;
        int worldX = x * 16;
        int worldZ = z * 16;
        int minY = world.getWorldType().getMinY();
        if (world.getBlockId(worldX, minY + world.getWorldType().getOceanY() - 1, worldZ) == world.getWorldType().getOceanBlockId()) {
            world.setBlockWithNotify(worldX, minY + world.getWorldType().getOceanY() - 1, worldZ, world.getWorldType().getOceanBlockId());
        }
    }
}

