/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.pos;

import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.pos.ChunkPos;
import net.minecraft.core.world.pos.ChunkSectionTilePos;
import net.minecraft.core.world.pos.Pos3i;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChunkTilePos
implements Pos3i<ChunkTilePos> {
    public int x;
    public int y;
    public int z;

    public ChunkTilePos(int x, int y, int z) {
        this.x = Integer.remainderUnsigned(x, 16);
        this.y = y;
        this.z = Integer.remainderUnsigned(z, 16);
    }

    public ChunkTilePos(float x, float y, float z) {
        this(MathHelper.floor(x), MathHelper.floor(y), MathHelper.floor(z));
    }

    public ChunkTilePos(double x, double y, double z) {
        this(MathHelper.floor(x), MathHelper.floor(y), MathHelper.floor(z));
    }

    public ChunkTilePos(@NotNull TilePos tilePos) {
        this(tilePos.x, tilePos.y, tilePos.z);
    }

    public ChunkTilePos(@NotNull Vec3 vec) {
        this(vec.x, vec.y, vec.z);
    }

    public ChunkTilePos(@NotNull Entity entity) {
        this(entity.x, entity.y, entity.z);
    }

    @Override
    public int x() {
        return this.x;
    }

    @Override
    public int y() {
        return this.y;
    }

    @Override
    public int z() {
        return this.z;
    }

    @Override
    @NotNull
    public ChunkTilePos add(int x, int y, int z) {
        return new ChunkTilePos(this.x + x, this.y + y, this.z + z);
    }

    @NotNull
    public TilePos toTilePos(@NotNull ChunkPos chunkPos) {
        return new TilePos(chunkPos, this);
    }

    @NotNull
    public ChunkSectionTilePos toChunkSectionTilePos() {
        return new ChunkSectionTilePos(this);
    }

    public boolean inBounds() {
        return this.x >= 0 && this.x < 16 && this.y >= 0 && this.y < 256 && this.z >= 0 && this.z < 16;
    }

    public int getSectionIndex() {
        return this.y / 16;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof ChunkTilePos)) {
            return false;
        }
        @NotNull ChunkTilePos other = (ChunkTilePos)obj;
        return this.x == other.x && this.y == other.y && this.z == other.z;
    }

    public int hashCode() {
        return MathHelper.cantor(MathHelper.cantor(this.x, this.y), this.z);
    }
}

