/*
 * Decompiled with CFR 0.152.
 */
package org.useless.dragonfly.data.block.mojang;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.stream.JsonReader;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.render.texturepack.TexturePackList;
import net.minecraft.core.util.HardIllegalArgumentException;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.Direction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.useless.dragonfly.DisplayPos;
import org.useless.dragonfly.data.block.BlockModelData;
import org.useless.dragonfly.data.block.mojang.Element;
import org.useless.dragonfly.data.block.mojang.Face;
import org.useless.dragonfly.data.block.mojang.Rotation;
import org.useless.dragonfly.models.block.StaticBlockModel;
import org.useless.dragonfly.models.block.mojang.StaticBlockModelMojang;

public class BlockModelMojangData
implements BlockModelData {
    public static final float UNITS_PER_BLOCK = 16.0f;
    public static final float BLOCKS_PER_UNIT = 0.0625f;
    protected static final Logger LOGGER = LogUtils.getLogger();
    protected static final Gson gson = BlockModelMojangData.builder().create();
    protected static final String DEFAULT_NAMESPACE = "minecraft";
    protected static final String DEFAULT_PARENT = null;
    protected static final boolean DEFAULT_AMBIENT_OCCLUSION = true;
    protected static final int DEFAULT_RENDER_LAYER = 0;
    protected final NamespaceID modelId;
    @Nullable
    public final String parent;
    public final boolean ambientOcclusion;
    @Nullable
    public final Integer renderLayer;
    public final @Nullable Map<@NotNull String, @NotNull DisplayPos> displayPositions;
    public final @Nullable Map<@NotNull String, @NotNull String> textures;
    public final @Nullable Object2IntMap<@NotNull Direction> particleIndices;
    public final @Nullable List<@NotNull Element> elements;

    protected static GsonBuilder builder() {
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        builder.registerTypeAdapter((Type)((Object)Builder.class), new Builder.Serializer());
        builder.registerTypeAdapter((Type)((Object)Element.Builder.class), new Element.Builder.Serializer());
        builder.registerTypeAdapter((Type)((Object)Face.Builder.class), new Face.Builder.Serializer());
        builder.registerTypeAdapter((Type)((Object)Rotation.Builder.class), new Rotation.Builder.Serializer());
        builder.registerTypeAdapter((Type)((Object)DisplayPos.class), new DisplayPos.Serializer());
        return builder;
    }

    protected BlockModelMojangData(@NotNull TexturePackList texturePackList, @NotNull NamespaceID id, @Nullable String parent, boolean ambientOcclusion, @Nullable Integer renderLayer, @Nullable Map<@NotNull String, @NotNull DisplayPos> displayPositions, @Nullable Map<@NotNull String, @NotNull String> textures, @Nullable Object2IntMap<@NotNull Direction> particleIndices, @Nullable List<@NotNull Element> elements) {
        this.modelId = id.makePermanent();
        this.parent = parent;
        if (parent != null) {
            BlockModelMojangData parentData = Cache.loadModelData(texturePackList, parent);
            this.ambientOcclusion = ambientOcclusion;
            if (parentData != null) {
                this.displayPositions = new HashMap<String, DisplayPos>();
                this.textures = new HashMap<String, String>();
                this.particleIndices = new Object2IntArrayMap<Direction>();
                this.elements = parentData.elements != null && elements == null ? new ArrayList<Element>(parentData.elements) : elements;
                Integer n = this.renderLayer = parentData.renderLayer != null && renderLayer == null ? parentData.renderLayer : renderLayer;
                if (parentData.displayPositions != null) {
                    this.displayPositions.putAll(parentData.displayPositions);
                }
                if (displayPositions != null) {
                    this.displayPositions.putAll(displayPositions);
                }
                if (parentData.textures != null) {
                    this.textures.putAll(parentData.textures);
                }
                if (textures != null) {
                    this.textures.putAll(textures);
                }
                if (parentData.particleIndices != null) {
                    this.particleIndices.putAll(parentData.particleIndices);
                }
                if (particleIndices != null) {
                    this.particleIndices.putAll(particleIndices);
                }
            } else {
                this.displayPositions = displayPositions;
                this.particleIndices = particleIndices;
                this.renderLayer = renderLayer;
                this.textures = textures;
                this.elements = elements;
            }
        } else {
            this.ambientOcclusion = ambientOcclusion;
            this.displayPositions = displayPositions;
            this.particleIndices = particleIndices;
            this.renderLayer = renderLayer;
            this.textures = textures;
            this.elements = elements;
        }
    }

    @Override
    @NotNull
    public NamespaceID modelId() {
        return this.modelId;
    }

    @Override
    @NotNull
    public StaticBlockModel asModel() {
        return new StaticBlockModelMojang(this);
    }

    public String toString() {
        return "BlockModelMojangData{modelId=" + String.valueOf(this.modelId) + ", parent='" + this.parent + "', ambientOcclusion=" + this.ambientOcclusion + ", displayPositions=" + String.valueOf(this.displayPositions) + ", textures=" + String.valueOf(this.textures) + ", particleIndices=" + String.valueOf(this.particleIndices) + ", elements=" + String.valueOf(this.elements) + "}";
    }

    public static class Builder {
        @Nullable
        protected String parent = DEFAULT_PARENT;
        protected boolean ambientOcclusion = true;
        protected int renderLayer = 0;
        protected @Nullable Map<@NotNull String, @NotNull DisplayPos> displayPosMap = null;
        protected @Nullable Map<@NotNull String, @NotNull String> textures = null;
        protected @Nullable Object2IntMap<@NotNull Direction> particleIndices = null;
        protected @Nullable List<@NotNull Element.Builder> elements = null;

        @NotNull
        public Builder setParent(@Nullable String parent) {
            this.parent = parent;
            return this;
        }

        @NotNull
        public Builder setAO(boolean ao) {
            this.ambientOcclusion = ao;
            return this;
        }

        @NotNull
        public Builder setRenderLayer(int renderLayer) {
            this.renderLayer = renderLayer;
            return this;
        }

        @NotNull
        public Builder setDisplay(@NotNull String id, @Nullable DisplayPos displayPos) {
            if (displayPos == null && this.displayPosMap != null) {
                this.displayPosMap.remove(id);
            } else if (displayPos != null) {
                this.prepareDisplayPosMap().put(id, displayPos);
            }
            return this;
        }

        @NotNull
        public Builder setTexture(@NotNull String textureVariable, @NotNull String textureSymbol) {
            this.prepareTextureMap().put(textureVariable, textureSymbol);
            return this;
        }

        @NotNull
        public Builder setParticleIndex(@NotNull Direction direction, int index) {
            this.prepareParticleIndicesMap().put(direction, index);
            return this;
        }

        @NotNull
        public Builder addElement(@NotNull Element.Builder elementBuilder) {
            this.prepareElementsList().add(elementBuilder);
            return this;
        }

        @NotNull
        private @NotNull Map<@NotNull String, @NotNull DisplayPos> prepareDisplayPosMap() {
            if (this.displayPosMap == null) {
                this.displayPosMap = new HashMap<String, DisplayPos>();
            }
            return this.displayPosMap;
        }

        @NotNull
        private @NotNull Map<@NotNull String, @NotNull String> prepareTextureMap() {
            if (this.textures == null) {
                this.textures = new HashMap<String, String>();
            }
            return this.textures;
        }

        @NotNull
        private @NotNull Object2IntMap<@NotNull Direction> prepareParticleIndicesMap() {
            if (this.particleIndices == null) {
                this.particleIndices = new Object2IntArrayMap<Direction>();
            }
            return this.particleIndices;
        }

        @NotNull
        private @NotNull List<@NotNull Element.Builder> prepareElementsList() {
            if (this.elements == null) {
                this.elements = new ArrayList<Element.Builder>();
            }
            return this.elements;
        }

        @NotNull
        protected BlockModelMojangData build(@NotNull TexturePackList texturePackList, @NotNull String id) {
            if (!((String)id).contains(":")) {
                id = "minecraft:" + (String)id;
            }
            ArrayList<Element> elementList = null;
            if (this.elements != null) {
                elementList = new ArrayList<Element>();
                for (Element.Builder b : this.elements) {
                    elementList.add(b.build());
                }
            }
            try {
                return new BlockModelMojangData(texturePackList, (NamespaceID)NamespaceID.fromPool((String)id).copyUnpooled(), this.parent, this.ambientOcclusion, this.renderLayer, this.displayPosMap, this.textures, this.particleIndices, elementList);
            }
            catch (HardIllegalArgumentException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public static class Serializer
        implements JsonSerializer<Builder>,
        JsonDeserializer<Builder> {
            @Override
            public Builder deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject textures;
                JsonObject object = json.getAsJsonObject();
                Builder dataBuilder = new Builder();
                if (object.has("parent")) {
                    dataBuilder.setParent(object.get("parent").getAsString());
                }
                if (object.has("ambientocclusion")) {
                    dataBuilder.setAO(object.get("ambientocclusion").getAsBoolean());
                }
                if (object.has("renderlayer")) {
                    dataBuilder.setRenderLayer(object.get("renderlayer").getAsInt());
                }
                if (object.has("display")) {
                    JsonObject display = object.getAsJsonObject("display");
                    for (Map.Entry<String, JsonElement> entry : display.entrySet()) {
                        dataBuilder.setDisplay(entry.getKey(), (DisplayPos)context.deserialize(entry.getValue(), (Type)((Object)DisplayPos.class)));
                    }
                }
                if (object.has("textures")) {
                    textures = object.getAsJsonObject("textures");
                    for (Map.Entry entry : textures.entrySet()) {
                        dataBuilder.setTexture((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                    }
                }
                if (object.has("elements")) {
                    JsonArray elements = object.getAsJsonArray("elements");
                    for (JsonElement jsonElement : elements) {
                        dataBuilder.addElement((Element.Builder)context.deserialize(jsonElement, (Type)((Object)Element.Builder.class)));
                    }
                }
                if (object.has("particles")) {
                    textures = object.getAsJsonObject("particles");
                    for (Map.Entry entry : textures.entrySet()) {
                        dataBuilder.setParticleIndex(Direction.valueOf(((String)entry.getKey()).toUpperCase(Locale.ROOT)), ((JsonElement)entry.getValue()).getAsInt());
                    }
                }
                return dataBuilder;
            }

            @Override
            public JsonElement serialize(Builder src, Type typeOfSrc, JsonSerializationContext context) {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static class Cache {
        protected static final Map<String, BlockModelMojangData> modelDataCache = new HashMap<String, BlockModelMojangData>();
        protected static final String RESOURCE_PATH = "/assets/%s/models/%s.json";

        @Nullable
        public static BlockModelMojangData loadModelData(@NotNull TexturePackList texturePackList, @NotNull NamespaceID id) {
            String s = id.toString();
            if (modelDataCache.containsKey(s)) {
                return modelDataCache.get(s);
            }
            Builder data = Cache.loadFromStream(texturePackList.getResourceAsStream(String.format(RESOURCE_PATH, id.namespace(), id.value())));
            if (data == null) {
                LOGGER.error("Could not locate block model data for id '{}'!", (Object)id);
                return null;
            }
            BlockModelMojangData model = data.build(texturePackList, id.toString());
            modelDataCache.put(model.modelId().toString(), model);
            return model;
        }

        @Nullable
        public static BlockModelMojangData loadModelData(@NotNull TexturePackList texturePackList, @NotNull String id) {
            String value;
            String namespace;
            if (!id.contains(":")) {
                namespace = BlockModelMojangData.DEFAULT_NAMESPACE;
                value = id;
            } else {
                String[] strings = id.split(":");
                if (strings.length != 2) {
                    throw new IllegalArgumentException("Block model id '" + id + "' cannot have more then 1 ':' character!");
                }
                namespace = strings[0];
                value = strings[1];
            }
            if (modelDataCache.containsKey(id)) {
                return modelDataCache.get(id);
            }
            Builder data = Cache.loadFromStream(texturePackList.getResourceAsStream(String.format(RESOURCE_PATH, namespace, value)));
            if (data == null) {
                LOGGER.error("Could not locate block model data for id '{}'!", (Object)id);
                return null;
            }
            BlockModelMojangData model = data.build(texturePackList, namespace + ":" + value);
            modelDataCache.put(model.modelId().toString(), model);
            return model;
        }

        public static void resetCache() {
            modelDataCache.clear();
        }

        @Nullable
        protected static Builder loadFromStream(@Nullable InputStream stream) {
            if (stream == null) {
                return null;
            }
            return (Builder)gson.fromJson(new JsonReader(new InputStreamReader(stream)), (Type)((Object)Builder.class));
        }
    }
}

