/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.server;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.paged.PageComponent;
import net.minecraft.client.gui.server.ScreenSelectServer;
import net.minecraft.client.gui.server.ServerEntry;
import net.minecraft.client.render.font.Alignment;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.TextFormatting;
import org.jetbrains.annotations.NotNull;

public class ServerEntryComponent
implements PageComponent {
    private static final StringBuilder stringBuilder = new StringBuilder(512);
    @NotNull
    public final ServerEntry entry;
    @NotNull
    public final Minecraft mc;
    @NotNull
    public final ScreenSelectServer attachedScreen;

    public ServerEntryComponent(@NotNull ScreenSelectServer attachedScreen, @NotNull ServerEntry entry) {
        this.entry = entry;
        this.mc = Minecraft.getMinecraft();
        this.attachedScreen = attachedScreen;
    }

    @Override
    public int getHeight() {
        return 26;
    }

    @Override
    public void render(int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        Tessellator t = Tessellator.instance;
        if (this.entry.icon != null) {
            this.entry.icon.bind();
            t.startDrawingQuads();
            t.drawRectangleWithUV(x + 1, y + 1, 24, 24, 0.0, 0.0, 1.0, 1.0);
            t.draw();
        }
        this.mc.font.render(t, this.entry.getName("Unknown"), x + 24 + 3, y + 2).setShadow().call();
        if (this.entry.motd != null) {
            stringBuilder.setLength(0);
            stringBuilder.append(TextFormatting.GRAY).append(this.entry.motd);
            stringBuilder.setLength(Math.max(width - 16, 0) / this.mc.font.getFont().charWidth('m'));
            this.mc.font.renderWidthConstrained(t, stringBuilder, x + 24 + 3, this.mc.font.getLastEndingY(), width).setShadow().call();
        }
        if (!this.entry.isUp) {
            stringBuilder.setLength(0);
            stringBuilder.append(I18n.getInstance().translateKey("gui.select_server.label.down"));
            this.mc.font.renderWidthConstrained(t, stringBuilder, x, y + 2, width - 2).setShadow().setColor(0xFF0000).setAlignment(Alignment.RIGHT).call();
        } else if (this.entry.protocolVersion != 65312) {
            stringBuilder.setLength(0);
            stringBuilder.append(I18n.getInstance().translateKey("gui.select_server.label.outdated"));
            this.mc.font.renderWidthConstrained(t, stringBuilder, x, y + 2, width - 2).setShadow().setColor(0xFF0000).setAlignment(Alignment.RIGHT).call();
        } else if (!this.entry.dirty) {
            stringBuilder.setLength(0);
            stringBuilder.append(this.entry.playerCount).append("/").append(this.entry.playerCap);
            this.mc.font.renderWidthConstrained(t, stringBuilder, x, y + 2, width - 2).setShadow().setColor(0xFFFF00).setAlignment(Alignment.RIGHT).call();
            stringBuilder.setLength(0);
            stringBuilder.append(this.entry.ping).append(" ms");
            this.mc.font.renderWidthConstrained(t, stringBuilder, x, this.mc.font.getLastEndingY(), width - 2).setShadow().setColor(0xFFFF00).setAlignment(Alignment.RIGHT).call();
        }
        if (this.entry == this.attachedScreen.selectedEntry) {
            this.attachedScreen.drawBox(x, y, x + width, y + this.getHeight(), -1, 1);
        }
    }

    @Override
    public void onMouseClick(int mouseButton, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        this.attachedScreen.setSelectedEntry(this.entry);
    }

    @Override
    public void onMouseMove(int x, int y, int width, int relativeMouseX, int relativeMouseY) {
    }

    @Override
    public void onMouseRelease(int mouseButton, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
    }

    @Override
    public void onKeyPress(int keyCode, char character) {
    }

    @Override
    public boolean matchesSearchTerm(String term) {
        return false;
    }
}

