/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.server;

import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.TextFieldElement;
import net.minecraft.client.gui.paged.PageComponent;
import net.minecraft.client.gui.server.ScreenSelectServer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.ServerAddress;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.input.Keyboard;

public class SeverDirectConnectComponent
implements PageComponent {
    public final ScreenSelectServer attachedScreen;
    public TextFieldElement ipField;
    public ButtonElement connectButton;

    public SeverDirectConnectComponent(@NotNull ScreenSelectServer attachedScreen) {
        this.attachedScreen = attachedScreen;
        this.ipField = new TextFieldElement(attachedScreen, attachedScreen.fontRenderer, 0, 0, 150, 18, "", "");
        this.connectButton = new ButtonElement(0, 0, 0, 150, 20, I18n.getInstance().translateKey("gui.select_server.popup.direct.button.connect"));
    }

    @Override
    public int getHeight() {
        return this.attachedScreen.height / 2;
    }

    @Override
    public void render(int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        int _x = x + width / 2 - this.ipField.width / 2;
        int _y = this.attachedScreen.height / 2 - 40;
        this.attachedScreen.mc.font.render(Tessellator.instance, I18n.getInstance().translateKey("gui.select_server.popup.add.prompt.ip"), _x, _y).setShadow().call();
        this.ipField.xPosition = _x;
        this.ipField.yPosition = this.attachedScreen.mc.font.getLastEndingY() + 1;
        this.ipField.drawTextBox();
        this.ipField.updateCursor(this.attachedScreen.mc, x + relativeMouseX, y + relativeMouseY);
        this.connectButton.xPosition = _x;
        this.connectButton.yPosition = this.ipField.yPosition + this.ipField.height + 2;
        this.connectButton.drawButton(this.attachedScreen.mc, x + relativeMouseX, y + relativeMouseY);
    }

    @Override
    public void tick() {
        this.ipField.updateCursorCounter();
    }

    @Override
    public void onMouseClick(int mouseButton, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        this.ipField.mouseClicked(x + relativeMouseX, y + relativeMouseY, 0);
        if (this.connectButton.isHovered(x + relativeMouseX, y + relativeMouseY)) {
            this.connect();
        }
    }

    @Override
    public void onMouseMove(int x, int y, int width, int relativeMouseX, int relativeMouseY) {
    }

    @Override
    public void onMouseRelease(int mouseButton, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
    }

    @Override
    public void onKeyPress(int keyCode, char character) {
        if (this.ipField.isFocused && keyCode == Keyboard.KEY_RETURN) {
            this.connect();
        } else if (this.ipField.isFocused && keyCode != Keyboard.KEY_ESCAPE) {
            this.ipField.textboxKeyTyped(character, keyCode);
        } else if (keyCode == Keyboard.KEY_ESCAPE) {
            this.ipField.setFocused(false);
        }
    }

    private void connect() {
        String ip = this.ipField.getText();
        ServerAddress address = ServerAddress.resolveServerIP(ip);
        if (address != null) {
            this.attachedScreen.addressToJoin = address;
        }
    }

    @Override
    public boolean matchesSearchTerm(String term) {
        return false;
    }
}

