/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.piston.BlockLogicPistonBase;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockModelPiston<T extends BlockLogicPistonBase>
extends BlockModelStandard<T> {
    private final IconCoordinate faceTexture;
    protected IconCoordinate sideTexture = TextureRegistry.getTexture("minecraft:block/piston/side");
    protected IconCoordinate topTexture = TextureRegistry.getTexture("minecraft:block/piston/top");
    protected IconCoordinate bottomTexture = TextureRegistry.getTexture("minecraft:block/piston/bottom");
    protected final double headThickness;
    private boolean headless = false;

    public BlockModelPiston(Block<T> block, IconCoordinate faceTexture) {
        this(block, faceTexture, 0.25);
    }

    public BlockModelPiston(Block<T> block, IconCoordinate faceTexture, double headThickness) {
        super(block);
        this.headThickness = headThickness;
        this.faceTexture = faceTexture;
    }

    public BlockModelPiston<T> setPistonTextures(IconCoordinate sideTexture, IconCoordinate topTexture, IconCoordinate bottomTexture) {
        this.sideTexture = sideTexture;
        this.topTexture = topTexture;
        this.bottomTexture = bottomTexture;
        return this;
    }

    public BlockModelPiston<T> setPistonTextures(String sideTexture, String topTexture, String bottomTexture) {
        return this.setPistonTextures(TextureRegistry.getTexture(sideTexture), TextureRegistry.getTexture(topTexture), TextureRegistry.getTexture(bottomTexture));
    }

    @Override
    public boolean render(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, int x, int y, int z) {
        return this.renderPistonBase(tessellator, worldSource, x, y, z, false);
    }

    public boolean renderHeadless(Tessellator tessellator, WorldSource worldSource, int x, int y, int z) {
        BlockModelPiston.renderBlocks.renderAllFaces = true;
        this.headless = true;
        boolean result = this.renderPistonBase(tessellator, worldSource, x, y, z, true);
        this.headless = false;
        BlockModelPiston.renderBlocks.renderAllFaces = false;
        return result;
    }

    protected boolean renderPistonBase(Tessellator tessellator, WorldSource worldSource, int x, int y, int z, boolean noCulling) {
        int meta = worldSource.getBlockMetadata(x, y, z);
        boolean extended = noCulling || (meta & 8) != 0;
        Direction direction = BlockLogicPistonBase.getDirection(meta);
        if (extended) {
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, switch (direction) {
                case Direction.DOWN -> {
                    BlockModelPiston.renderBlocks.uvRotateEast = 3;
                    BlockModelPiston.renderBlocks.uvRotateWest = 3;
                    BlockModelPiston.renderBlocks.uvRotateSouth = 3;
                    BlockModelPiston.renderBlocks.uvRotateNorth = 3;
                    yield AABB.fromPool(0.0, this.headThickness, 0.0, 1.0, 1.0, 1.0);
                }
                case Direction.UP -> AABB.fromPool(0.0, 0.0, 0.0, 1.0, 1.0 - this.headThickness, 1.0);
                case Direction.NORTH -> {
                    BlockModelPiston.renderBlocks.uvRotateSouth = 1;
                    BlockModelPiston.renderBlocks.uvRotateNorth = 2;
                    yield AABB.fromPool(0.0, 0.0, this.headThickness, 1.0, 1.0, 1.0);
                }
                case Direction.SOUTH -> {
                    BlockModelPiston.renderBlocks.uvRotateSouth = 2;
                    BlockModelPiston.renderBlocks.uvRotateNorth = 1;
                    BlockModelPiston.renderBlocks.uvRotateTop = 3;
                    BlockModelPiston.renderBlocks.uvRotateBottom = 3;
                    yield AABB.fromPool(0.0, 0.0, 0.0, 1.0, 1.0, 1.0 - this.headThickness);
                }
                case Direction.WEST -> {
                    BlockModelPiston.renderBlocks.uvRotateEast = 1;
                    BlockModelPiston.renderBlocks.uvRotateWest = 2;
                    BlockModelPiston.renderBlocks.uvRotateTop = 2;
                    BlockModelPiston.renderBlocks.uvRotateBottom = 1;
                    yield AABB.fromPool(this.headThickness, 0.0, 0.0, 1.0, 1.0, 1.0);
                }
                case Direction.EAST -> {
                    BlockModelPiston.renderBlocks.uvRotateEast = 2;
                    BlockModelPiston.renderBlocks.uvRotateWest = 1;
                    BlockModelPiston.renderBlocks.uvRotateTop = 1;
                    BlockModelPiston.renderBlocks.uvRotateBottom = 2;
                    yield AABB.fromPool(0.0, 0.0, 0.0, 1.0 - this.headThickness, 1.0, 1.0);
                }
                default -> AABB.fromPool(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            }, x, y, z);
            renderBlocks.resetRenderBlocks();
        } else {
            switch (direction) {
                case DOWN: {
                    BlockModelPiston.renderBlocks.uvRotateEast = 3;
                    BlockModelPiston.renderBlocks.uvRotateWest = 3;
                    BlockModelPiston.renderBlocks.uvRotateSouth = 3;
                    BlockModelPiston.renderBlocks.uvRotateNorth = 3;
                    break;
                }
                case NORTH: {
                    BlockModelPiston.renderBlocks.uvRotateSouth = 1;
                    BlockModelPiston.renderBlocks.uvRotateNorth = 2;
                    break;
                }
                case SOUTH: {
                    BlockModelPiston.renderBlocks.uvRotateSouth = 2;
                    BlockModelPiston.renderBlocks.uvRotateNorth = 1;
                    BlockModelPiston.renderBlocks.uvRotateTop = 3;
                    BlockModelPiston.renderBlocks.uvRotateBottom = 3;
                    break;
                }
                case WEST: {
                    BlockModelPiston.renderBlocks.uvRotateEast = 1;
                    BlockModelPiston.renderBlocks.uvRotateWest = 2;
                    BlockModelPiston.renderBlocks.uvRotateTop = 2;
                    BlockModelPiston.renderBlocks.uvRotateBottom = 1;
                    break;
                }
                case EAST: {
                    BlockModelPiston.renderBlocks.uvRotateEast = 2;
                    BlockModelPiston.renderBlocks.uvRotateWest = 1;
                    BlockModelPiston.renderBlocks.uvRotateTop = 1;
                    BlockModelPiston.renderBlocks.uvRotateBottom = 2;
                }
            }
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, this.block.getBounds(), x, y, z);
            renderBlocks.resetRenderBlocks();
        }
        return true;
    }

    @Override
    public void renderStandalone(@NotNull Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        super.renderStandalone(tessellator, 1, brightness, alpha, lightmapCoordinate);
    }

    public IconCoordinate getFaceTexture() {
        return this.faceTexture;
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        Direction direction = BlockLogicPistonBase.getDirection(data);
        if (direction == Direction.NONE) {
            return this.blockTextures.get(Side.BOTTOM);
        }
        if (side.getDirection() == direction) {
            if (BlockLogicPistonBase.isPowered(data) || this.headless) {
                return this.topTexture;
            }
            return this.blockTextures.get(Side.BOTTOM);
        }
        return side.getDirection() != direction.getOpposite() ? this.sideTexture : this.bottomTexture;
    }
}

