/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.util.debug;

import it.unimi.dsi.fastutil.ints.Int2BooleanMap;
import it.unimi.dsi.fastutil.ints.Int2BooleanOpenHashMap;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GLDebugMessageCallback;
import org.lwjgl.system.MemoryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenGLLoggerCallback
extends GLDebugMessageCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger("OpenGL");
    private final Int2BooleanMap didReport = new Int2BooleanOpenHashMap();

    @Override
    public void invoke(int source, int type, int id, int severity, int length, long message, long userParam) {
        if (type == 33357) {
            if (this.didReport.getOrDefault(id, false)) {
                return;
            }
            this.didReport.put(id, true);
            LOGGER.warn("Disabling repeated logging of next error, due to known hyper frequency");
        }
        String msg = MemoryUtil.memASCII(message, length);
        switch (severity) {
            case 37190: {
                LOGGER.error("High Severity error from '{}' Type='{}' ErrorCode[{}]:", this.getSourceName(source), this.getTypeName(type), this.getIdName(id), new RuntimeException(msg));
                break;
            }
            case 37191: {
                LOGGER.warn("Medium Severity error from '{}' Type='{}' ErrorCode[{}]:", this.getSourceName(source), this.getTypeName(type), this.getIdName(id), new RuntimeException(msg));
                break;
            }
            case 37192: {
                LOGGER.warn("Low Severity issue from '{}' Type='{}' ErrorCode[{}]:", this.getSourceName(source), this.getTypeName(type), this.getIdName(id), new RuntimeException(msg));
                break;
            }
            default: {
                LOGGER.debug("Notification from '{}' Type='{}' ErrorCode[{}]\t'{}'", this.getSourceName(source), this.getTypeName(type), this.getIdName(id), msg);
            }
        }
    }

    @NotNull
    public String getIdName(int error) {
        return switch (error) {
            case 1280 -> "Invalid Enum";
            case 1281 -> "Invalid Value";
            case 1282 -> "Invalid Operation";
            case 1283 -> "Stack Overflow";
            case 1284 -> "Stack Underflow";
            case 1285 -> "Out of Memory";
            case 1286 -> "Invalid Framebuffer Operation";
            default -> "Unknown 0x" + Integer.toHexString(error);
        };
    }

    @NotNull
    public String getSourceName(int source) {
        return switch (source) {
            case 33350 -> "OpenGL API";
            case 33351 -> "Window System API";
            case 33352 -> "Shader Compiler";
            case 33353 -> "Third Party";
            case 33354 -> "Application";
            case 33355 -> "Other";
            default -> "Other 0x" + Integer.toHexString(source);
        };
    }

    @NotNull
    public String getTypeName(int type) {
        return switch (type) {
            case 33356 -> "Error";
            case 33357 -> "Deprecated Behavior";
            case 33358 -> "Undefined Behavior";
            case 33359 -> "Not Portable";
            case 33360 -> "Performance";
            case 33384 -> "Marker";
            case 33385 -> "Group Push";
            case 33386 -> "Group Pop";
            case 33361 -> "Other";
            default -> "Other 0x" + Integer.toHexString(type);
        };
    }
}

