/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.BoundingVolume;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

interface BlockInterface {
    public int id();

    @NotNull
    public String getKey();

    @NotNull
    public NamespaceID namespaceId();

    public boolean isCubeShaped();

    @Deprecated
    public boolean canPlaceOnSurface();

    @Deprecated
    public boolean canPlaceOnSurfaceOnCondition(World var1, int var2, int var3, int var4);

    public boolean renderAsNormalBlockOnCondition(WorldSource var1, int var2, int var3, int var4);

    @Deprecated
    public boolean canPlaceOnSurfaceOfBlock(World var1, int var2, int var3, int var4);

    public ItemStack[] getBreakResult(World var1, EnumDropCause var2, int var3, int var4, int var5, int var6, TileEntity var7);

    public ItemStack[] getBreakResult(World var1, EnumDropCause var2, int var3, TileEntity var4);

    public AABB getBounds();

    public AABB getBoundsRaw();

    public float getBlockBrightness(WorldSource var1, int var2, int var3, int var4);

    public int getLightmapCoord(WorldSource var1, int var2, int var3, int var4);

    public float getAmbientOcclusionStrength(WorldSource var1, int var2, int var3, int var4);

    public AABB getSelectedBoundingBoxFromPool(WorldSource var1, int var2, int var3, int var4);

    public BoundingVolume getBoundingVolume(World var1, int var2, int var3, int var4);

    public void getCollidingBoundingBoxes(World var1, int var2, int var3, int var4, AABB var5, ArrayList<AABB> var6);

    public boolean collidesWithEntity(Entity var1, World var2, int var3, int var4, int var5);

    public AABB getCollisionBoundingBoxFromPool(WorldSource var1, int var2, int var3, int var4);

    public boolean isSolidRender();

    public boolean blocksLight();

    public boolean canCollideCheck(int var1, boolean var2);

    public boolean isCollidable();

    public void updateTick(World var1, int var2, int var3, int var4, Random var5, boolean var6);

    public void animationTick(World var1, int var2, int var3, int var4, Random var5);

    public void onNeighborBlockChange(World var1, int var2, int var3, int var4, int var5);

    public int tickDelay();

    public void onBlockPlacedByWorld(World var1, int var2, int var3, int var4);

    public void onBlockRemoved(World var1, int var2, int var3, int var4, int var5);

    public void onBlockDestroyedByPlayer(World var1, int var2, int var3, int var4, Side var5, int var6, Player var7, Item var8);

    public float blockStrength(World var1, int var2, int var3, int var4, Side var5, Player var6);

    public boolean getImmovable();

    public float getBlastResistance(Entity var1);

    public HitResult collisionRayTrace(World var1, int var2, int var3, int var4, Vec3 var5, Vec3 var6, boolean var7);

    public void onBlockDestroyedByExplosion(World var1, int var2, int var3, int var4);

    public boolean canPlaceBlockOnSide(World var1, int var2, int var3, int var4, Side var5);

    public boolean canPlaceBlockAt(World var1, int var2, int var3, int var4);

    public boolean onBlockRightClicked(World var1, int var2, int var3, int var4, Player var5, Side var6, double var7, double var9);

    public void onActivatorInteract(World var1, int var2, int var3, int var4, TileEntityActivator var5, Direction var6);

    public void onEntityWalking(World var1, int var2, int var3, int var4, Entity var5);

    public void onBlockLeftClicked(World var1, int var2, int var3, int var4, Player var5, Side var6, double var7, double var9);

    public void handleEntityInside(World var1, int var2, int var3, int var4, Entity var5, Vec3 var6);

    public AABB getBlockBoundsFromState(WorldSource var1, int var2, int var3, int var4);

    public boolean getSignal(WorldSource var1, int var2, int var3, int var4, Side var5);

    public boolean isSignalSource();

    public void onEntityCollidedWithBlock(World var1, int var2, int var3, int var4, Entity var5);

    public boolean getDirectSignal(World var1, int var2, int var3, int var4, Side var5);

    public void harvestBlock(World var1, Player var2, int var3, int var4, int var5, int var6, TileEntity var7);

    public void dropBlockWithCause(World var1, EnumDropCause var2, int var3, int var4, int var5, int var6, TileEntity var7, Player var8);

    @NotNull
    public ISupport getSupport(@NotNull World var1, int var2, int var3, int var4, @NotNull Side var5);

    public boolean canBlockStay(World var1, int var2, int var3, int var4);

    public void onBlockPlacedByMob(World var1, int var2, int var3, int var4, @NotNull Side var5, Mob var6, double var7, double var9);

    public void onBlockPlacedOnSide(World var1, int var2, int var3, int var4, @NotNull Side var5, double var6, double var8);

    public String getLanguageKey(int var1);

    public void triggerEvent(World var1, int var2, int var3, int var4, int var5, int var6);

    public int getPistonPushReaction(World var1, int var2, int var3, int var4);

    public int getPlacedBlockMetadata(@Nullable Player var1, ItemStack var2, World var3, int var4, int var5, int var6, Side var7, double var8, double var10);

    public boolean isClimbable(World var1, int var2, int var3, int var4);

    public boolean isEquivalent(@NotNull World var1, int var2, int var3, int var4, int var5, int var6, int var7);

    @NotNull
    public Side getAttachedSide(@NotNull WorldSource var1, int var2, int var3, int var4);
}

