/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.util.linalg;

import java.util.Objects;
import net.minecraft.core.util.linalg.Vector3;
import net.minecraft.core.util.linalg.Vector4;
import net.minecraft.core.util.pool.ObjectPool;
import net.minecraft.core.util.pool.Poolable;
import org.jetbrains.annotations.NotNull;

public class Matrix4
implements Poolable<Matrix4> {
    @NotNull
    private static final ObjectPool<Matrix4> POOL = new ObjectPool<Matrix4>(Matrix4::new);
    @NotNull
    public final Vector4 x = (Vector4)Vector4.fromPool(0.0, 0.0, 0.0, 0.0).copyUnpooled();
    @NotNull
    public final Vector4 y = (Vector4)Vector4.fromPool(0.0, 0.0, 0.0, 0.0).copyUnpooled();
    @NotNull
    public final Vector4 z = (Vector4)Vector4.fromPool(0.0, 0.0, 0.0, 0.0).copyUnpooled();
    @NotNull
    public final Vector4 w = (Vector4)Vector4.fromPool(0.0, 0.0, 0.0, 0.0).copyUnpooled();

    @NotNull
    public static Matrix4 fromPool(double c0r0, double c1r0, double c2r0, double c3r0, double c0r1, double c1r1, double c2r1, double c3r1, double c0r2, double c1r2, double c2r2, double c3r2, double c0r3, double c1r3, double c2r3, double c3r3) {
        return POOL.get().set(c0r0, c1r0, c2r0, c3r0, c0r1, c1r1, c2r1, c3r1, c0r2, c1r2, c2r2, c3r2, c0r3, c1r3, c2r3, c3r3);
    }

    @NotNull
    public static Matrix4 identity() {
        return Matrix4.fromPool(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    @NotNull
    public static Matrix4 perspective(double fovy, double aspect, double near, double far) {
        assert (fovy > 0.0);
        assert (Math.abs(aspect) != 0.0);
        assert (near > 0.0);
        assert (far > 0.0);
        assert (near != far);
        double f = 1.0 / Math.tan(fovy / 2.0);
        return Matrix4.fromPool(f / aspect, 0.0, 0.0, 0.0, 0.0, f, 0.0, 0.0, 0.0, 0.0, (far + near) / (near - far), 2.0 * far * near / (near - far), 0.0, 0.0, -1.0, 0.0);
    }

    @NotNull
    public static Matrix4 ortho(double left, double right, double bottom, double top, double near, double far) {
        return Matrix4.fromPool(2.0 / (right - left), 0.0, 0.0, (right + left) / (left - right), 0.0, 2.0 / (top - bottom), 0.0, (top + bottom) / (bottom - top), 0.0, 0.0, -2.0 / (far - near), (far + near) / (near - far), 0.0, 0.0, 0.0, 1.0);
    }

    private Matrix4() {
    }

    @Override
    @NotNull
    public ObjectPool<Matrix4> getPool() {
        return POOL;
    }

    @Override
    public void set(@NotNull Matrix4 other) {
        this.x.set(other.x);
        this.y.set(other.y);
        this.z.set(other.z);
        this.w.set(other.w);
    }

    @NotNull
    public Matrix4 set(double c0r0, double c1r0, double c2r0, double c3r0, double c0r1, double c1r1, double c2r1, double c3r1, double c0r2, double c1r2, double c2r2, double c3r2, double c0r3, double c1r3, double c2r3, double c3r3) {
        this.x.set(c0r0, c0r1, c0r2, c0r3);
        this.y.set(c1r0, c1r1, c1r2, c1r3);
        this.z.set(c2r0, c2r1, c2r2, c2r3);
        this.w.set(c3r0, c3r1, c3r2, c3r3);
        return this;
    }

    @NotNull
    public Matrix4 translate(double x, double y, double z) {
        return ((Matrix4)this.copyPooled()).translateInPlace(x, y, z);
    }

    @NotNull
    public Matrix4 translateInPlace(double x, double y, double z) {
        @NotNull Matrix4 translationMatrix = Matrix4.fromPool(1.0, 0.0, 0.0, x, 0.0, 1.0, 0.0, y, 0.0, 0.0, 1.0, z, 0.0, 0.0, 0.0, 1.0);
        return this.multInPlace(translationMatrix);
    }

    @NotNull
    public Matrix4 scale(double scale) {
        return ((Matrix4)this.copyPooled()).scaleInPlace(scale);
    }

    @NotNull
    public Matrix4 scaleInPlace(double scale) {
        return this.scaleInPlace(scale, scale, scale);
    }

    @NotNull
    public Matrix4 scale(double x, double y, double z) {
        return ((Matrix4)this.copyPooled()).scaleInPlace(x, y, z);
    }

    @NotNull
    public Matrix4 scaleInPlace(double x, double y, double z) {
        @NotNull Matrix4 scaleMatrix = Matrix4.fromPool(x, 0.0, 0.0, 0.0, 0.0, y, 0.0, 0.0, 0.0, 0.0, z, 0.0, 0.0, 0.0, 0.0, 1.0);
        return this.multInPlace(scaleMatrix);
    }

    @NotNull
    public Matrix4 rotX(double radians) {
        return ((Matrix4)this.copyPooled()).rotXInPlace(radians);
    }

    @NotNull
    public Matrix4 rotXInPlace(double radians) {
        double sin = Math.sin(radians);
        double cos = Math.cos(radians);
        @NotNull Matrix4 rotMatrix = Matrix4.fromPool(1.0, 0.0, 0.0, 0.0, 0.0, cos, -sin, 0.0, 0.0, sin, cos, 0.0, 0.0, 0.0, 0.0, 1.0);
        return this.multInPlace(rotMatrix);
    }

    @NotNull
    public Matrix4 rotY(double radians) {
        return ((Matrix4)this.copyPooled()).rotYInPlace(radians);
    }

    @NotNull
    public Matrix4 rotYInPlace(double radians) {
        double sin = Math.sin(radians);
        double cos = Math.cos(radians);
        @NotNull Matrix4 rotMatrix = Matrix4.fromPool(cos, 0.0, sin, 0.0, 0.0, 1.0, 0.0, 0.0, -sin, 0.0, cos, 0.0, 0.0, 0.0, 0.0, 1.0);
        return this.multInPlace(rotMatrix);
    }

    @NotNull
    public Matrix4 rotZ(double radians) {
        return ((Matrix4)this.copyPooled()).rotZInPlace(radians);
    }

    @NotNull
    public Matrix4 rotZInPlace(double radians) {
        double sin = Math.sin(radians);
        double cos = Math.sin(radians);
        @NotNull Matrix4 rotMatrix = Matrix4.fromPool(cos, -sin, 0.0, 0.0, sin, cos, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        return this.multInPlace(rotMatrix);
    }

    @NotNull
    public Matrix4 mult(@NotNull Matrix4 other) {
        return ((Matrix4)this.copyPooled()).multInPlace(other);
    }

    @NotNull
    public Matrix4 multInPlace(@NotNull Matrix4 other) {
        this.x.set(this.x.x * other.x.x + this.y.x * other.x.y + this.z.x * other.x.z + this.w.x * other.x.w, this.x.y * other.x.x + this.y.y * other.x.y + this.z.y * other.x.z + this.w.y * other.x.w, this.x.z * other.x.x + this.y.z * other.x.y + this.z.z * other.x.z + this.w.z * other.x.w, this.x.w * other.x.x + this.y.w * other.x.y + this.z.w * other.x.z + this.w.w * other.x.w);
        this.y.set(this.x.x * other.y.x + this.y.x * other.y.y + this.z.x * other.y.z + this.w.x * other.y.w, this.x.y * other.y.x + this.y.y * other.y.y + this.z.y * other.y.z + this.w.y * other.y.w, this.x.z * other.y.x + this.y.z * other.y.y + this.z.z * other.y.z + this.w.z * other.y.w, this.x.w * other.y.x + this.y.w * other.y.y + this.z.w * other.y.z + this.w.w * other.y.w);
        this.z.set(this.x.x * other.z.x + this.y.x * other.z.y + this.z.x * other.z.z + this.w.x * other.z.w, this.x.y * other.z.x + this.y.y * other.z.y + this.z.y * other.z.z + this.w.y * other.z.w, this.x.z * other.z.x + this.y.z * other.z.y + this.z.z * other.z.z + this.w.z * other.z.w, this.x.w * other.z.x + this.y.w * other.z.y + this.z.w * other.z.z + this.w.w * other.z.w);
        this.w.set(this.x.x * other.w.x + this.y.x * other.w.y + this.z.x * other.w.z + this.w.x * other.w.w, this.x.y * other.w.x + this.y.y * other.w.y + this.z.y * other.w.z + this.w.y * other.w.w, this.x.z * other.w.x + this.y.z * other.w.y + this.z.z * other.w.z + this.w.z * other.w.w, this.x.w * other.w.x + this.y.w * other.w.y + this.z.w * other.w.z + this.w.w * other.w.w);
        return this;
    }

    @NotNull
    public Vector4 transform(@NotNull Vector4 vec) {
        return this.x.mult(vec.x).addInPlace(this.y.mult(vec.y)).addInPlace(this.z.mult(vec.z)).addInPlace(this.w.mult(vec.w));
    }

    @NotNull
    public Vector3 transform(@NotNull Vector3 vec) {
        return this.transform(vec.extend(1.0)).truncate();
    }

    public double @NotNull [] asArray() {
        return new double[]{this.x.x, this.x.y, this.x.z, this.x.w, this.y.x, this.y.y, this.y.z, this.y.w, this.z.x, this.z.y, this.z.z, this.z.w, this.w.x, this.w.y, this.w.z, this.w.w};
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Matrix4 matrix4 = (Matrix4)object;
        return Objects.equals(this.x, matrix4.x) && Objects.equals(this.y, matrix4.y) && Objects.equals(this.z, matrix4.z) && Objects.equals(this.w, matrix4.w);
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z, this.w);
    }

    public String toString() {
        return "[ " + String.valueOf(this.x) + ", " + String.valueOf(this.y) + ", " + String.valueOf(this.z) + ", " + String.valueOf(this.w) + " ]";
    }
}

