/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.hud.component;

import java.awt.Color;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.hud.HudIngame;
import net.minecraft.client.gui.hud.component.HudComponentMovable;
import net.minecraft.client.gui.hud.component.layout.Layout;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class HudComponentHeldItemCount
extends HudComponentMovable {
    private static final ItemStack PREVIEW_ITEM = new ItemStack(Blocks.COBBLE_BASALT, 53);

    public HudComponentHeldItemCount(String key, Layout layout) {
        super(key, 53, 22, layout);
    }

    @Override
    public boolean isVisible() {
        return HudComponentHeldItemCount.mc.gameSettings.immersiveMode.drawOverlays() && (Boolean)HudComponentHeldItemCount.mc.gameSettings.heldItemCountOverlay.value != false;
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)HudComponentHeldItemCount.mc.gameSettings.heldItemCountOverlay.value;
    }

    @Override
    public void render(HudIngame hud, int xSizeScreen, int ySizeScreen, float partialTick) {
        int x = this.getLayout().getComponentX(this, xSizeScreen);
        int y = this.getLayout().getComponentY(this, ySizeScreen);
        int xx = x + 3;
        int yy = y + 3;
        ItemStack heldItemStack = HudComponentHeldItemCount.mc.thePlayer.inventory.getCurrentItem();
        if (heldItemStack != null) {
            boolean renderItem;
            if (heldItemStack.isItemStackDamageable()) {
                renderItem = true;
                float durability = (float)(heldItemStack.getMaxDamage() - heldItemStack.getMetadata()) / (float)heldItemStack.getMaxDamage();
                int color = -16777216 + Color.HSBtoRGB(durability / 3.0f, 1.0f, 1.0f);
                int remainingDurability = heldItemStack.getMaxDamage() - heldItemStack.getMetadata() + 1;
                HudComponentHeldItemCount.mc.font.render(Tessellator.instance, remainingDurability, xx + 18, yy + 4).setShadow().setColor(color).call();
            } else {
                int itemCount = 0;
                int stackCount = 0;
                for (int i = 0; i < HudComponentHeldItemCount.mc.thePlayer.inventory.getContainerSize(); ++i) {
                    ItemStack itemStack = HudComponentHeldItemCount.mc.thePlayer.inventory.getItem(i);
                    if (itemStack == null || itemStack.itemID != heldItemStack.itemID || itemStack.getMetadata() != heldItemStack.getMetadata()) continue;
                    itemCount += itemStack.stackSize;
                    ++stackCount;
                }
                boolean bl = renderItem = stackCount >= 1;
                if (renderItem) {
                    HudComponentHeldItemCount.mc.font.render(Tessellator.instance, itemCount, xx + 18, yy + 4).setShadow().setColor(-1).call();
                }
            }
            if (renderItem) {
                GL11.glEnable(2929);
                GL11.glDisable(3042);
                GL11.glEnable(32826);
                Lighting.enableInventoryLight();
                ItemModelDispatcher.getInstance().getDispatch(heldItemStack).renderGui(Tessellator.instance, null, heldItemStack, xx, yy, 1.0f, 1.0f, partialTick);
                Lighting.disable();
            }
        }
    }

    @Override
    public void renderPreview(Gui gui, Layout layout, int xSizeScreen, int ySizeScreen) {
        int x = this.getLayout().getComponentX(this, xSizeScreen);
        int y = this.getLayout().getComponentY(this, ySizeScreen);
        int xx = x + 3;
        int yy = y + 3;
        ItemStack heldItemStack = PREVIEW_ITEM;
        int itemCount = heldItemStack.stackSize;
        HudComponentHeldItemCount.mc.font.render(Tessellator.instance, itemCount, xx + 18, yy + 4).setShadow().setColor(-1).call();
        GL11.glEnable(2929);
        GL11.glDisable(3042);
        GL11.glEnable(32826);
        Lighting.enableInventoryLight();
        ItemModelDispatcher.getInstance().getDispatch(heldItemStack).renderGui(Tessellator.instance, null, heldItemStack, xx, yy, 1.0f, 1.0f, 0.0f);
        Lighting.disable();
    }
}

