/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.data.registry.recipe;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.WeightedRandomBag;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.Registry;
import net.minecraft.core.data.registry.recipe.HasJsonAdapter;
import net.minecraft.core.data.registry.recipe.RecipeBranch;
import net.minecraft.core.data.registry.recipe.RecipeEntryBase;
import net.minecraft.core.data.registry.recipe.RecipeGroup;
import net.minecraft.core.data.registry.recipe.RecipeNamespace;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryBlastFurnace;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCrafting;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCraftingShaped;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCraftingShapeless;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryFurnace;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryLabel;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryLabelDye;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryMapDuplication;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryTrommel;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.ContainerCrafting;

public class RecipeRegistry
extends Registry<RecipeNamespace> {
    public final RecipeNamespace MINECRAFT = new RecipeNamespace();
    public final RecipeGroup<RecipeEntryCrafting<?, ?>> WORKBENCH = new RecipeGroup(new RecipeSymbol(new ItemStack(Blocks.WORKBENCH)));
    public final RecipeGroup<RecipeEntryFurnace> FURNACE = new RecipeGroup(new RecipeSymbol(new ItemStack(Blocks.FURNACE_STONE_ACTIVE)));
    public final RecipeGroup<RecipeEntryBlastFurnace> BLAST_FURNACE = new RecipeGroup(new RecipeSymbol(new ItemStack(Blocks.FURNACE_BLAST_ACTIVE)));
    public final RecipeGroup<RecipeEntryTrommel> TROMMEL = new RecipeGroup(new RecipeSymbol(new ItemStack(Blocks.TROMMEL_ACTIVE)));
    private ArrayList<RecipeEntryCrafting<?, ?>> recipeCache = null;

    public RecipeRegistry() {
        if (Registries.RECIPES == null) {
            Registries.RECIPES = this;
        }
        this.MINECRAFT.register("workbench", this.WORKBENCH);
        this.MINECRAFT.register("furnace", this.FURNACE);
        this.MINECRAFT.register("blast_furnace", this.BLAST_FURNACE);
        this.MINECRAFT.register("trommel", this.TROMMEL);
        this.register("minecraft", this.MINECRAFT);
        this.addProceduralRecipes();
    }

    public void addProceduralRecipes() {
        this.WORKBENCH.register("label", new RecipeEntryLabel());
        this.WORKBENCH.register("label_dye", new RecipeEntryLabelDye());
        this.addCustomRecipe("minecraft:workbench/map_duplication", new RecipeEntryMapDuplication());
    }

    @Override
    public void register(String key, RecipeNamespace item) {
        if (key.contains(":") || key.contains("/")) {
            throw new IllegalArgumentException("Keys cannot contain ':' or '/'!");
        }
        super.register(key, item);
    }

    public List<RecipeEntryBase<?, ?, ?>> getAllRecipes() {
        ArrayList<RecipeEntryBase> recipes = new ArrayList<RecipeEntryBase>();
        for (RecipeNamespace recipeNamespace : this) {
            for (RecipeGroup recipeGroup : recipeNamespace) {
                for (RecipeEntryBase recipeEntry : recipeGroup) {
                    recipes.add(recipeEntry);
                }
            }
        }
        return Collections.unmodifiableList(recipes);
    }

    public List<RecipeEntryBase<?, ?, ?>> getAllSerializableRecipes() {
        ArrayList<RecipeEntryBase> recipes = new ArrayList<RecipeEntryBase>();
        for (RecipeNamespace recipeNamespace : this) {
            for (RecipeGroup recipeGroup : recipeNamespace) {
                for (RecipeEntryBase recipeEntry : recipeGroup) {
                    if (!(recipeEntry instanceof HasJsonAdapter)) continue;
                    recipes.add(recipeEntry);
                }
            }
        }
        return Collections.unmodifiableList(recipes);
    }

    public List<RecipeGroup<?>> getAllGroups() {
        ArrayList<RecipeGroup> recipes = new ArrayList<RecipeGroup>();
        for (RecipeNamespace recipeNamespace : this) {
            for (RecipeGroup recipeGroup : recipeNamespace) {
                recipes.add(recipeGroup);
            }
        }
        return Collections.unmodifiableList(recipes);
    }

    public List<RecipeEntryCrafting<?, ?>> getAllCraftingRecipes() {
        if (this.recipeCache != null) {
            return Collections.unmodifiableList(this.recipeCache);
        }
        ArrayList<RecipeEntryCrafting> recipes = new ArrayList<RecipeEntryCrafting>();
        for (RecipeNamespace recipeNamespace : this) {
            for (RecipeGroup recipeGroup : recipeNamespace) {
                for (RecipeEntryBase recipeEntry : recipeGroup) {
                    if (!(recipeEntry instanceof RecipeEntryCrafting)) continue;
                    recipes.add((RecipeEntryCrafting)recipeEntry);
                }
            }
        }
        this.recipeCache = recipes;
        return Collections.unmodifiableList(recipes);
    }

    public void invalidateCaches() {
        this.recipeCache = null;
    }

    public List<RecipeEntryFurnace> getAllFurnaceRecipes() {
        ArrayList<RecipeEntryFurnace> recipes = new ArrayList<RecipeEntryFurnace>();
        for (RecipeNamespace recipeNamespace : this) {
            for (RecipeGroup recipeGroup : recipeNamespace) {
                for (RecipeEntryBase recipeEntry : recipeGroup) {
                    if (!(recipeEntry instanceof RecipeEntryFurnace)) continue;
                    recipes.add((RecipeEntryFurnace)recipeEntry);
                }
            }
        }
        return Collections.unmodifiableList(recipes);
    }

    public List<RecipeEntryBlastFurnace> getAllBlastFurnaceRecipes() {
        ArrayList<RecipeEntryBlastFurnace> recipes = new ArrayList<RecipeEntryBlastFurnace>();
        for (RecipeNamespace recipeNamespace : this) {
            for (RecipeGroup recipeGroup : recipeNamespace) {
                for (RecipeEntryBase recipeEntry : recipeGroup) {
                    if (!(recipeEntry instanceof RecipeEntryBlastFurnace)) continue;
                    recipes.add((RecipeEntryBlastFurnace)recipeEntry);
                }
            }
        }
        return Collections.unmodifiableList(recipes);
    }

    public List<RecipeEntryTrommel> getAllTrommelRecipes() {
        ArrayList<RecipeEntryTrommel> recipes = new ArrayList<RecipeEntryTrommel>();
        for (RecipeNamespace recipeNamespace : this) {
            for (RecipeGroup recipeGroup : recipeNamespace) {
                for (RecipeEntryBase recipeEntry : recipeGroup) {
                    if (!(recipeEntry instanceof RecipeEntryTrommel)) continue;
                    recipes.add((RecipeEntryTrommel)recipeEntry);
                }
            }
        }
        return Collections.unmodifiableList(recipes);
    }

    public ItemStack findMatchingRecipe(ContainerCrafting inventorycrafting) {
        for (int i = 0; i < this.getAllCraftingRecipes().size(); ++i) {
            RecipeEntryCrafting<?, ?> recipe = this.getAllCraftingRecipes().get(i);
            if (!recipe.matches(inventorycrafting)) continue;
            return recipe.getCraftingResult(inventorycrafting);
        }
        return null;
    }

    public ItemStack[] onCraftResult(ContainerCrafting inventorycrafting) {
        for (int i = 0; i < this.getAllCraftingRecipes().size(); ++i) {
            RecipeEntryCrafting<?, ?> recipe = this.getAllCraftingRecipes().get(i);
            if (!recipe.matches(inventorycrafting)) continue;
            return recipe.onCraftResult(inventorycrafting);
        }
        return null;
    }

    public void addRecipe(String recipeKey, ItemStack itemstack, boolean consumeContainerItem, Object ... aobj) {
        this.invalidateCaches();
        StringBuilder s = new StringBuilder();
        int i = 0;
        int j = 0;
        int k = 0;
        if (aobj[i] instanceof String[]) {
            String[] as;
            for (String s2 : as = (String[])aobj[i++]) {
                ++k;
                j = s2.length();
                s.append(s2);
            }
        } else {
            while (aobj[i] instanceof String) {
                String s1 = (String)aobj[i++];
                ++k;
                j = s1.length();
                s = new StringBuilder(String.valueOf(s) + s1);
            }
        }
        HashMap<Character, RecipeSymbol> map = new HashMap<Character, RecipeSymbol>();
        while (i < aobj.length) {
            Character character = (Character)aobj[i];
            RecipeSymbol recipeSymbol = null;
            if (aobj[i + 1] instanceof Item) {
                recipeSymbol = new RecipeSymbol(character.charValue(), new ItemStack((Item)aobj[i + 1]), null);
            } else if (aobj[i + 1] instanceof Block) {
                recipeSymbol = new RecipeSymbol(character.charValue(), new ItemStack((Block)aobj[i + 1]), null);
            } else if (aobj[i + 1] instanceof ItemStack) {
                recipeSymbol = new RecipeSymbol(character.charValue(), (ItemStack)aobj[i + 1], null);
            }
            if (aobj[i + 1] instanceof String) {
                recipeSymbol = new RecipeSymbol(character.charValue(), null, (String)aobj[i + 1]);
            }
            if (aobj[i + 1] instanceof RecipeSymbol) {
                recipeSymbol = (RecipeSymbol)aobj[i + 1];
            }
            map.put(character, recipeSymbol);
            i += 2;
        }
        RecipeSymbol[] symbols = new RecipeSymbol[j * k];
        for (int i1 = 0; i1 < j * k; ++i1) {
            char c = s.charAt(i1);
            symbols[i1] = map.containsKey(Character.valueOf(c)) ? ((RecipeSymbol)map.get(Character.valueOf(c))).copy() : null;
        }
        RecipeEntryCraftingShaped recipe = new RecipeEntryCraftingShaped(j, k, symbols, itemstack, consumeContainerItem);
        RecipeGroup<RecipeEntryCraftingShaped> group = this.getGroupFromKey(recipeKey);
        String key = this.deconstructKey(recipeKey)[2];
        group.register(key, recipe);
    }

    public static RecipeEntryCraftingShaped parseRecipe(ItemStack itemstack, boolean consumeContainerItem, boolean allowMirror, Object ... aobj) {
        StringBuilder s = new StringBuilder();
        int i = 0;
        int w = 0;
        int h = 0;
        if (aobj[i] instanceof String[]) {
            String[] as;
            for (String s2 : as = (String[])aobj[i++]) {
                ++h;
                w = s2.length();
                s.append(s2);
            }
        } else {
            while (aobj[i] instanceof String) {
                String s1 = (String)aobj[i++];
                ++h;
                w = s1.length();
                s = new StringBuilder(String.valueOf(s) + s1);
            }
        }
        HashMap<Character, RecipeSymbol> map = new HashMap<Character, RecipeSymbol>();
        while (i < aobj.length) {
            Character character = (Character)aobj[i];
            RecipeSymbol recipeSymbol = null;
            if (aobj[i + 1] instanceof Item) {
                recipeSymbol = new RecipeSymbol(character.charValue(), new ItemStack((Item)aobj[i + 1]), null);
            } else if (aobj[i + 1] instanceof Block) {
                recipeSymbol = new RecipeSymbol(character.charValue(), new ItemStack((Block)aobj[i + 1]), null);
            } else if (aobj[i + 1] instanceof ItemStack) {
                recipeSymbol = new RecipeSymbol(character.charValue(), (ItemStack)aobj[i + 1], null);
            }
            if (aobj[i + 1] instanceof String) {
                recipeSymbol = new RecipeSymbol(character.charValue(), null, (String)aobj[i + 1]);
            }
            if (aobj[i + 1] instanceof RecipeSymbol) {
                recipeSymbol = (RecipeSymbol)aobj[i + 1];
            }
            map.put(character, recipeSymbol);
            i += 2;
        }
        RecipeSymbol[] symbols = new RecipeSymbol[w * h];
        for (int i1 = 0; i1 < w * h; ++i1) {
            char c = s.charAt(i1);
            symbols[i1] = map.containsKey(Character.valueOf(c)) ? ((RecipeSymbol)map.get(Character.valueOf(c))).copy() : null;
        }
        return new RecipeEntryCraftingShaped(w, h, symbols, itemstack, consumeContainerItem, allowMirror);
    }

    public static RecipeEntryCraftingShaped parseRecipe(List<String> pattern, List<RecipeSymbol> symbols, ItemStack result, boolean consumeContainerItem, boolean allowMirror) {
        HashSet<Character> chars = new HashSet<Character>();
        for (String s : pattern) {
            char[] chars1 = s.toCharArray();
            for (char c : chars1) {
                chars.add(Character.valueOf(c));
            }
        }
        ArrayList<Object> objs = new ArrayList<Object>();
        block2: for (Character c : chars) {
            Object object = symbols.iterator();
            while (object.hasNext()) {
                RecipeSymbol symbol = (RecipeSymbol)object.next();
                if (symbol.getSymbol() != c.charValue()) continue;
                objs.add(c);
                objs.add(symbol);
                continue block2;
            }
        }
        objs.add(0, pattern.toArray(new String[0]));
        return RecipeRegistry.parseRecipe(result, consumeContainerItem, allowMirror, objs.toArray());
    }

    public void addShapelessRecipe(String recipeKey, ItemStack result, Object ... ingredients) {
        this.invalidateCaches();
        ArrayList<RecipeSymbol> list = new ArrayList<RecipeSymbol>();
        for (int i = 0; i < ingredients.length; ++i) {
            Object obj = ingredients[i];
            if (obj instanceof ItemStack) {
                list.add(new RecipeSymbol('\u0000', (ItemStack)obj, null));
                continue;
            }
            if (obj instanceof Item) {
                list.add(new RecipeSymbol('\u0000', new ItemStack((Item)obj), null));
                continue;
            }
            if (obj instanceof Block) {
                list.add(new RecipeSymbol('\u0000', new ItemStack((Block)obj), null));
                continue;
            }
            if (obj instanceof String) {
                list.add(new RecipeSymbol('\u0000', null, (String)obj));
                continue;
            }
            throw new RuntimeException("Invalid object " + String.valueOf(obj) + " at index " + i);
        }
        RecipeEntryCraftingShapeless recipe = new RecipeEntryCraftingShapeless((List<RecipeSymbol>)list, result);
        RecipeGroup<RecipeEntryCraftingShapeless> group = this.getGroupFromKey(recipeKey);
        String key = this.deconstructKey(recipeKey)[2];
        group.register(key, recipe);
    }

    public void addFurnaceRecipe(String recipeKey, ItemStack result, Object input) {
        RecipeSymbol symbol;
        this.invalidateCaches();
        if (input instanceof ItemStack) {
            symbol = new RecipeSymbol('\u0000', (ItemStack)input, null);
        } else if (input instanceof Item) {
            symbol = new RecipeSymbol('\u0000', new ItemStack((Item)input), null);
        } else if (input instanceof Block) {
            symbol = new RecipeSymbol('\u0000', new ItemStack((Block)input), null);
        } else if (input instanceof String) {
            symbol = new RecipeSymbol('\u0000', null, (String)input);
        } else {
            throw new RuntimeException("Invalid object " + String.valueOf(input) + "!");
        }
        RecipeEntryFurnace recipe = new RecipeEntryFurnace(symbol, result);
        RecipeGroup<RecipeEntryFurnace> group = this.getGroupFromKey(recipeKey);
        String key = this.deconstructKey(recipeKey)[2];
        group.register(key, recipe);
    }

    public void addBlastFurnaceRecipe(String recipeKey, ItemStack result, Object inputA, Object inputB) {
        RecipeSymbol symbolA;
        this.invalidateCaches();
        if (inputA instanceof ItemStack) {
            symbolA = new RecipeSymbol('\u0000', (ItemStack)inputA, null);
        } else if (inputA instanceof Item) {
            symbolA = new RecipeSymbol('\u0000', new ItemStack((Item)inputA), null);
        } else if (inputA instanceof Block) {
            symbolA = new RecipeSymbol('\u0000', new ItemStack((Block)inputA), null);
        } else if (inputA instanceof String) {
            symbolA = new RecipeSymbol('\u0000', null, (String)inputA);
        } else {
            throw new RuntimeException("Invalid object " + String.valueOf(inputA) + "!");
        }
        RecipeSymbol symbolB = null;
        if (inputB != null) {
            if (inputB instanceof ItemStack) {
                symbolB = new RecipeSymbol('\u0000', (ItemStack)inputB, null);
            } else if (inputB instanceof Item) {
                symbolB = new RecipeSymbol('\u0000', new ItemStack((Item)inputB), null);
            } else if (inputB instanceof Block) {
                symbolB = new RecipeSymbol('\u0000', new ItemStack((Block)inputB), null);
            } else if (inputB instanceof String) {
                symbolB = new RecipeSymbol('\u0000', null, (String)inputB);
            } else {
                throw new RuntimeException("Invalid object " + String.valueOf(inputB) + "!");
            }
        }
        RecipeEntryBlastFurnace recipe = new RecipeEntryBlastFurnace(new RecipeSymbol[]{symbolA, symbolB}, result);
        RecipeGroup<RecipeEntryBlastFurnace> group = this.getGroupFromKey(recipeKey);
        String key = this.deconstructKey(recipeKey)[2];
        group.register(key, recipe);
    }

    public void addTrommelRecipe(String recipeKey, WeightedRandomBag<WeightedRandomLootObject> result, Object input) {
        RecipeSymbol symbol;
        this.invalidateCaches();
        if (input instanceof ItemStack) {
            symbol = new RecipeSymbol('\u0000', (ItemStack)input, null);
        } else if (input instanceof Item) {
            symbol = new RecipeSymbol('\u0000', new ItemStack((Item)input), null);
        } else if (input instanceof Block) {
            symbol = new RecipeSymbol('\u0000', new ItemStack((Block)input), null);
        } else if (input instanceof String) {
            symbol = new RecipeSymbol('\u0000', null, (String)input);
        } else {
            throw new RuntimeException("Invalid object " + String.valueOf(input) + "!");
        }
        RecipeEntryTrommel recipe = new RecipeEntryTrommel(symbol, result);
        RecipeGroup<RecipeEntryTrommel> group = this.getGroupFromKey(recipeKey);
        String key = this.deconstructKey(recipeKey)[2];
        group.register(key, recipe);
    }

    public void addCustomRecipe(String recipeKey, RecipeEntryBase<?, ?, ?> recipe) {
        this.invalidateCaches();
        RecipeGroup<RecipeEntryBase<?, ?, ?>> group = this.getGroupFromKey(recipeKey);
        String key = this.deconstructKey(recipeKey)[2];
        group.register(key, recipe);
    }

    public <T extends RecipeEntryBase<?, ?, ?>> RecipeBranch<T> getRecipeFromKey(String key) {
        if (!key.contains(":") || !key.contains("/")) {
            throw new IllegalArgumentException("Invalid or malformed key!");
        }
        String[] keys = this.deconstructKey(key);
        String namespaceKey = keys[0];
        String groupKey = keys[1];
        String recipeKey = keys[2];
        RecipeNamespace namespace = (RecipeNamespace)this.getItem(namespaceKey);
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Namespace '%s' doesn't exist!", namespaceKey));
        }
        RecipeGroup group = (RecipeGroup)namespace.getItem(groupKey);
        if (group == null) {
            throw new IllegalArgumentException(String.format("Group '%s' in namespace '%s' doesn't exist!", groupKey, namespaceKey));
        }
        RecipeEntryBase recipe = (RecipeEntryBase)group.getItem(recipeKey);
        if (recipe == null) {
            throw new IllegalArgumentException(String.format("Recipe '%s' in group '%s' in namespace '%s' doesn't exist!", recipeKey, groupKey, namespaceKey));
        }
        return new RecipeBranch<RecipeEntryBase>(namespace, group, recipe);
    }

    public String[] deconstructKey(String key) {
        String namespaceKey = key.split(":")[0];
        String groupKey = key.split(":")[1].split("/")[0];
        String recipeKey = "";
        if (key.contains("/")) {
            recipeKey = key.split(":")[1].split("/")[1];
        }
        return new String[]{namespaceKey, groupKey, recipeKey};
    }

    public <T extends RecipeEntryBase<?, ?, ?>> RecipeGroup<T> getGroupFromKey(String key) {
        String[] keys;
        if (!key.contains(":")) {
            throw new IllegalArgumentException("Invalid or malformed key!");
        }
        try {
            keys = this.deconstructKey(key);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid or malformed key!", e);
        }
        String namespaceKey = keys[0];
        String groupKey = keys[1];
        RecipeNamespace namespace = (RecipeNamespace)this.getItem(namespaceKey);
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Namespace '%s' doesn't exist!", namespaceKey));
        }
        RecipeGroup group = (RecipeGroup)namespace.getItem(groupKey);
        if (group == null) {
            throw new IllegalArgumentException(String.format("Group '%s' in namespace '%s' doesn't exist!", groupKey, namespaceKey));
        }
        return group;
    }
}

