/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.player.inventory.menu;

import it.unimi.dsi.fastutil.ints.IntList;
import net.minecraft.core.InventoryAction;
import net.minecraft.core.block.entity.TileEntityFurnaceBlast;
import net.minecraft.core.crafting.ContainerListener;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.player.inventory.menu.MenuAbstract;
import net.minecraft.core.player.inventory.slot.Slot;
import net.minecraft.core.player.inventory.slot.SlotFurnace;

public class MenuFurnaceBlast
extends MenuAbstract {
    public static final int ID_CURRENT_COOK_TIME = 0;
    public static final int ID_CURRENT_BURN_TIME = 1;
    public static final int ID_MAX_COOK_TIME = 2;
    public static final int ID_MAX_BURN_TIME = 3;
    public TileEntityFurnaceBlast furnace;
    private int currentCookTime = 0;
    private int currentBurnTime = 0;
    private int itemBurnTime = 0;
    private int itemCookTime = 0;

    public MenuFurnaceBlast(ContainerInventory inventory, TileEntityFurnaceBlast tileEntity) {
        this.furnace = tileEntity;
        this.addSlot(new Slot(tileEntity, 0, 46, 17));
        this.addSlot(new Slot(tileEntity, 1, 66, 17));
        this.addSlot(new Slot(tileEntity, 2, 56, 53));
        this.addSlot(new SlotFurnace(inventory.player, tileEntity, 3, 116, 35));
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot(inventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot(inventory, i, 8 + i * 18, 142));
        }
    }

    @Override
    public void broadcastChanges() {
        super.broadcastChanges();
        for (ContainerListener crafter : this.containerListeners) {
            if (this.currentCookTime != this.furnace.currentCookTime) {
                crafter.updateCraftingInventoryInfo(this, 0, this.furnace.currentCookTime);
            }
            if (this.currentBurnTime != this.furnace.currentBurnTime) {
                crafter.updateCraftingInventoryInfo(this, 1, this.furnace.currentBurnTime);
            }
            if (this.itemCookTime != this.furnace.maxCookTime) {
                crafter.updateCraftingInventoryInfo(this, 2, this.furnace.maxCookTime);
            }
            if (this.itemBurnTime == this.furnace.maxBurnTime) continue;
            crafter.updateCraftingInventoryInfo(this, 3, this.furnace.maxBurnTime);
        }
        this.currentCookTime = this.furnace.currentCookTime;
        this.currentBurnTime = this.furnace.currentBurnTime;
        this.itemCookTime = this.furnace.maxCookTime;
        this.itemBurnTime = this.furnace.maxBurnTime;
    }

    @Override
    public void setData(int id, int value) {
        switch (id) {
            case 0: {
                this.furnace.currentCookTime = value;
                break;
            }
            case 1: {
                this.furnace.currentBurnTime = value;
                break;
            }
            case 2: {
                this.furnace.maxCookTime = value;
                break;
            }
            case 3: {
                this.furnace.maxBurnTime = value;
            }
        }
    }

    @Override
    public boolean stillValid(Player entityplayer) {
        return this.furnace.stillValid(entityplayer);
    }

    @Override
    public IntList getMoveSlots(InventoryAction action, Slot slot, int target, Player player) {
        if (slot.index >= 0 && slot.index < 4) {
            return this.getSlots(slot.index, 1, false);
        }
        if (action == InventoryAction.MOVE_ALL) {
            if (slot.index >= 4 && slot.index < 31) {
                return this.getSlots(4, 27, false);
            }
            if (slot.index >= 31 && slot.index < 40) {
                return this.getSlots(31, 9, false);
            }
        }
        if (slot.index >= 4 && slot.index < 40) {
            return this.getSlots(4, 36, false);
        }
        return null;
    }

    @Override
    public IntList getTargetSlots(InventoryAction action, Slot slot, int target, Player player) {
        if (slot.index >= 4 && slot.index < 40) {
            if (action != InventoryAction.MOVE_ALL) {
                if (target == 1) {
                    return this.getSlots(0, 2, false);
                }
                if (target == 2) {
                    return this.getSlots(2, 1, false);
                }
            }
            if (slot.index >= 4 && slot.index < 31) {
                return this.getSlots(31, 9, false);
            }
            if (slot.index >= 31 && slot.index < 40) {
                return this.getSlots(3, 27, false);
            }
        }
        if (slot.index >= 0 && slot.index < 4) {
            if (slot.index == 3) {
                return this.getSlots(3, 36, true);
            }
            return this.getSlots(3, 36, false);
        }
        return null;
    }
}

