/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.pos;

import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.pos.ChunkTilePos;
import net.minecraft.core.world.pos.Pos2i;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;

public final class ChunkPos
implements Pos2i<ChunkPos> {
    public int x;
    public int z;

    public ChunkPos(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public ChunkPos(@NotNull TilePos tilePos) {
        this(Math.floorDiv(tilePos.x, 16), Math.floorDiv(tilePos.z, 16));
    }

    public ChunkPos(@NotNull ChunkPos chunkPos) {
        this(chunkPos.x, chunkPos.z);
    }

    public ChunkPos(@NotNull Entity entity) {
        this(MathHelper.floor(entity.x / 16.0), MathHelper.floor(entity.z / 16.0));
    }

    @Override
    public int x() {
        return this.x;
    }

    @Override
    public int z() {
        return this.z;
    }

    @Override
    @NotNull
    public ChunkPos add(int x, int z) {
        return new ChunkPos(this.x + x, this.z + z);
    }

    @NotNull
    public TilePos toTilePos(@NotNull ChunkTilePos chunkTilePos) {
        return new TilePos(this, chunkTilePos);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ChunkPos)) {
            return false;
        }
        @NotNull ChunkPos other = (ChunkPos)obj;
        return this.x == other.x && this.z == other.z;
    }

    public int hashCode() {
        return MathHelper.cantor(this.x, this.z);
    }
}

