/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.pos;

import net.minecraft.core.util.helper.Direction;
import org.jetbrains.annotations.NotNull;

public interface Pos2i<T extends Pos2i<T>> {
    public int x();

    public int z();

    @NotNull
    public T add(int var1, int var2);

    @NotNull
    default public T add(@NotNull T other) {
        return this.add(other.x(), other.z());
    }

    @NotNull
    default public T add(@NotNull Direction direction, int distance) {
        return this.add(direction.getOffsetX() * distance, direction.getOffsetZ() * distance);
    }

    @NotNull
    default public T add(@NotNull Direction direction) {
        return this.add(direction, 1);
    }

    @NotNull
    default public T north() {
        return this.add(Direction.NORTH);
    }

    @NotNull
    default public T east() {
        return this.add(Direction.EAST);
    }

    @NotNull
    default public T south() {
        return this.add(Direction.SOUTH);
    }

    @NotNull
    default public T west() {
        return this.add(Direction.WEST);
    }

    @NotNull
    default public T sub(int x, int z) {
        return this.add(-x, -z);
    }

    @NotNull
    default public T sub(@NotNull T other) {
        return this.sub(other.x(), other.z());
    }
}

