/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.player;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.nbt.tags.CompoundTag;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenLabelEditor;
import net.minecraft.client.gui.ScreenMobPicker;
import net.minecraft.client.gui.ScreenPaintingPicker;
import net.minecraft.client.gui.ScreenSignEditor;
import net.minecraft.client.gui.ScreenWandMobPicker;
import net.minecraft.client.gui.container.ScreenActivator;
import net.minecraft.client.gui.container.ScreenContainer;
import net.minecraft.client.gui.container.ScreenContainerAbstract;
import net.minecraft.client.gui.container.ScreenCrafting;
import net.minecraft.client.gui.container.ScreenDispenser;
import net.minecraft.client.gui.container.ScreenFlagEditor;
import net.minecraft.client.gui.container.ScreenFurnace;
import net.minecraft.client.gui.container.ScreenFurnaceBlast;
import net.minecraft.client.gui.container.ScreenTrommel;
import net.minecraft.client.gui.guidebook.ScreenGuidebook;
import net.minecraft.client.gui.nbteditor.ScreenNBTEditor;
import net.minecraft.client.gui.toasts.AchievementToast;
import net.minecraft.client.input.PlayerInput;
import net.minecraft.client.net.command.ClientCommandSource;
import net.minecraft.client.render.particle.ParticlePickupAnimation;
import net.minecraft.client.render.worldtype.WorldTypeFX;
import net.minecraft.client.render.worldtype.WorldTypeFXDispatcher;
import net.minecraft.core.achievement.Achievement;
import net.minecraft.core.achievement.Achievements;
import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.block.BlockLogicPortal;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.entity.TileEntityDispenser;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.block.entity.TileEntityFurnace;
import net.minecraft.core.block.entity.TileEntityFurnaceBlast;
import net.minecraft.core.block.entity.TileEntityMobSpawner;
import net.minecraft.core.block.entity.TileEntitySign;
import net.minecraft.core.block.entity.TileEntityTrommel;
import net.minecraft.core.data.gamerule.GameRules;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.vehicle.EntityBoat;
import net.minecraft.core.enums.PlacementMode;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.player.Session;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.player.inventory.menu.MenuInventory;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.GetSkinUrlThread;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class PlayerLocal
extends Player {
    private static final Logger LOGGER = LogUtils.getLogger();
    public PlayerInput input;
    protected Minecraft mc;
    protected int sprintTimer;

    public PlayerLocal(Minecraft minecraft, World world, Session session, int dimension) {
        super(world);
        this.mc = minecraft;
        this.dimension = dimension;
        this.username = session.username;
        this.uuid = session.uuid;
        this.playerConfig.setLeftHand((Boolean)minecraft.gameSettings.playerLeftHanded.value);
        this.playerConfig.setCape((Boolean)minecraft.gameSettings.playerCape.value);
        this.playerConfig.setHat((Boolean)minecraft.gameSettings.playerHat.value);
        this.playerConfig.setJacket((Boolean)minecraft.gameSettings.playerJacket.value);
        this.playerConfig.setSleeveLeft((Boolean)minecraft.gameSettings.playerSleeveLeft.value);
        this.playerConfig.setSleeveRight((Boolean)minecraft.gameSettings.playerSleeveRight.value);
        this.playerConfig.setPantLeft((Boolean)minecraft.gameSettings.playerPantLeft.value);
        this.playerConfig.setPantRight((Boolean)minecraft.gameSettings.playerPantRight.value);
        new GetSkinUrlThread(this);
        LOGGER.info("logged in with session name: {}", (Object)this.username);
    }

    public float getFovModifier() {
        float f = 1.0f;
        f *= (this.speed * 1.0f / this.baseSpeed + 1.0f) / 2.0f;
        return f *= this.heldObject == null ? 1.0f : 0.8f;
    }

    @Override
    public AABB getBb() {
        if (this.noPhysics) {
            return null;
        }
        return super.getBb();
    }

    @Override
    public void updateAI() {
        super.updateAI();
        this.moveStrafing = this.input.moveStrafe;
        this.moveForward = this.input.moveForward;
        this.isJumping = this.input.jump;
    }

    @Override
    public void setGamemode(Gamemode gamemode) {
        this.gamemode = gamemode;
        MenuInventory newContainer = gamemode.getContainer(this.inventory, !this.world.isClientSide);
        if (this.craftingInventory == this.inventorySlots) {
            this.craftingInventory = newContainer;
        }
        this.inventorySlots = newContainer;
        if (!gamemode.canPlayerFly()) {
            this.noPhysics = false;
        }
        this.fireImmune = gamemode.isImmuneToFire();
    }

    @Override
    public void onLivingUpdate() {
        boolean canSprint;
        float f;
        if (this.sprintTimer > 0) {
            --this.sprintTimer;
        }
        AchievementToast invToast = new AchievementToast(Achievements.OPEN_INVENTORY, true);
        AchievementToast guideToast = new AchievementToast(Achievements.OPEN_GUIDEBOOK, true);
        if (!this.mc.statsCounter.isUnlocked(Achievements.OPEN_INVENTORY) && !this.mc.guiToasts.isDisplayingToast(invToast)) {
            this.mc.guiToasts.addToast(invToast);
        }
        if (!this.mc.statsCounter.isUnlocked(Achievements.OPEN_GUIDEBOOK) && !this.mc.guiToasts.isDisplayingToast(guideToast)) {
            this.mc.guiToasts.addToast(guideToast);
        }
        this.prevTimeInPortal = this.timeInPortal;
        if (this.inPortal && !this.noPhysics) {
            if (!this.world.isClientSide && this.vehicle != null) {
                this.startRiding(null);
            }
            if (this.mc.currentScreen instanceof ScreenContainerAbstract) {
                this.mc.displayScreen(null);
            }
            if (this.timeInPortal == 0.0f) {
                this.mc.sndManager.playSound("portal.trigger", SoundCategory.WORLD_SOUNDS, 1.0f, this.random.nextFloat() * 0.4f + 0.8f);
            }
            this.timeInPortal += 0.0125f;
            if (this.timeInPortal >= 1.0f || this.getGamemode().instantPortalTravel()) {
                this.timeInPortal = 1.0f;
                if (!this.world.isClientSide) {
                    this.timeUntilPortal = 10;
                    this.mc.sndManager.playSound("portal.travel", SoundCategory.WORLD_SOUNDS, 1.0f, this.random.nextFloat() * 0.4f + 0.8f);
                    Dimension targetDim = ((BlockLogicPortal)Blocks.blocksList[this.portalID].getLogic()).targetDimension;
                    if (this.dimension == targetDim.id) {
                        this.mc.usePortal(0, this.portalColor);
                    } else {
                        this.mc.usePortal(targetDim.id, this.portalColor);
                    }
                }
            }
            this.inPortal = false;
        } else {
            if (this.timeInPortal > 0.0f) {
                this.timeInPortal -= 0.05f;
            }
            if (this.timeInPortal < 0.0f) {
                this.timeInPortal = 0.0f;
            }
        }
        if (this.timeUntilPortal > 0) {
            --this.timeUntilPortal;
        }
        boolean forwardInput = this.input.moveForward >= (f = 0.8f);
        this.input.tick(this);
        this.checkInTile(this.x - (double)this.bbWidth * 0.35, this.bb.minY + 0.5, this.z + (double)this.bbWidth * 0.35);
        this.checkInTile(this.x - (double)this.bbWidth * 0.35, this.bb.minY + 0.5, this.z - (double)this.bbWidth * 0.35);
        this.checkInTile(this.x + (double)this.bbWidth * 0.35, this.bb.minY + 0.5, this.z - (double)this.bbWidth * 0.35);
        this.checkInTile(this.x + (double)this.bbWidth * 0.35, this.bb.minY + 0.5, this.z + (double)this.bbWidth * 0.35);
        boolean bl = canSprint = this.world.getGameRuleValue(GameRules.ALLOW_SPRINTING) != false && !this.noPhysics;
        if (this.onGround && !forwardInput && this.input.moveForward >= f && !this.isSprinting() && canSprint) {
            if (this.sprintTimer == 0) {
                this.sprintTimer = 7;
            } else {
                this.setSprinting(true);
                this.sprintTimer = 0;
            }
        }
        if (this.onGround && canSprint && this.mc.gameSettings.keySprint.isPressed()) {
            this.setSprinting(true);
        }
        if (this.isSprinting() && (this.input.moveForward < f || this.horizontalCollision || !canSprint)) {
            this.setSprinting(false);
        }
        super.onLivingUpdate();
        ((WorldTypeFX)WorldTypeFXDispatcher.getInstance().getDispatch(this.world.getWorldType())).playerAnimationTick(this.world, this);
    }

    @Override
    public void wakeUpPlayer(boolean flag, boolean flag1) {
        super.wakeUpPlayer(flag, flag1);
        this.mc.displayScreen(null);
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("Score", this.score);
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.score = tag.getInteger("Score");
    }

    @Override
    public void closeScreen() {
        super.closeScreen();
        this.mc.displayScreen(null);
    }

    @Override
    public void displaySignEditorScreen(TileEntitySign tileEntity) {
        this.mc.displayScreen(new ScreenSignEditor(tileEntity));
    }

    @Override
    public void displayFlagEditorScreen(TileEntityFlag tileEntity) {
        this.mc.displayScreen(new ScreenFlagEditor(this, tileEntity));
    }

    @Override
    public void displayContainerScreen(Container container) {
        this.mc.displayScreen(new ScreenContainer(this.inventory, container));
    }

    @Override
    public void displayChestScreen(Container container, double x, double y, double z) {
        this.displayContainerScreen(container);
    }

    @Override
    public void displayNBTEditor(@Nullable CompoundTag tag, @Nullable Function<@NotNull CompoundTag, Void> exitAction) {
        this.mc.displayScreen(new ScreenNBTEditor("NBT Viewer", tag, exitAction));
    }

    @Override
    public void displayWorkbenchScreen(@NotNull TilePos tilePos) {
        this.mc.displayScreen(new ScreenCrafting(this.inventory, this.world, tilePos));
    }

    @Override
    public void displayLabelEditorScreen(ItemStack itemStack, int slot) {
        this.mc.displayScreen(new ScreenLabelEditor(itemStack, slot));
    }

    @Override
    public void displayPaintingPickerScreen() {
        this.mc.displayScreen(new ScreenPaintingPicker(this));
    }

    @Override
    public void displayMobPickerScreen(@NotNull TilePos tilePos) {
        String currentMobId = ((TileEntityMobSpawner)this.world.getTileEntity(tilePos)).getMobId();
        this.mc.displayScreen(new ScreenMobPicker(currentMobId, tilePos));
    }

    @Override
    public void displayWandMobPickerScreen(ItemStack itemStack) {
        String currentMobId = itemStack.getData().getStringOrDefault("monster", "Pig");
        this.mc.displayScreen(new ScreenWandMobPicker(currentMobId, itemStack));
    }

    @Override
    public void displayFurnaceScreen(TileEntityFurnace tileEntity) {
        this.mc.displayScreen(new ScreenFurnace(this.inventory, tileEntity));
    }

    @Override
    public void displayBlastFurnaceScreen(TileEntityFurnaceBlast tileEntity) {
        this.mc.displayScreen(new ScreenFurnaceBlast(this.inventory, tileEntity));
    }

    @Override
    public void displayTrommelScreen(TileEntityTrommel tileEntity) {
        this.mc.displayScreen(new ScreenTrommel(this.inventory, tileEntity));
    }

    @Override
    public void displayDispenserScreen(TileEntityDispenser tileEntity) {
        this.mc.displayScreen(new ScreenDispenser(this.inventory, tileEntity));
    }

    @Override
    public void displayActivatorScreen(TileEntityActivator tileEntity) {
        this.mc.displayScreen(new ScreenActivator(this.inventory, tileEntity));
    }

    @Override
    public void displayGuidebookScreen() {
        this.mc.displayScreen(new ScreenGuidebook(this.mc.currentScreen));
    }

    @Override
    public void onItemPickup(Entity entity, ItemStack item) {
        this.addStat(item.getItem().getStat("stat_picked_up"), 1);
        this.mc.particleEngine.add(new ParticlePickupAnimation(this.mc.currentWorld, entity, this, -0.5f));
    }

    public int getPlayerProtectionAmount() {
        return this.inventory.getTotalArmourPoints();
    }

    public void sendChatMessage(String s) {
        this.addToSendHistory(s);
        if (s.startsWith("/")) {
            String command = s.substring(1);
            ClientCommandSource clientCommandSource = new ClientCommandSource(this.mc);
            try {
                this.world.getCommandManager().execute(command, clientCommandSource);
            }
            catch (CommandSyntaxException e) {
                this.mc.thePlayer.sendMessage(String.valueOf(TextFormatting.RED) + e.getMessage());
            }
        } else {
            this.mc.hudIngame.addChatMessage("<" + this.getDisplayName() + String.valueOf(TextFormatting.RESET) + "> " + String.valueOf(TextFormatting.WHITE) + s);
        }
    }

    public void addToSendHistory(String msg) {
        if (msg == null || msg.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.messageHistory.size(); ++i) {
            if (!((String)this.messageHistory.get(i)).equals(msg)) continue;
            this.messageHistory.remove(i--);
        }
        this.messageHistory.add(msg);
        if (this.messageHistory.size() > 100) {
            this.messageHistory.remove(0);
        }
    }

    @Override
    public boolean wantSneak() {
        return this.input != null && this.input.sneak && !this.sleeping;
    }

    public void setHealth(int i) {
        int j = this.getHealth() - i;
        if (j <= 0) {
            this.setHealthRaw(i);
            if (j < 0) {
                this.heartsFlashTime = this.heartsHalvesLife / 2;
            }
        } else {
            this.lastDamage = j;
            this.prevHealth = this.getHealth();
            this.heartsFlashTime = this.heartsHalvesLife;
            this.damageEntity(j, null);
            this.maxHurtTime = 10;
            this.hurtTime = 10;
        }
    }

    @Override
    public void respawnPlayer() {
        this.mc.respawn(false, 0);
    }

    @Override
    public void animate4() {
    }

    @Override
    public void addStat(Stat stat, int i) {
        if (stat == null) {
            return;
        }
        if (stat.isAchievement()) {
            Achievement achievement = (Achievement)stat;
            if (achievement.parent == null || this.mc.statsCounter.isUnlocked(achievement.parent)) {
                if (!this.mc.statsCounter.isUnlocked(achievement)) {
                    this.mc.guiToasts.addToast(new AchievementToast(achievement, false));
                }
                this.mc.statsCounter.add(stat, i);
            }
        } else {
            this.mc.statsCounter.add(stat, i);
        }
    }

    @Override
    public int getStat(Stat stat) {
        return this.mc.statsCounter.readStat(stat);
    }

    @Override
    protected boolean checkInTile(double x, double y, double z) {
        if (this.noPhysics) {
            return false;
        }
        boolean isShort = this.isDwarf || this.isSneaking();
        int blockX = MathHelper.floor(x);
        int blockY = MathHelper.floor(y);
        int blockZ = MathHelper.floor(z);
        double dX = x - (double)blockX;
        double dZ = z - (double)blockZ;
        if (this.doesBlockPushOut(blockX, blockY, blockZ) || this.doesBlockPushOut(blockX, blockY + 1, blockZ) && !isShort) {
            boolean flagWest = !this.doesBlockPushOut(blockX - 1, blockY, blockZ) && (isShort || !this.doesBlockPushOut(blockX - 1, blockY + 1, blockZ));
            boolean flagEast = !this.doesBlockPushOut(blockX + 1, blockY, blockZ) && (isShort || !this.doesBlockPushOut(blockX + 1, blockY + 1, blockZ));
            boolean flagNorth = !this.doesBlockPushOut(blockX, blockY, blockZ - 1) && (isShort || !this.doesBlockPushOut(blockX, blockY + 1, blockZ - 1));
            boolean flagSouth = !this.doesBlockPushOut(blockX, blockY, blockZ + 1) && (isShort || !this.doesBlockPushOut(blockX, blockY + 1, blockZ + 1));
            Direction pushDirection = Direction.NONE;
            double minLength = Double.MAX_VALUE;
            if (flagWest && dX < minLength) {
                minLength = dX;
                pushDirection = Direction.WEST;
            }
            if (flagEast && 1.0 - dX < minLength) {
                minLength = 1.0 - dX;
                pushDirection = Direction.EAST;
            }
            if (flagNorth && dZ < minLength) {
                minLength = dZ;
                pushDirection = Direction.NORTH;
            }
            if (flagSouth && 1.0 - dZ < minLength) {
                pushDirection = Direction.SOUTH;
            }
            float pushStrength = 0.1f;
            this.xd = (float)pushDirection.getOffsetX() * 0.1f;
            this.zd = (float)pushDirection.getOffsetZ() * 0.1f;
            return true;
        }
        return false;
    }

    public void syncPlacementMode() {
        this.placementModeOverride = (PlacementMode)this.mc.gameSettings.placementMode.value;
    }

    @Override
    public void sendMessage(String message) {
        this.mc.hudIngame.addChatMessage(message);
    }

    @Override
    public void sendStatusMessage(String message) {
        this.mc.hudIngame.heldItemTooltipElement.setString(message);
    }

    @Override
    public boolean lerpVehicleMotion() {
        return false;
    }

    @Override
    public void handleSpecialVehicleControl() {
        if (this.vehicle instanceof EntityBoat) {
            ((EntityBoat)this.vehicle).controlBoat(-this.input.moveForward, -this.input.moveStrafe);
        }
    }
}

