/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.container;

import net.minecraft.client.gui.container.ScreenContainerAbstract;
import net.minecraft.client.input.controller.ControllerInput;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.player.inventory.menu.MenuCrafting;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

public class ScreenCrafting
extends ScreenContainerAbstract {
    public ScreenCrafting(@NotNull ContainerInventory inventory, @NotNull World world, @NotNull TilePos tilePos) {
        super(new MenuCrafting(inventory, world, tilePos));
    }

    @Override
    public void removed() {
        super.removed();
        this.inventorySlots.onCraftGuiClosed(this.mc.thePlayer);
    }

    @Override
    protected void drawGuiContainerForegroundLayer() {
        this.drawStringNoShadow(this.fontRenderer, I18n.getInstance().translateKey("gui.crafting.label.crafting"), 28, 6, 0x404040);
        this.drawStringNoShadow(this.fontRenderer, I18n.getInstance().translateKey("gui.crafting.label.inventory"), 8, this.ySize - 96 + 2, 0x404040);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f) {
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/container/crafting.png").bind();
        int j = (this.width - this.xSize) / 2;
        int k = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(j, k, 0, 0, this.xSize, this.ySize);
    }

    @Override
    public void guiSpecificControllerInput(@NotNull ControllerInput controller) {
        super.guiSpecificControllerInput(controller);
        controller.inventoryHandler.handleCrafting(this);
    }
}

