/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.hud.component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.console.LogMessage;
import net.minecraft.client.console.LogMessageReceiver;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.hud.HudIngame;
import net.minecraft.client.gui.hud.component.ComponentAnchor;
import net.minecraft.client.gui.hud.component.HudComponentMovable;
import net.minecraft.client.gui.hud.component.layout.Layout;
import net.minecraft.client.gui.hud.component.layout.LayoutAbsolute;
import net.minecraft.client.gui.hud.component.layout.LayoutSnap;
import net.minecraft.client.render.font.FontRenderer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.net.command.TextFormatting;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class HudComponentLog
extends HudComponentMovable {
    private static final int HEIGHT_LINES = 4;
    private static final int LINE_HEIGHT = 10;
    private static final int PADDING = 2;
    private static final int WIDTH = 240;
    private static final long MESSAGE_LIFETIME = 5000L;
    private static final long MESSAGE_FADE_TIME = 100L;
    @NotNull
    private final @NotNull Map<@NotNull LogMessage.Level, @NotNull TextFormatting> preludes = new HashMap<LogMessage.Level, TextFormatting>();
    @NotNull
    private final @NotNull List<@NotNull LogEntry> logEntries = new ArrayList<LogEntry>(4);
    private boolean callbackAdded = false;

    public HudComponentLog(@NotNull String key, @NotNull Layout layout) {
        super(key, 244, 44, layout);
        this.preludes.put(LogMessage.Level.ERROR, TextFormatting.RED);
        this.preludes.put(LogMessage.Level.WARN, TextFormatting.YELLOW);
        this.preludes.put(LogMessage.Level.INFO, TextFormatting.WHITE);
        this.preludes.put(LogMessage.Level.DEBUG, TextFormatting.LIGHT_BLUE);
        this.preludes.put(LogMessage.Level.TRACE, TextFormatting.GRAY);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)HudComponentLog.mc.gameSettings.developerMode.value;
    }

    @Override
    public boolean isVisible() {
        return (Boolean)HudComponentLog.mc.gameSettings.developerMode.value;
    }

    @Override
    public void render(@NotNull HudIngame hud, int xSizeScreen, int ySizeScreen, float partialTick) {
        if (!this.callbackAdded) {
            LogMessageReceiver.addCallback(message -> {
                int cWidth;
                int c;
                if (message.getMessage().startsWith("[CHAT] ")) {
                    return;
                }
                @NotNull String ellipsis = "...";
                int ellipsisWidth = HudComponentLog.mc.font.stringWidth("...");
                @NotNull Object line = message.getMessage().replace("\n", "");
                int acc = 0;
                for (c = 0; c < ((String)line).length() && acc + (cWidth = HudComponentLog.mc.font.getFont().charWidth(((String)line).charAt(c))) + ellipsisWidth <= 240; ++c) {
                    acc += cWidth;
                }
                if (c < ((String)line).length()) {
                    line = ((String)line).substring(0, c) + "...";
                }
                if (this.logEntries.size() == 4) {
                    this.logEntries.remove(0);
                }
                if (message.getLevel() != null) {
                    this.logEntries.add(new LogEntry(String.valueOf(this.preludes.get((Object)message.getLevel())) + (String)line));
                } else {
                    this.logEntries.add(new LogEntry((String)line));
                }
            });
            this.callbackAdded = true;
        }
        int x = this.getLayout().getComponentX(this, xSizeScreen);
        int y = this.getLayout().getComponentY(this, ySizeScreen);
        for (int i = 0; i < this.logEntries.size(); ++i) {
            if (!(this.logEntries.get(i).getOpacity() <= 0.0f)) continue;
            this.logEntries.remove(0);
            --i;
        }
        @NotNull String @NotNull [] messages = new String[this.logEntries.size()];
        float @NotNull [] opacities = new float[this.logEntries.size()];
        for (int i = 0; i < this.logEntries.size(); ++i) {
            messages[i] = this.logEntries.get((int)i).message;
            opacities[i] = this.logEntries.get(i).getOpacity();
        }
        ComponentAnchor anchor = null;
        if (this.layout instanceof LayoutAbsolute) {
            anchor = ((LayoutAbsolute)this.layout).getAnchor();
        } else if (this.layout instanceof LayoutSnap) {
            anchor = ((LayoutSnap)this.layout).getAnchor();
        }
        this.render(HudComponentLog.mc.font, x, y, messages, opacities, anchor);
    }

    @Override
    public void renderPreview(@NotNull Gui gui, @NotNull Layout layout, int xSizeScreen, int ySizeScreen) {
        int x = layout.getComponentX(this, xSizeScreen);
        int y = layout.getComponentY(this, ySizeScreen);
        String[] lines = new String[]{String.valueOf(this.preludes.get((Object)LogMessage.Level.DEBUG)) + "This is a debug line!", String.valueOf(this.preludes.get((Object)LogMessage.Level.INFO)) + "This is an info line!", String.valueOf(this.preludes.get((Object)LogMessage.Level.WARN)) + "This is a warning line!", String.valueOf(this.preludes.get((Object)LogMessage.Level.ERROR)) + "This is an error line!"};
        ComponentAnchor anchor = null;
        if (layout instanceof LayoutAbsolute) {
            anchor = ((LayoutAbsolute)layout).getAnchor();
        } else if (layout instanceof LayoutSnap) {
            anchor = ((LayoutSnap)layout).getAnchor();
        }
        this.render(HudComponentLog.mc.font, x, y, lines, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, anchor);
    }

    private void render(@NotNull FontRenderer sr, int x, int y, @NotNull @NotNull String @NotNull [] lines, float @NotNull [] opacities, @Nullable ComponentAnchor anchor) {
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            int lineWidth = sr.stringWidth(line);
            if (anchor == null || anchor == ComponentAnchor.TOP_LEFT || anchor == ComponentAnchor.CENTER_LEFT || anchor == ComponentAnchor.BOTTOM_LEFT) {
                sr.render((Tessellator)Tessellator.instance, line, x + 2, y + 2 + i * 10).setShadow().setColor(0xFFFFFF + ((int)(opacities[i] * 255.0f) << 24)).call();
                continue;
            }
            if (anchor == ComponentAnchor.TOP_CENTER || anchor == ComponentAnchor.CENTER || anchor == ComponentAnchor.BOTTOM_CENTER) {
                sr.render((Tessellator)Tessellator.instance, line, x + 2 + 120 - lineWidth / 2, y + 2 + i * 10).setShadow().setColor(0xFFFFFF + ((int)(opacities[i] * 255.0f) << 24)).call();
                continue;
            }
            sr.render((Tessellator)Tessellator.instance, line, x + 2 + 240 - lineWidth, y + 2 + i * 10).setShadow().setColor(0xFFFFFF + ((int)(opacities[i] * 255.0f) << 24)).call();
        }
        GL11.glDisable(3042);
    }

    private static final class LogEntry {
        @NotNull
        public final String message;
        public final long addedTime;

        public LogEntry(@NotNull String message) {
            this.message = message;
            this.addedTime = System.currentTimeMillis();
        }

        public float getOpacity() {
            long fadeoutStartTime;
            long currentTime = System.currentTimeMillis();
            if (currentTime < (fadeoutStartTime = this.addedTime + 5000L - 100L)) {
                return 1.0f;
            }
            return 1.0f - (float)(currentTime - fadeoutStartTime) / 100.0f;
        }
    }
}

