/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;

public class BlockModelAlgae<T extends BlockLogic>
extends BlockModelStandard<T> {
    public BlockModelAlgae(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, int x, int y, int z) {
        AABB bounds = this.block.getBlockBoundsFromState(worldSource, x, y, z);
        float brightness = 1.0f;
        if (!LightmapHelper.isLightmapEnabled()) {
            brightness = renderBlocks.getBlockBrightness(worldSource, x, y, z);
        } else {
            tessellator.setLightmapCoord(this.block.getLightmapCoord(worldSource, x, y, z));
        }
        int color = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getWorldColor(worldSource, x, y, z, 0);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        tessellator.setColorOpaque_F(red * brightness, green * brightness, blue * brightness);
        IconCoordinate tex = this.getBlockTextureFromSideAndMetadata(Side.TOP, worldSource.getBlockMetadata(x, y, z));
        renderBlocks.renderTopFace(tessellator, bounds, x, (double)y - 0.1125, z, tex);
        renderBlocks.renderBottomFace(tessellator, bounds, x, (double)y + 0.0125, z, tex);
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    public boolean shouldSideBeRendered(WorldSource blockAccess, AABB bounds, int x, int y, int z, @NotNull Side side) {
        if (side == Side.TOP) {
            return true;
        }
        return super.shouldSideBeRendered(blockAccess, bounds, x, y, z, side);
    }
}

