/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicEdible;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;

public class BlockModelPiePumpkin<T extends BlockLogicEdible>
extends BlockModelStandard<T> {
    protected IconCoordinate sideTexture = TextureRegistry.getTexture("minecraft:block/pumpkin_pie/side");
    protected IconCoordinate insideTexture = TextureRegistry.getTexture("minecraft:block/pumpkin_pie/inner");
    protected IconCoordinate topTexture = TextureRegistry.getTexture("minecraft:block/pumpkin_pie/top");

    public BlockModelPiePumpkin(Block<T> block) {
        super(block);
        float f = 0.0625f;
        float f1 = 0.375f;
        this.withCustomItemBounds(0.0625, 0.0, 0.0625, 0.9375, 0.375, 0.9375);
    }

    public void renderSliceSide(Tessellator tessellator, WorldSource worldSource, AABB bounds, int x, int y, int z, Side side, boolean overrideTex) {
        if (overrideTex) {
            BlockModelPiePumpkin.renderBlocks.overrideBlockTexture = this.insideTexture;
        }
        renderBlocks.renderSide(tessellator, worldSource, this, bounds, x, y, z, 1.0f, 1.0f, 1.0f, side, 0);
        if (overrideTex) {
            BlockModelPiePumpkin.renderBlocks.overrideBlockTexture = null;
        }
    }

    private void renderSlice(Tessellator tessellator, WorldSource worldSource, AABB bounds, int x, int y, int z, int sliceX, int sliceZ) {
        double onePix = 0.0625;
        double sliceWidth = 0.5;
        double xMin = 0.0 + 0.5 * (double)sliceX;
        double xMax = xMin + 0.5;
        double zMin = 0.0 + 0.5 * (double)sliceZ;
        double zMax = zMin + 0.5;
        double offsetXMin = sliceX == 0 ? 0.0625 : 0.0;
        double offsetXMax = sliceX == 1 ? 0.0625 : 0.0;
        double offsetZMin = sliceZ == 0 ? 0.0625 : 0.0;
        double offsetZMax = sliceZ == 1 ? 0.0625 : 0.0;
        boolean insideSouth = sliceZ == 0;
        boolean insideNorth = sliceZ == 1;
        boolean insideEast = sliceX == 0;
        boolean insideWest = sliceX == 1;
        bounds.set(xMin + offsetXMin, 0.0, zMin + offsetZMin, xMax - offsetXMax, 0.375, zMax - offsetZMax);
        renderBlocks.renderSide(tessellator, worldSource, this, bounds, x, y, z, 1.0f, 1.0f, 1.0f, Side.TOP, 0);
        renderBlocks.renderSide(tessellator, worldSource, this, bounds, x, y, z, 1.0f, 1.0f, 1.0f, Side.BOTTOM, 0);
        this.renderSliceSide(tessellator, worldSource, bounds, x, y, z, Side.SOUTH, insideSouth);
        this.renderSliceSide(tessellator, worldSource, bounds, x, y, z, Side.WEST, insideWest);
        BlockModelPiePumpkin.renderBlocks.flipTexture = true;
        this.renderSliceSide(tessellator, worldSource, bounds, x, y, z, Side.NORTH, insideNorth);
        this.renderSliceSide(tessellator, worldSource, bounds, x, y, z, Side.EAST, insideEast);
        BlockModelPiePumpkin.renderBlocks.flipTexture = false;
    }

    @Override
    public boolean render(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, int x, int y, int z) {
        AABB bounds = this.block.getBlockBoundsFromState(worldSource, x, y, z);
        int meta = worldSource.getBlockMetadata(x, y, z);
        BlockModelPiePumpkin.renderBlocks.enableAO = true;
        BlockModelPiePumpkin.renderBlocks.cache.setupCache(this.block, worldSource, x, y, z);
        int slices = 0;
        for (int xSlice = 0; xSlice < 2; ++xSlice) {
            for (int zSlice = 0; zSlice < 2; ++zSlice) {
                if (meta >= ++slices) continue;
                this.renderSlice(tessellator, worldSource, bounds, x, y, z, xSlice, zSlice);
            }
        }
        BlockModelPiePumpkin.renderBlocks.enableAO = false;
        return true;
    }
}

