/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.particle;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.particle.Particle;
import net.minecraft.client.render.tessellator.ParticleTessellator;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.entity.animal.MobFireflyCluster;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;

public class ParticleFirefly
extends Particle {
    private float sinTimer = 0.0f;
    private boolean isReversed = false;
    private float midR = 0.0f;
    private float midG = 0.0f;
    private float midB = 0.0f;
    private final float minR = 0.3764706f;
    private final float minG = 0.21176471f;
    private final float minB = 0.0f;
    private float maxR = 0.9411765f;
    private float maxG = 1.0f;
    private float maxB = 0.6784314f;
    private final float oR;
    private final float oG;
    private final float oB;

    public ParticleFirefly(@NotNull World world, double x, double y, double z, double xa, double ya, double za, int type) {
        this(world, x, y, z, xa, ya, za, 1.0f, type);
    }

    public ParticleFirefly(@NotNull World world, double x, double y, double z, double xa, double ya, double za, float scale, int type) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.xd = 0.01;
        this.yd = 0.01;
        this.zd = 0.01;
        this.xd += xa;
        this.yd += ya;
        this.zd += za;
        this.setColor(type);
        this.size = 2.0f;
        this.lifetime = (int)(24.0 + (double)random.nextInt(6));
        this.lifetime *= (int)scale;
        this.noPhysics = false;
        this.tex = TextureRegistry.getTexture("minecraft:particle/firefly");
        if (random.nextInt(2) == 0) {
            this.isReversed = true;
        }
        this.oR = random.nextFloat() * 0.06f - 0.03f;
        this.oG = random.nextFloat() * 0.06f - 0.03f;
        this.oB = random.nextFloat() * 0.06f - 0.03f;
    }

    private void setColor(int type) {
        float[] color = ((MobFireflyCluster.FireflyColor)MobFireflyCluster.FireflyColor.fireFlyColors.get(type)).getMidColor();
        this.midR = color[0];
        this.midG = color[1];
        this.midB = color[2];
        this.rCol = this.midR;
        this.gCol = this.midG;
        this.bCol = this.midB;
        this.maxR = MathHelper.clamp(this.midR + 0.25f, 0.0f, 1.0f);
        this.maxG = MathHelper.clamp(this.midG + 0.25f, 0.0f, 1.0f);
        this.maxB = MathHelper.clamp(this.midB + 0.25f, 0.0f, 1.0f);
    }

    public void setAge(int age) {
        this.age = age;
    }

    @Override
    public float calcBrightness(float partialTick) {
        float internalBrightness = this.getInternalBrightness(partialTick);
        float worldBrightness = super.calcBrightness(partialTick);
        return Math.max(internalBrightness, worldBrightness);
    }

    public float getInternalBrightness(float partialTick) {
        float b = (float)(Math.sin((float)this.age * 0.25f) + 1.0) / 2.0f;
        return MathHelper.clamp(b, 0.0f, 1.0f);
    }

    @Override
    public void render(@NotNull ParticleTessellator t, float partialTick) {
        float ibr = this.getInternalBrightness(partialTick);
        if (ibr < 0.5f) {
            this.rCol = MathHelper.lerp(this.minR, this.midR, ibr * 2.0f);
            this.gCol = MathHelper.lerp(this.minG, this.midG, ibr * 2.0f);
            this.bCol = MathHelper.lerp(this.minB, this.midB, ibr * 2.0f);
        } else {
            this.rCol = MathHelper.lerp(this.midR, this.maxR, (ibr - 0.5f) * 2.0f);
            this.gCol = MathHelper.lerp(this.midG, this.maxG, (ibr - 0.5f) * 2.0f);
            this.bCol = MathHelper.lerp(this.midB, this.maxB, (ibr - 0.5f) * 2.0f);
        }
        this.rCol += this.oR;
        this.gCol += this.oG;
        this.bCol += this.oB;
        super.render(t, partialTick);
    }

    public void renderParticleInGui(Tessellator t, float partialTick) {
        float ibr = this.getInternalBrightness(partialTick);
        if (ibr < 0.5f) {
            this.rCol = MathHelper.lerp(this.minR, this.midR, ibr * 2.0f);
            this.gCol = MathHelper.lerp(this.minG, this.midG, ibr * 2.0f);
            this.bCol = MathHelper.lerp(this.minB, this.midB, ibr * 2.0f);
        } else {
            this.rCol = MathHelper.lerp(this.midR, this.maxR, (ibr - 0.5f) * 2.0f);
            this.gCol = MathHelper.lerp(this.midG, this.maxG, (ibr - 0.5f) * 2.0f);
            this.bCol = MathHelper.lerp(this.midB, this.maxB, (ibr - 0.5f) * 2.0f);
        }
        this.rCol += this.oR;
        this.gCol += this.oG;
        this.bCol += this.oB;
        float u0 = (float)this.tex.getIconUMin();
        float u2 = (float)this.tex.getIconUMax();
        float v0 = (float)this.tex.getIconVMin();
        float v2 = (float)this.tex.getIconVMax();
        float r = 0.1f * this.size;
        float x = (float)(this.xo + (this.x - this.xo) * (double)partialTick);
        float y = (float)(this.yo + (this.y - this.yo) * (double)partialTick);
        float z = (float)(this.zo + (this.z - this.zo) * (double)partialTick);
        float br = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            t.setLightmapCoord(this.getLightmap(partialTick));
        } else {
            br = this.getBrightness(partialTick);
        }
        t.setColorOpaque_F(this.rCol * br, this.gCol * br, this.bCol * br);
        t.addVertexWithUV(x + r, y - r, z / 10.0f, u2, v2);
        t.addVertexWithUV(x + r, y + r, z / 10.0f, u2, v0);
        t.addVertexWithUV(x - r, y + r, z / 10.0f, u0, v0);
        t.addVertexWithUV(x - r, y - r, z / 10.0f, u0, v2);
    }

    @Override
    public int calcLightmap(float partialTick) {
        return LightmapHelper.setBlocklightValue(super.calcLightmap(partialTick), 15);
    }

    public void tickGui() {
        this.sinTimer += 1.0f;
        if (this.sinTimer > 100.0f) {
            this.sinTimer = 0.0f;
        }
        if (this.age++ >= this.lifetime && this.getInternalBrightness(1.0f) < 0.01f) {
            this.remove();
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.xd = MathHelper.sin(this.sinTimer * 0.15f) / 60.0f;
        this.yd = MathHelper.cos(this.sinTimer * 0.15f) / 60.0f;
        this.zd = MathHelper.cos(this.sinTimer * 0.15f) / 60.0f;
        if (this.isReversed) {
            this.xd = -this.xd;
            this.yd = -this.yd;
            this.zd = -this.zd;
        }
        this.move(this.xd, this.yd, this.zd);
    }

    @Override
    public void tick() {
        if (LightmapHelper.isLightmapEnabled()) {
            this.cachedLightmapCoord = this.calcLightmap(1.0f);
        }
        this.sinTimer += 1.0f;
        if (this.sinTimer > 100.0f) {
            this.sinTimer = 0.0f;
        }
        if (this.age++ >= this.lifetime && this.getInternalBrightness(1.0f) < 0.01f) {
            this.remove();
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.xd = MathHelper.sin(this.sinTimer * 0.15f) / 60.0f;
        this.zd = MathHelper.cos(this.sinTimer * 0.15f) / 60.0f;
        if (this.isReversed) {
            this.xd = -this.xd;
            this.yd = -this.yd;
            this.zd = -this.zd;
        }
        this.move(this.xd, this.yd, this.zd);
    }
}

