/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tessellator;

import com.mojang.logging.LogUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.tessellator.ParticleTessellator;
import net.minecraft.core.util.helper.Buffer;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.slf4j.Logger;

public class ShaderParticleTessellator
implements ParticleTessellator {
    private static final Logger LOGGER = LogUtils.getLogger();
    private boolean drawing = false;
    private ByteBuffer buffer;
    private int count = 0;
    private final int vbo;
    private boolean enableColor;
    private boolean enableLightmap;
    private int color;
    private int lightmapCoord;
    private double offsetX;
    private double offsetY;
    private double offsetZ;

    public ShaderParticleTessellator(int size) {
        this.buffer = Buffer.createBuffer(size);
        this.vbo = GL15.glGenBuffers();
    }

    @Override
    public void startDrawingParticles() {
        if (this.drawing) {
            throw new IllegalStateException("Already drawing!");
        }
        this.drawing = true;
        this.count = 0;
        this.buffer.clear();
    }

    @Override
    public void setLightmapCoord(int lightmapCoord) {
        this.checkIsDrawing();
        if (!this.enableLightmap) {
            if (this.count > 0) {
                throw new IllegalStateException("Lightmap is disabled!");
            }
            this.enableLightmap = true;
        }
        this.lightmapCoord = lightmapCoord;
    }

    @Override
    public void addParticle(double x, double y, double z, float scale, double u, double v, double uSize, double vSize) {
        this.checkIsDrawing();
        if (this.buffer.capacity() < this.buffer.position() + 64) {
            int newSize = this.buffer.capacity() * 2;
            LOGGER.info("Expanding Particle Tessellator Buffer ({} -> {})", (Object)this.buffer.capacity(), (Object)newSize);
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(newSize).order(ByteOrder.nativeOrder());
            this.buffer.flip();
            newBuffer.put(this.buffer);
            this.buffer = newBuffer;
        }
        this.buffer.putFloat((float)(x + this.offsetX)).putFloat((float)(y + this.offsetY)).putFloat((float)(z + this.offsetZ)).putFloat(scale);
        if (this.enableColor) {
            this.buffer.putInt(this.color);
        }
        this.buffer.putFloat((float)u).putFloat((float)v);
        this.buffer.putFloat((float)uSize).putFloat((float)vSize);
        if (this.enableLightmap) {
            this.buffer.put((byte)(LightmapHelper.getBlockLightFromCoord(this.lightmapCoord) * 16 + 8)).put((byte)(LightmapHelper.getSkyLightFromCoord(this.lightmapCoord) * 16 + 8));
        }
        ++this.count;
    }

    @Override
    public void drawParticles() {
        this.checkIsDrawing();
        this.drawing = false;
        if (this.count == 0) {
            return;
        }
        int vertexSize = 32;
        if (this.enableColor) {
            vertexSize += 4;
        }
        if (this.enableLightmap) {
            vertexSize += 2;
        }
        int offset = 0;
        GL15.glBindBuffer(34962, this.vbo);
        GL20.glVertexAttribPointer(0, 3, 5126, false, vertexSize, offset);
        GL20.glVertexAttribPointer(1, 1, 5126, false, vertexSize, offset += 12);
        offset += 4;
        if (this.enableColor) {
            GL20.glVertexAttribPointer(2, 4, 5121, true, vertexSize, offset);
            offset += 4;
        } else {
            GL20.glVertexAttrib4f(2, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        GL20.glVertexAttribPointer(3, 2, 5126, false, vertexSize, offset);
        GL20.glVertexAttribPointer(4, 2, 5126, false, vertexSize, offset += 8);
        offset += 8;
        if (this.enableLightmap) {
            GL20.glVertexAttribPointer(5, 2, 5121, true, vertexSize, offset);
            offset += 2;
        } else {
            GL20.glVertexAttrib2f(5, 0.96875f, 0.96875f);
        }
        GL20.glEnableVertexAttribArray(0);
        GL20.glEnableVertexAttribArray(1);
        if (this.enableColor) {
            GL20.glEnableVertexAttribArray(2);
        }
        GL20.glEnableVertexAttribArray(3);
        GL20.glEnableVertexAttribArray(4);
        if (this.enableLightmap) {
            GL20.glEnableVertexAttribArray(5);
        }
        GL15.glBufferData(34962, this.buffer.flip(), 35040);
        GL11.glDrawArrays(0, 0, this.count);
        GL15.glBindBuffer(34962, 0);
        GL20.glDisableVertexAttribArray(0);
        GL20.glDisableVertexAttribArray(1);
        GL20.glDisableVertexAttribArray(2);
        GL20.glDisableVertexAttribArray(3);
        GL20.glDisableVertexAttribArray(4);
        GL20.glDisableVertexAttribArray(5);
        this.enableColor = false;
        this.enableLightmap = false;
    }

    public void checkIsDrawing() {
        if (!this.drawing) {
            throw new IllegalStateException("Not drawing!");
        }
    }

    @Override
    public void setTranslation(double x, double y, double z) {
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
    }

    @Override
    public void offsetTranslation(double x, double y, double z) {
        this.offsetX += x;
        this.offsetY += y;
        this.offsetZ += z;
    }

    @Override
    public void setColorOpaque(int r, int g, int b) {
        this.setColorRGBA(r, g, b, 255);
    }

    @Override
    public void setColorOpaque_F(float r, float g, float b) {
        this.setColorOpaque((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f));
    }

    @Override
    public void setColorOpaque_I(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        this.setColorOpaque(r, g, b);
    }

    @Override
    public void setColorRGBA_F(float r, float g, float b, float a) {
        this.setColorRGBA((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), (int)(a * 255.0f));
    }

    @Override
    public void setColorRGBA_I(int rgb, int a) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        this.setColorRGBA(r, g, b, a);
    }

    @Override
    public void setupParticleValues(@NotNull ICamera camera, float partialTick) {
    }

    @Override
    public void setColorRGBA(int r, int g, int b, int a) {
        this.checkIsDrawing();
        if (!this.enableColor) {
            if (this.count > 0) {
                throw new IllegalStateException("Color is disabled!");
            }
            this.enableColor = true;
        }
        r = MathHelper.clamp(r, 0, 255);
        g = MathHelper.clamp(g, 0, 255);
        b = MathHelper.clamp(b, 0, 255);
        a = MathHelper.clamp(a, 0, 255);
        this.color = a << 24 | b << 16 | g << 8 | r;
    }
}

