/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.IPaintable;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.ISupportable;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.tag.ItemTags;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicButton
extends BlockLogic
implements IPaintable,
ISupportable {
    public static final int MASK_POWERED = 8;
    public static final int MASK_DIRECTION = 7;
    public static final int SIDE_WEST = 1;
    public static final int SIDE_EAST = 2;
    public static final int SIDE_NORTH = 3;
    public static final int SIDE_SOUTH = 4;
    public static final int SIDE_TOP = 5;
    public static final int SIDE_BOTTOM = 6;

    public BlockLogicButton(@NotNull Block<?> block) {
        super(block, Material.decoration);
        block.setTicking(true);
    }

    @Override
    @Nullable
    public AABB getCollisionAABB(@NotNull WorldSource source, @NotNull TilePos tilePos) {
        return null;
    }

    @Override
    public int tickDelay() {
        return 20;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side) {
        return PartialSupport.INSTANCE;
    }

    @Override
    public boolean canPlaceOnSide(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side) {
        @NotNull Side checkSide = side.getOpposite();
        return this.isSupported(world, tilePos, checkSide);
    }

    @Override
    public boolean canPlaceAt(@NotNull World world, @NotNull TilePos tilePos) {
        return this.isSupported(world, tilePos, Side.BOTTOM) || this.isSupported(world, tilePos, Side.TOP) || this.isSupported(world, tilePos, Side.NORTH) || this.isSupported(world, tilePos, Side.SOUTH) || this.isSupported(world, tilePos, Side.WEST) || this.isSupported(world, tilePos, Side.EAST);
    }

    @Override
    public void onPlacedByMob(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side, @NotNull Mob mob, double xHit, double yHit) {
        int orientation = -1;
        switch (side) {
            case BOTTOM: {
                if (!this.isSupported(world, tilePos, Side.TOP)) break;
                orientation = 5;
                break;
            }
            case TOP: {
                if (!this.isSupported(world, tilePos, Side.BOTTOM)) break;
                orientation = 6;
                break;
            }
            case NORTH: {
                if (!this.isSupported(world, tilePos, Side.SOUTH)) break;
                orientation = 4;
                break;
            }
            case SOUTH: {
                if (!this.isSupported(world, tilePos, Side.NORTH)) break;
                orientation = 3;
                break;
            }
            case WEST: {
                if (!this.isSupported(world, tilePos, Side.EAST)) break;
                orientation = 2;
                break;
            }
            case EAST: {
                if (!this.isSupported(world, tilePos, Side.WEST)) break;
                orientation = 1;
            }
        }
        if (orientation == -1) {
            orientation = this.getOrientation(world, tilePos);
        }
        if (orientation != -1) {
            int meta = world.getBlockData(tilePos);
            world.setBlockDataNotify(tilePos, meta & 0xFFFFFFF8 | orientation);
        }
    }

    @Override
    public void onPlacedOnSide(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side, double xHit, double yHit) {
        int orientation = -1;
        if (side.isHorizontal()) {
            side = side.getOpposite();
        }
        switch (side) {
            case BOTTOM: {
                if (!this.isSupported(world, tilePos, Side.TOP)) break;
                orientation = 5;
                break;
            }
            case TOP: {
                if (!this.isSupported(world, tilePos, Side.BOTTOM)) break;
                orientation = 6;
                break;
            }
            case NORTH: {
                if (!this.isSupported(world, tilePos, Side.SOUTH)) break;
                orientation = 4;
                break;
            }
            case SOUTH: {
                if (!this.isSupported(world, tilePos, Side.NORTH)) break;
                orientation = 3;
                break;
            }
            case WEST: {
                if (!this.isSupported(world, tilePos, Side.EAST)) break;
                orientation = 2;
                break;
            }
            case EAST: {
                if (!this.isSupported(world, tilePos, Side.WEST)) break;
                orientation = 1;
            }
        }
        if (orientation == -1) {
            orientation = this.getOrientation(world, tilePos);
        }
        if (orientation != -1) {
            int meta = world.getBlockData(tilePos);
            world.setBlockDataNotify(tilePos, meta & 0xFFFFFFF8 | orientation);
        }
    }

    private int getOrientation(@NotNull World world, @NotNull TilePos tilePos) {
        if (this.isSupported(world, tilePos, Side.WEST)) {
            return 1;
        }
        if (this.isSupported(world, tilePos, Side.EAST)) {
            return 2;
        }
        if (this.isSupported(world, tilePos, Side.NORTH)) {
            return 3;
        }
        if (this.isSupported(world, tilePos, Side.SOUTH)) {
            return 4;
        }
        if (this.isSupported(world, tilePos, Side.TOP)) {
            return 5;
        }
        if (this.isSupported(world, tilePos, Side.BOTTOM)) {
            return 6;
        }
        return -1;
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePos tilePos, int id) {
        boolean invalid;
        int meta = world.getBlockData(tilePos);
        int side = meta & 7;
        switch (side) {
            case 1: {
                boolean bl;
                if (!this.isSupported(world, tilePos, Side.WEST)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                boolean bl;
                if (!this.isSupported(world, tilePos, Side.EAST)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                boolean bl;
                if (!this.isSupported(world, tilePos, Side.NORTH)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 4: {
                boolean bl;
                if (!this.isSupported(world, tilePos, Side.SOUTH)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 5: {
                boolean bl;
                if (!this.isSupported(world, tilePos, Side.TOP)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 6: {
                boolean bl;
                if (!this.isSupported(world, tilePos, Side.BOTTOM)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                boolean bl = invalid = false;
            }
        }
        if (invalid) {
            this.dropWithCause(world, EnumDropCause.WORLD, tilePos, meta, null, null);
            world.setBlockIdNotify(tilePos, 0);
        }
    }

    @Override
    @NotNull
    public AABB getBoundsFromState(@NotNull WorldSource source, @NotNull TilePos tilePos) {
        int meta = source.getBlockData(tilePos);
        int direction = meta & 7;
        boolean powered = (meta & 8) != 0;
        float bottom = 0.375f;
        float top = 0.625f;
        float halfWidth = 0.1875f;
        float depth = powered ? 0.0625f : 0.125f;
        return switch (direction) {
            case 1 -> AABB.fromPool(0.0, 0.375, 0.3125, depth, 0.625, 0.6875);
            case 2 -> AABB.fromPool(1.0f - depth, 0.375, 0.3125, 1.0, 0.625, 0.6875);
            case 3 -> AABB.fromPool(0.3125, 0.375, 0.0, 0.6875, 0.625, depth);
            case 4 -> AABB.fromPool(0.3125, 0.375, 1.0f - depth, 0.6875, 0.625, 1.0);
            case 5 -> AABB.fromPool(0.3125, 1.0f - depth, 0.375, 0.6875, 1.0, 0.625);
            case 6 -> AABB.fromPool(0.3125, 0.0, 0.375, 0.6875, depth, 0.625);
            default -> super.getBoundsFromState(source, tilePos);
        };
    }

    @Override
    public void onAttacked(@NotNull World world, @NotNull TilePos tilePos, @NotNull Player player, @NotNull Side side, double xHit, double yHit) {
        if (!Item.hasTag(player.getCurrentEquippedItem(), ItemTags.PREVENT_LEFT_CLICK_INTERACTIONS)) {
            this.onInteracted(world, tilePos, player, null, 0.0, 0.0);
        }
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePos tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        return this.press(world, tilePos, player);
    }

    private boolean press(@NotNull World world, @NotNull TilePos tilePos, @Nullable Player player) {
        boolean isPowered;
        int meta = world.getBlockData(tilePos);
        int direction = meta & 7;
        boolean bl = isPowered = (meta & 8) != 0;
        if (isPowered) {
            return false;
        }
        world.setBlockDataNotify(tilePos, meta & 0xFFFFFFF8 | direction | 8);
        world.markBlockDirty(tilePos);
        world.playSoundEffect(player, SoundCategory.WORLD_SOUNDS, (double)tilePos.x + 0.5, (double)tilePos.y + 0.5, (double)tilePos.z + 0.5, "random.click", 0.3f, 0.6f);
        world.notifyBlocksOfNeighborChange(tilePos, this.block.id());
        switch (direction) {
            case 1: {
                world.notifyBlocksOfNeighborChange((TilePos)tilePos.west(), this.block.id());
                break;
            }
            case 2: {
                world.notifyBlocksOfNeighborChange((TilePos)tilePos.east(), this.block.id());
                break;
            }
            case 3: {
                world.notifyBlocksOfNeighborChange((TilePos)tilePos.north(), this.block.id());
                break;
            }
            case 4: {
                world.notifyBlocksOfNeighborChange((TilePos)tilePos.south(), this.block.id());
                break;
            }
            case 5: {
                world.notifyBlocksOfNeighborChange((TilePos)tilePos.up(), this.block.id());
                break;
            }
            case 6: {
                world.notifyBlocksOfNeighborChange((TilePos)tilePos.down(), this.block.id());
            }
        }
        world.scheduleBlockUpdate(tilePos, this.block.id(), this.tickDelay());
        return true;
    }

    @Override
    public void onActivatorInteracted(@NotNull World world, @NotNull TilePos tilePos, @NotNull TileEntityActivator activator, @NotNull Direction direction) {
        this.press(world, tilePos, null);
    }

    @Override
    public void onRemoved(@NotNull World world, @NotNull TilePos tilePos, int data) {
        if ((data & 8) != 0) {
            world.notifyBlocksOfNeighborChange(tilePos, this.block.id());
            int direction = data & 7;
            switch (direction) {
                case 1: {
                    world.notifyBlocksOfNeighborChange((TilePos)tilePos.west(), this.block.id());
                    break;
                }
                case 2: {
                    world.notifyBlocksOfNeighborChange((TilePos)tilePos.east(), this.block.id());
                    break;
                }
                case 3: {
                    world.notifyBlocksOfNeighborChange((TilePos)tilePos.north(), this.block.id());
                    break;
                }
                case 4: {
                    world.notifyBlocksOfNeighborChange((TilePos)tilePos.south(), this.block.id());
                    break;
                }
                case 5: {
                    world.notifyBlocksOfNeighborChange((TilePos)tilePos.up(), this.block.id());
                    break;
                }
                case 6: {
                    world.notifyBlocksOfNeighborChange((TilePos)tilePos.down(), this.block.id());
                }
            }
        }
        super.onRemoved(world, tilePos, data);
    }

    @Override
    public boolean isEmittingSignal(@NotNull WorldSource source, @NotNull TilePos tilePos, @NotNull Side side) {
        return (source.getBlockData(tilePos) & 8) != 0;
    }

    @Override
    public boolean isEmittingDirectSignal(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side) {
        int meta = world.getBlockData(tilePos);
        if ((meta & 8) == 0) {
            return false;
        }
        int direction = meta & 7;
        return switch (direction) {
            case 1 -> {
                if (side == Side.EAST) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (side == Side.WEST) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (side == Side.SOUTH) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (side == Side.NORTH) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                if (side == Side.BOTTOM) {
                    yield true;
                }
                yield false;
            }
            case 6 -> {
                if (side == Side.TOP) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    public boolean isSignalSource() {
        return true;
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePos tilePos, @NotNull Random rand, boolean isRandomTick) {
        if (world.isClientSide) {
            return;
        }
        int meta = world.getBlockData(tilePos);
        if ((meta & 8) == 0) {
            return;
        }
        world.setBlockDataNotify(tilePos, meta & 0xFFFFFFF7);
        world.notifyBlocksOfNeighborChange(tilePos, this.block.id());
        int direction = meta & 7;
        switch (direction) {
            case 1: {
                world.notifyBlocksOfNeighborChange((TilePos)tilePos.west(), this.block.id());
                break;
            }
            case 2: {
                world.notifyBlocksOfNeighborChange((TilePos)tilePos.east(), this.block.id());
                break;
            }
            case 3: {
                world.notifyBlocksOfNeighborChange((TilePos)tilePos.north(), this.block.id());
                break;
            }
            case 4: {
                world.notifyBlocksOfNeighborChange((TilePos)tilePos.south(), this.block.id());
                break;
            }
            case 5: {
                world.notifyBlocksOfNeighborChange((TilePos)tilePos.up(), this.block.id());
                break;
            }
            case 6: {
                world.notifyBlocksOfNeighborChange((TilePos)tilePos.down(), this.block.id());
            }
        }
        world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)tilePos.x + 0.5, (double)tilePos.y + 0.5, (double)tilePos.z + 0.5, "random.click", 0.3f, 0.5f);
        world.markBlockDirty(tilePos);
    }

    @Override
    public boolean canBePainted() {
        return this.id() == Blocks.BUTTON_PLANKS.id();
    }

    @Override
    public void setColor(@NotNull World world, @NotNull TilePos tilePos, @NotNull DyeColor color) {
        int meta = world.getBlockData(tilePos);
        world.setBlockIdDataRaw(tilePos, Blocks.BUTTON_PLANKS_PAINTED.id(), meta);
        world.setBlockData(tilePos, meta);
        Blocks.BUTTON_PLANKS_PAINTED.getLogic().setColor(world, tilePos, color);
        if ((meta & 8) != 0) {
            world.scheduleBlockUpdate(tilePos, Blocks.BUTTON_PLANKS_PAINTED.id(), this.tickDelay());
        }
    }

    @Override
    @NotNull
    public ISupport getSupportConstraint(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side) {
        return PartialSupport.INSTANCE.center();
    }
}

