/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFarmland;
import net.minecraft.core.block.BlockLogicFlower;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.IBonemealable;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicCropsWheat
extends BlockLogicFlower
implements IBonemealable {
    public static final int MASK_GROWTH = 7;
    public static final int MAX_GROWTH_STATE = 7;

    public BlockLogicCropsWheat(@NotNull Block<?> block) {
        super(block);
        block.setTicking(true);
        float halfWidth = 0.5f;
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
    }

    @Override
    public boolean mayPlaceOn(int blockId) {
        return blockId == Blocks.FARMLAND_DIRT.id();
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePos tilePos, @NotNull Random rand, boolean isRandomTick) {
        float growthRate;
        int data;
        super.updateTick(world, tilePos, rand, isRandomTick);
        if (world.getBlockLightValue((TilePos)tilePos.up()) >= 9 && (data = world.getBlockData(tilePos)) < 7 && rand.nextInt((int)(100.0f / (growthRate = this.getGrowthRate(world, tilePos)))) == 0) {
            world.setBlockDataNotify(tilePos, data + 1);
        }
    }

    private float getGrowthRate(@NotNull World world, @NotNull TilePos tilePos) {
        boolean isFertilized;
        float growthRate = 1.0f;
        int idNegZ = world.getBlockId((TilePos)tilePos.north());
        int idPosZ = world.getBlockId((TilePos)tilePos.south());
        int idNegX = world.getBlockId((TilePos)tilePos.west());
        int idPosX = world.getBlockId((TilePos)tilePos.east());
        int idNegXNegZ = world.getBlockId((TilePos)((TilePos)tilePos.west()).north());
        int idPosXNegZ = world.getBlockId((TilePos)((TilePos)tilePos.east()).north());
        int idPosXPosZ = world.getBlockId((TilePos)((TilePos)tilePos.east()).south());
        int idNegXPosZ = world.getBlockId((TilePos)((TilePos)tilePos.west()).south());
        boolean xNeighbor = idNegX == this.block.id() || idPosX == this.block.id();
        boolean zNeighbor = idNegZ == this.block.id() || idPosZ == this.block.id();
        boolean diagNeighbor = idNegXNegZ == this.block.id() || idPosXNegZ == this.block.id() || idPosXPosZ == this.block.id() || idNegXPosZ == this.block.id();
        @NotNull TilePos localPos = new TilePos(tilePos);
        localPos.x = tilePos.x - 1;
        while (localPos.x <= tilePos.x + 1) {
            localPos.z = tilePos.z - 1;
            while (localPos.z <= tilePos.z + 1) {
                int id = world.getBlockId((TilePos)tilePos.down());
                float growthRateMod = 0.0f;
                if (id == Blocks.FARMLAND_DIRT.id()) {
                    growthRateMod = 1.0f;
                    if (world.getBlockData((TilePos)tilePos.down()) > 0) {
                        growthRateMod = 3.0f;
                    }
                }
                if (!tilePos.equals(localPos)) {
                    growthRateMod /= 4.0f;
                }
                growthRate += growthRateMod;
                ++localPos.z;
            }
            ++localPos.x;
        }
        if (diagNeighbor || xNeighbor && zNeighbor) {
            growthRate /= 2.0f;
        }
        if (!(isFertilized = BlockLogicFarmland.isFertilized(world.getBlockData((TilePos)tilePos.down())))) {
            if (world.getSeasonManager().getCurrentSeason() != null) {
                growthRate *= world.getSeasonManager().getCurrentSeason().cropGrowthFactor;
            }
        } else {
            growthRate *= 1.5f;
        }
        return growthRate;
    }

    @Override
    public void onDestroyedByPlayer(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side, int data, @NotNull Player player, @Nullable Item item) {
        boolean isFertilized = BlockLogicFarmland.isFertilized(world.getBlockData((TilePos)tilePos.down()));
        if (isFertilized && !world.isClientSide) {
            boolean shouldDefertilize;
            boolean bl = shouldDefertilize = world.rand.nextInt(3) == 2;
            if (shouldDefertilize) {
                world.setBlockData((TilePos)tilePos.down(), BlockLogicFarmland.setFertilized(world.getBlockData((TilePos)tilePos.down()), false));
            }
        }
    }

    @Override
    public @NotNull ItemStack @Nullable [] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        if (data != 7) {
            return new ItemStack[]{new ItemStack(Items.SEEDS_WHEAT)};
        }
        return new ItemStack[]{new ItemStack(Items.SEEDS_WHEAT, world.rand.nextInt(3) + 1), new ItemStack(Items.WHEAT)};
    }

    @Override
    public boolean onBonemealUsed(@NotNull ItemStack itemStack, @Nullable Player player, @NotNull World world, @NotNull TilePos tilePos, @NotNull Side side, double xHit, double yHit) {
        if (world.getBlockData(tilePos) < 7) {
            if (!world.isClientSide) {
                world.setBlockDataNotify(tilePos, 7);
                if (player == null || player.getGamemode().consumeBlocks()) {
                    --itemStack.stackSize;
                }
            }
            return true;
        }
        return false;
    }
}

