/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicFlag
extends BlockLogic {
    public BlockLogicFlag(@NotNull Block<?> block, @NotNull Material material) {
        super(block, material);
        float f = 0.125f;
        float f1 = 1.0f;
        this.setBlockBounds(0.5f - f, 0.0, 0.5f - f, 0.5f + f, f1, 0.5f + f);
        block.withEntity(TileEntityFlag::new);
    }

    @Override
    @Nullable
    public AABB getCollisionAABB(@NotNull WorldSource source, @NotNull TilePos tilePos) {
        return null;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side) {
        return PartialSupport.INSTANCE;
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        ItemStack stack = new ItemStack(Items.FLAG);
        if (tileEntity != null) {
            CompoundTag compound = new CompoundTag();
            tileEntity.writeAdditionalData(compound);
            stack.getData().putCompound("FlagData", compound);
        }
        return new ItemStack[]{stack};
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePos tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        TileEntity tileEntity;
        if (!world.isClientSide && (tileEntity = world.getTileEntity(tilePos)) instanceof TileEntityFlag) {
            int heldItemId;
            TileEntityFlag flag = (TileEntityFlag)tileEntity;
            if (flag.owner != null && !player.uuid.equals(flag.owner)) {
                return false;
            }
            int n = heldItemId = player.getHeldItem() != null ? player.getHeldItem().itemID : 0;
            if (heldItemId == Items.MAP.id || heldItemId == Items.FLAG.id) {
                return false;
            }
            player.displayFlagEditorScreen(flag);
            return true;
        }
        return true;
    }

    @Override
    public int getPistonPushReaction(@NotNull World world, @NotNull TilePos tilePos) {
        return 1;
    }
}

