/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFlower;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicFlowerStackable
extends BlockLogicFlower {
    public static final int MASK_STACK_COUNT = 96;
    public static final int OFFSET_STACK_COUNT = 5;
    public static final int MAX_STACK_COUNT = 3;

    public BlockLogicFlowerStackable(@NotNull Block<?> block) {
        super(block);
    }

    @Override
    public int getPlacedData(@Nullable Player player, @NotNull ItemStack itemStack, @NotNull World world, @NotNull TilePos tilePos, @NotNull Side side, double xHit, double yHit) {
        int metadata = itemStack.getMetadata();
        return BlockLogicFlowerStackable.setPermanent(metadata, true);
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        int stackCount = BlockLogicFlowerStackable.getStackCount(data) + 1;
        if (dropCause == EnumDropCause.PICK_BLOCK) {
            return new ItemStack[]{new ItemStack(this, 1, 0)};
        }
        if (dropCause == EnumDropCause.SILK_TOUCH) {
            return new ItemStack[]{new ItemStack(this, 1, data & 0x60)};
        }
        return new ItemStack[]{new ItemStack(this, stackCount, 0)};
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePos tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        int metadata = world.getBlockData(tilePos);
        int currentStackCount = BlockLogicFlowerStackable.getStackCount(metadata);
        if (currentStackCount >= 3) {
            return false;
        }
        ItemStack heldItem = player.getHeldItem();
        if (heldItem == null || heldItem.stackSize < 1 || heldItem.getItem().id != this.block.id()) {
            return false;
        }
        int newMetadata = BlockLogicFlowerStackable.setPermanent(BlockLogicFlowerStackable.setStackCount(metadata, currentStackCount + 1), true);
        world.setBlockDataNotify(tilePos, newMetadata);
        world.playBlockSoundEffect(player, (float)tilePos.x + 0.5f, (float)tilePos.y + 0.5f, (float)tilePos.z + 0.5f, this.block, EnumBlockSoundEffectType.PLACE);
        heldItem.consumeItem(player);
        return true;
    }

    public static int getStackCount(int metadata) {
        return (metadata & 0x60) >> 5;
    }

    public static int setStackCount(int metadata, int stackCount) {
        return metadata & 0xFFFFFF9F | stackCount << 5 & 0x60;
    }
}

