/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.data.gamerule.GameRules;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicGrass
extends BlockLogic {
    @NotNull
    public final Block<?> dirt;

    public BlockLogicGrass(@NotNull Block<?> block, @NotNull Block<?> dirt) {
        super(block, Material.grass);
        block.setTicking(true);
        this.dirt = dirt;
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePos tilePos, @NotNull Random rand, boolean isRandomTick) {
        if (world.isClientSide) {
            return;
        }
        TilePos up = (TilePos)tilePos.up();
        if (world.getBlockLightValue(up) < 4 && Blocks.lightBlock[world.getBlockId(up)] > 2) {
            world.setBlockIdNotify(tilePos, this.dirt.id());
        } else if (world.getBlockLightValue(up) >= 9) {
            TilePos p = new TilePos(tilePos);
            for (int i = 0; i < 4; ++i) {
                p.set(tilePos.x + rand.nextInt(3) - 1, tilePos.y + rand.nextInt(5) - 3, tilePos.x + rand.nextInt(3) - 1);
                TilePos pUp = (TilePos)p.up();
                if (world.getBlockId(p) != this.dirt.id() || world.getBlockLightValue(pUp) < 4 || Blocks.lightBlock[world.getBlockId(pUp)] > 2) continue;
                world.setBlockIdNotify(p, this.block.id());
            }
            if (world.getGameRuleValue(GameRules.DO_SEASONAL_GROWTH).booleanValue() && world.getBlockId(up) == 0 && world.getSeasonManager().getCurrentSeason() != null && world.getSeasonManager().getCurrentSeason().growFlowers && rand.nextInt(256) == 0) {
                int idToSpawn = 0;
                int r = rand.nextInt(400);
                if (r < 26) {
                    idToSpawn = Blocks.FLOWER_RED.id();
                } else if (r < 41) {
                    idToSpawn = Blocks.FLOWER_YELLOW.id();
                } else if (r < 60) {
                    Biome biome = world.getBlockBiome(up);
                    if (biome == Biomes.OVERWORLD_BIRCH_FOREST || biome == Biomes.OVERWORLD_SEASONAL_FOREST) {
                        idToSpawn = Blocks.FLOWER_PINK.id();
                    } else if (biome == Biomes.OVERWORLD_MEADOW || biome == Biomes.OVERWORLD_BOREAL_FOREST || biome == Biomes.OVERWORLD_SHRUBLAND) {
                        idToSpawn = Blocks.FLOWER_PURPLE.id();
                    } else if (biome == Biomes.OVERWORLD_FOREST || biome == Biomes.OVERWORLD_SWAMPLAND || biome == Biomes.OVERWORLD_RAINFOREST || biome == Biomes.OVERWORLD_CAATINGA) {
                        idToSpawn = Blocks.FLOWER_LIGHT_BLUE.id();
                    }
                } else {
                    idToSpawn = rand.nextInt(8) == 0 ? Blocks.TALLGRASS_FERN.id() : Blocks.TALLGRASS.id();
                }
                world.setBlockIdNotify(up, idToSpawn);
            }
        }
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        ItemStack[] itemStackArray;
        switch (dropCause) {
            case SILK_TOUCH: 
            case PICK_BLOCK: {
                ItemStack[] itemStackArray2 = new ItemStack[1];
                itemStackArray = itemStackArray2;
                itemStackArray2[0] = new ItemStack(this);
                break;
            }
            default: {
                ItemStack[] itemStackArray3 = new ItemStack[1];
                itemStackArray = itemStackArray3;
                itemStackArray3[0] = new ItemStack(this.dirt);
            }
        }
        return itemStackArray;
    }
}

