/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicOreRedstone;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class BlockLogicNote
extends BlockLogic {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int MASK_NOTE = 63;
    public static final int MASK_POWERED = 128;
    public static final byte MAX_NOTE = 24;

    public BlockLogicNote(@NotNull Block<?> block) {
        super(block, Material.wood);
        block.withEntity(null);
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePos tilePos, int id) {
        boolean powered = world.hasNeighborSignal(tilePos);
        int data = world.getBlockData(tilePos);
        if (BlockLogicNote.isPowered(data) && !powered) {
            world.setBlockData(tilePos, BlockLogicNote.setPowered(data, false));
        } else if (!BlockLogicNote.isPowered(data) && powered) {
            this.triggerNote(world, tilePos);
            world.setBlockData(tilePos, BlockLogicNote.setPowered(data, true));
        }
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePos tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        if (!world.isClientSide) {
            this.changePitch(world, tilePos, player.isSneaking() ? -1 : 1);
            this.triggerNote(world, tilePos);
        }
        return true;
    }

    @Override
    public void onActivatorInteracted(@NotNull World world, @NotNull TilePos tilePos, @NotNull TileEntityActivator activator, @NotNull Direction direction) {
        this.changePitch(world, tilePos, 1);
        this.triggerNote(world, tilePos);
    }

    @Override
    public void onAttacked(@NotNull World world, @NotNull TilePos tilePos, @NotNull Player player, @NotNull Side side, double xHit, double yHit) {
        if (!world.isClientSide) {
            this.triggerNote(world, tilePos);
        }
    }

    public void changePitch(@NotNull World world, @NotNull TilePos tilePos, int delta) {
        int meta = world.getBlockData(tilePos);
        world.setBlockData(tilePos, BlockLogicNote.setNote(meta, (BlockLogicNote.getNote(meta) + 25 + delta) % 25));
    }

    public void triggerNote(@NotNull World world, @NotNull TilePos tilePos) {
        if (world.isBlockOpaqueCube((TilePos)tilePos.up())) {
            return;
        }
        world.triggerEvent(tilePos, Instrument.getInstrumentFromBlock(world.getBlock((TilePos)((TilePos)tilePos.down()))).index, BlockLogicNote.getNote(world.getBlockData(tilePos)));
    }

    public static int setNote(int data, int note) {
        return data & 0xFFFFFFC0 | note & 0x3F;
    }

    public static int getNote(int data) {
        return data & 0x3F;
    }

    public static boolean isPowered(int data) {
        return (data & 0x80) != 0;
    }

    public static int setPowered(int data, boolean flag) {
        if (flag) {
            return data | 0x80;
        }
        return data & 0xFFFFFF7F;
    }

    @Override
    public void triggerEvent(@NotNull World world, @NotNull TilePos tilePos, int index, int data) {
        float f = (float)Math.pow(2.0, (double)(data - 12) / 12.0);
        String s = Instrument.getInstrumentFromIndex((int)index).soundKey;
        world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)tilePos.x + 0.5, (double)tilePos.y + 0.5, (double)tilePos.z + 0.5, "note." + s, 3.0f, f);
        world.spawnParticle("note", (double)tilePos.x + 0.5, (double)tilePos.y + 1.2, (double)tilePos.z + 0.5, 0.0, 0.0, 0.0, data);
    }

    public record Instrument(int index, String soundKey) {
        public static final Int2ObjectMap<Instrument> instrumentMap = new Int2ObjectArrayMap<Instrument>();
        public static Instrument DEFAULT;
        public static final Instrument BD;
        public static final Instrument SNARE;
        public static final Instrument HAT;
        public static final Instrument BASS_ATTACK;
        public static final Instrument HARP;
        public static final Instrument CHANT;
        public static final Instrument DRUM_STEEL;
        public static final Instrument CHIP_TRIANGLE;
        public static final Instrument GUITAR_ELECTRIC;
        public static final Instrument CELESTA;
        public static final Instrument WOOD_BLOCK;

        public Instrument(int index, String soundKey) {
            this.index = index;
            this.soundKey = soundKey;
            assert (!instrumentMap.containsKey(index)) : "Only 1 instrument can be assigned per index!";
            instrumentMap.put(index, this);
        }

        @NotNull
        public static Instrument getInstrumentFromIndex(int index) {
            if (instrumentMap.containsKey(index)) {
                return (Instrument)instrumentMap.get(index);
            }
            LOGGER.warn("No instrument assign to index '{}'!", (Object)index);
            return instrumentMap.getOrDefault(index, DEFAULT);
        }

        @NotNull
        public static Instrument getInstrumentFromBlock(@Nullable Block<?> block) {
            if (block == null) {
                return DEFAULT;
            }
            if (block == Blocks.BLOCK_OLIVINE) {
                return CHIP_TRIANGLE;
            }
            if (block == Blocks.BLOCK_REDSTONE || block == Blocks.PUMPKIN_REDSTONE || block.getLogic() instanceof BlockLogicOreRedstone) {
                return GUITAR_ELECTRIC;
            }
            if (block == Blocks.CHEST_PLANKS_OAK || block == Blocks.CHEST_PLANKS_OAK_PAINTED) {
                return WOOD_BLOCK;
            }
            Material material = block.getMaterial();
            if (material == Material.permafrost || material == Material.ice) {
                return CELESTA;
            }
            if (material.isStone()) {
                return BD;
            }
            if (material == Material.sand) {
                return SNARE;
            }
            if (material == Material.glass) {
                return HAT;
            }
            if (material == Material.wood) {
                return BASS_ATTACK;
            }
            if (material == Material.soulsand) {
                return CHANT;
            }
            if (material == Material.steel) {
                return DRUM_STEEL;
            }
            return DEFAULT;
        }

        static {
            HARP = new Instrument(0, "harp");
            BD = new Instrument(1, "bd");
            SNARE = new Instrument(2, "snare");
            HAT = new Instrument(3, "hat");
            BASS_ATTACK = new Instrument(4, "bassattack");
            CHANT = new Instrument(5, "chant");
            DRUM_STEEL = new Instrument(6, "drum_steel");
            CHIP_TRIANGLE = new Instrument(7, "chip_triangle");
            GUITAR_ELECTRIC = new Instrument(8, "guitar_electric");
            CELESTA = new Instrument(9, "celesta");
            WOOD_BLOCK = new Instrument(10, "wood_block");
            DEFAULT = HARP;
        }
    }
}

