/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.support.FullSupport;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicSpikes
extends BlockLogic {
    public static final int MASK_POWERED = 1;

    public BlockLogicSpikes(Block<?> block, Material mat) {
        super(block, mat);
        float thickness = 0.1875f;
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, thickness, 1.0);
    }

    @Override
    public void onPlacedOnSide(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side, double xHit, double yHit) {
        if (world.isClientSide) {
            return;
        }
        int meta = world.getBlockData(tilePos);
        if (world.hasNeighborSignal(tilePos)) {
            world.setBlockDataNotify(tilePos, meta | 1);
        }
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(Blocks.SPIKES)};
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePos tilePos, int id) {
        if (world.isClientSide) {
            return;
        }
        int meta = world.getBlockData(tilePos);
        boolean wasPowered = (meta & 1) != 0;
        boolean isPowered = world.hasNeighborSignal(tilePos);
        if (isPowered != wasPowered) {
            if (isPowered) {
                world.playBlockEvent(null, tilePos, 1007, 0);
                world.setBlockDataNotify(tilePos, 1);
            } else {
                world.playBlockEvent(null, tilePos, 1006, 0);
                world.setBlockDataNotify(tilePos, 0);
            }
        }
    }

    @Override
    @Nullable
    public AABB getCollisionAABB(@NotNull WorldSource source, @NotNull TilePos tilePos) {
        double thickness = 0.1875;
        return AABB.fromPool(tilePos.x, tilePos.y, tilePos.z, tilePos.x + 1, (double)tilePos.y + thickness, tilePos.z + 1);
    }

    @Override
    public void onEntityCollision(@NotNull World world, @NotNull TilePos tilePos, @NotNull Entity entity) {
        int metaData = world.getBlockData(tilePos);
        if (BlockLogicSpikes.isSpikesUp(metaData) && entity instanceof Mob) {
            if (entity instanceof Player && entity.isSneaking()) {
                if (entity.tickCount % 20 == 0) {
                    entity.hurt(null, 1, DamageType.GENERIC);
                }
                entity.yd = 0.0;
                return;
            }
            if (entity.tickCount % 10 == 0) {
                entity.hurt(null, 2, DamageType.GENERIC);
            }
            entity.stuckInSpikes = true;
        }
    }

    @Override
    public boolean collidesWithEntity(@NotNull Entity entity, @NotNull World world, @NotNull TilePos tilePos) {
        return !(entity instanceof EntityItem);
    }

    public static boolean isSpikesUp(int i) {
        return (i & 1) == 0;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side) {
        return side == Side.BOTTOM ? FullSupport.INSTANCE : PartialSupport.INSTANCE;
    }
}

