/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.IPainted;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicWool
extends BlockLogic
implements IPainted {
    public BlockLogicWool(@NotNull Block<?> block) {
        super(block, Material.cloth);
    }

    @Override
    public int getPlacedData(@Nullable Player player, @NotNull ItemStack itemStack, @NotNull World world, @NotNull TilePos tilePos, @NotNull Side side, double xHit, double yHit) {
        return itemStack.getMetadata() & 0xF;
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(this, 1, data)};
    }

    @Override
    @NotNull
    public DyeColor fromMetadata(int meta) {
        return DyeColor.colorFromBlockMeta(meta);
    }

    @Override
    public int toMetadata(@NotNull DyeColor color) {
        return color.blockMeta;
    }

    @Override
    public int stripColorFromMetadata(int meta) {
        return 0;
    }

    @Override
    public void removeDye(@NotNull World world, @NotNull TilePos tilePos) {
        world.setBlockDataNotify(tilePos, 0);
    }
}

