/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.support;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ISupportable {
    @NotNull
    public ISupport getSupportConstraint(@NotNull World var1, @NotNull TilePos var2, @NotNull Side var3);

    default public boolean isSupported(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side) {
        @Nullable Block<?> supportingBlock = world.getBlock((TilePos)tilePos.add(side.getDirection()));
        if (supportingBlock == null) {
            return false;
        }
        @NotNull ISupport supporting = supportingBlock.getSupport(world, (TilePos)tilePos.add(side.getDirection()), side.getOpposite());
        @NotNull ISupport supported = this.getSupportConstraint(world, tilePos, side);
        return supporting.canSupport(supported, side.getOpposite());
    }
}

