/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.current.wire;

import java.util.Arrays;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.current.util.BlockState;
import net.minecraft.core.current.wire.WireHandler;
import net.minecraft.core.current.wire.WireNode;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;

class Node {
    private static final int CONDUCTOR = 1;
    private static final int SOURCE = 2;
    final World world;
    final Node[] neighbors;
    TilePos pos;
    BlockState state;
    boolean invalid;
    private int flags;
    Node prev_node;
    Node next_node;
    int priority;
    WireNode neighborWire;

    Node(World world) {
        this.world = world;
        this.neighbors = new Node[WireHandler.Directions.ALL.length];
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node node = (Node)obj;
        return this.world == node.world && this.pos.equals(node.pos);
    }

    public int hashCode() {
        return this.pos.hashCode();
    }

    Node set(TilePos pos, BlockState state, boolean clearNeighbors) {
        if (state.is(Blocks.WIRE_REDSTONE)) {
            throw new IllegalStateException("Cannot update a regular Node to a WireNode!");
        }
        if (clearNeighbors) {
            Arrays.fill(this.neighbors, null);
        }
        this.pos = pos;
        this.state = state;
        this.invalid = false;
        this.flags = 0;
        if (this.state.isConductor()) {
            this.flags |= 1;
        }
        if (this.state.isSignalSource()) {
            this.flags |= 2;
        }
        return this;
    }

    int priority() {
        return this.neighborWire.priority;
    }

    public boolean isWire() {
        return false;
    }

    public boolean isConductor() {
        return (this.flags & 1) != 0;
    }

    public boolean isSignalSource() {
        return (this.flags & 2) != 0;
    }

    public WireNode asWire() {
        throw new UnsupportedOperationException("Not a WireNode!");
    }
}

