/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBucket
extends Item {
    @Nullable
    private final Block<?> blockToPlace;

    public ItemBucket(@NotNull String name, @NotNull String namespaceId, int id, @Nullable Block<?> blockToPlace) {
        super(name, namespaceId, id);
        this.maxStackSize = 1;
        this.blockToPlace = blockToPlace;
    }

    @Override
    @Nullable
    public ItemStack onUse(@NotNull ItemStack selfStack, @NotNull World world, @NotNull Player player) {
        if (this.blockToPlace == null) {
            return new ItemStack(Items.BUCKET);
        }
        double reachDistance = player.getGamemode().getBlockReachDistance();
        HitResult rayCast = player.rayCast(reachDistance, 1.0f, false, false, false);
        if (!(rayCast instanceof HitResult.Tile)) {
            return selfStack;
        }
        HitResult.Tile hitTile = (HitResult.Tile)rayCast;
        TilePos rayCastPos = new TilePos(hitTile.tilePos);
        if (!world.canMineBlock(player, rayCastPos)) {
            return selfStack;
        }
        Block<?> block = world.getBlock(rayCastPos);
        if (block != null && !block.hasTag(BlockTags.PLACE_OVERWRITES) && !block.hasTag(BlockTags.BROKEN_BY_FLUIDS)) {
            Side side = hitTile.side;
            rayCastPos.x += side.getOffsetX();
            rayCastPos.y += side.getOffsetY();
            rayCastPos.z += side.getOffsetZ();
        }
        if (rayCastPos.y < 0 || rayCastPos.y >= world.getHeightBlocks()) {
            return selfStack;
        }
        if (world.isAirBlock(rayCastPos) || !world.getBlockMaterial(rayCastPos).isSolid()) {
            if (this.blockToPlace == Blocks.FLUID_WATER_FLOWING) {
                world.playSoundEffect(player, SoundCategory.WORLD_SOUNDS, (float)rayCastPos.x + 0.5f, (float)rayCastPos.y + 0.5f, (float)rayCastPos.z + 0.5f, "liquid.splash", 0.5f, 1.0f);
            }
            player.swingItem();
            Block<?> block1 = world.getBlock(rayCastPos);
            if (block1 != null) {
                block1.dropWithCause(world, EnumDropCause.WORLD, rayCastPos, world.getBlockData(rayCastPos), null, null);
            }
            world.setBlockIdDataNotify(rayCastPos, this.blockToPlace.id(), 0);
            if (player.getGamemode().consumeBlocks()) {
                return new ItemStack(Items.BUCKET);
            }
        }
        return selfStack;
    }

    @Override
    public void onUseByActivator(@NotNull ItemStack selfStack, @NotNull World world, @NotNull TileEntityActivator activator, @NotNull Random random, @NotNull TilePos blockPos, @NotNull Direction direction, double offX, double offY, double offZ) {
        if (this.blockToPlace == null) {
            selfStack.itemID = Items.BUCKET.id;
            return;
        }
        TilePos posAhead = (TilePos)blockPos.add(direction);
        Block<?> b = world.getBlock(posAhead);
        if (b == null || BlockTags.PLACE_OVERWRITES.appliesTo(b) || BlockTags.BROKEN_BY_FLUIDS.appliesTo(b)) {
            world.setBlockIdNotify(posAhead, this.blockToPlace.id());
            selfStack.itemID = Items.BUCKET.id;
        }
    }
}

