/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.util.phys;

import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class HitResult {
    @NotNull
    public final Vec3 location;

    public HitResult(@NotNull Vec3 location) {
        this.location = (Vec3)location.copyPooled();
    }

    public double distanceToSquared(@NotNull net.minecraft.core.entity.Entity entity) {
        double diffX = this.location.x - entity.x;
        double diffY = this.location.y - entity.y;
        double diffZ = this.location.z - entity.z;
        return diffX * diffX + diffY * diffY + diffZ * diffZ;
    }

    public double distanceTo(@NotNull net.minecraft.core.entity.Entity entity) {
        return Math.sqrt(this.distanceToSquared(entity));
    }

    public static final class Clip
    extends HitResult {
        @NotNull
        public final Side side;

        public Clip(@NotNull Side side, @NotNull Vec3 vec3) {
            super(vec3);
            this.side = side;
        }
    }

    public static final class Entity
    extends HitResult {
        @NotNull
        public final net.minecraft.core.entity.Entity entity;

        public Entity(@NotNull net.minecraft.core.entity.Entity entity) {
            super(Vec3.fromPool(entity.x, entity.y, entity.z));
            this.entity = entity;
        }
    }

    public static final class Tile
    extends HitResult {
        @NotNull
        public final TilePos tilePos;
        @NotNull
        public final Side side;

        public Tile(@NotNull TilePos tilePos, @NotNull Side side, @NotNull Vec3 vec3) {
            super(vec3);
            this.tilePos = new TilePos(tilePos);
            this.side = side;
        }
    }
}

